/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.crafting;

import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.lib.inventory.ComparableItemStack;
import cofh.lib.util.ComparableItem;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.api.crafting.recipes.ISawmillRecipe;
import cofh.thermalexpansion.item.TEItems;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class SawmillManager {
    private static Map<ComparableItemStackSawmill, RecipeSawmill> recipeMap = new THashMap();
    private static boolean allowOverwrite = false;
    public static final int DEFAULT_ENERGY = 1600;
    private static float logMultiplier = 1.5f;

    public static RecipeSawmill getRecipe(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        ComparableItemStackSawmill comparableItemStackSawmill = new ComparableItemStackSawmill(itemStack);
        RecipeSawmill recipeSawmill = recipeMap.get((Object)comparableItemStackSawmill);
        if (recipeSawmill == null) {
            ((ComparableItem)comparableItemStackSawmill).metadata = Short.MAX_VALUE;
            recipeSawmill = recipeMap.get((Object)comparableItemStackSawmill);
        }
        return recipeSawmill;
    }

    public static boolean recipeExists(ItemStack itemStack) {
        return SawmillManager.getRecipe(itemStack) != null;
    }

    public static RecipeSawmill[] getRecipeList() {
        return recipeMap.values().toArray(new RecipeSawmill[0]);
    }

    public static void addDefaultRecipes() {
        SawmillManager.addRecipe(2400, new ItemStack((Block)Blocks.field_150486_ae), new ItemStack(Blocks.field_150344_f, 8));
        SawmillManager.addRecipe(2400, new ItemStack(Blocks.field_150462_ai), new ItemStack(Blocks.field_150344_f, 4));
        SawmillManager.addRecipe(2400, new ItemStack(Items.field_151155_ap), new ItemStack(Blocks.field_150344_f, 2));
        SawmillManager.addRecipe(2400, new ItemStack(Items.field_151135_aq), new ItemStack(Blocks.field_150344_f, 6));
        SawmillManager.addRecipe(2400, new ItemStack(Blocks.field_150452_aw), new ItemStack(Blocks.field_150344_f, 2));
        SawmillManager.addRecipe(2400, new ItemStack(Blocks.field_150415_aT), new ItemStack(Blocks.field_150344_f, 3));
        SawmillManager.addRecipe(2400, new ItemStack(Blocks.field_150396_be), new ItemStack(Blocks.field_150344_f, 2), TEItems.sawdust);
        SawmillManager.addRecipe(800, new ItemStack(Blocks.field_150471_bO), new ItemStack(Blocks.field_150344_f, 1));
        SawmillManager.addRecipe(1200, new ItemStack(Items.field_151054_z, 2), new ItemStack(Blocks.field_150344_f, 1), TEItems.sawdust, 12);
        SawmillManager.addRecipe(2400, new ItemStack(Items.field_151104_aV), new ItemStack(Blocks.field_150344_f, 3), new ItemStack(Blocks.field_150325_L, 3));
        SawmillManager.addRecipe(2400, new ItemStack(Blocks.field_150342_X), new ItemStack(Blocks.field_150344_f, 6), new ItemStack(Items.field_151122_aG, 3));
        SawmillManager.addRecipe(2400, new ItemStack(Blocks.field_150323_B), new ItemStack(Blocks.field_150344_f, 8), new ItemStack(Items.field_151137_ax, 1));
        SawmillManager.addRecipe(2400, new ItemStack(Blocks.field_150421_aI), new ItemStack(Blocks.field_150344_f, 8), new ItemStack(Items.field_151045_i, 1));
        SawmillManager.addRecipe(2400, new ItemStack(Items.field_151124_az), new ItemStack(Blocks.field_150344_f, 5));
        SawmillManager.addRecipe(1600, new ItemStack(Items.field_151041_m), new ItemStack(Blocks.field_150344_f, 1), TEItems.sawdust, 12);
        SawmillManager.addRecipe(1600, new ItemStack(Items.field_151038_n), new ItemStack(Blocks.field_150344_f, 1), TEItems.sawdust, 25);
        SawmillManager.addRecipe(1600, new ItemStack(Items.field_151039_o), new ItemStack(Blocks.field_150344_f, 2), TEItems.sawdust, 25);
        SawmillManager.addRecipe(1600, new ItemStack(Items.field_151053_p), new ItemStack(Blocks.field_150344_f, 2), TEItems.sawdust, 25);
        SawmillManager.addRecipe(1600, new ItemStack(Items.field_151017_I), new ItemStack(Blocks.field_150344_f, 1), TEItems.sawdust, 25);
        SawmillManager.addRecipe(3200, new ItemStack(Blocks.field_150476_ad, 2), new ItemStack(Blocks.field_150344_f, 3, 0));
        SawmillManager.addRecipe(3200, new ItemStack(Blocks.field_150485_bF, 2), new ItemStack(Blocks.field_150344_f, 3, 1));
        SawmillManager.addRecipe(3200, new ItemStack(Blocks.field_150487_bG, 2), new ItemStack(Blocks.field_150344_f, 3, 2));
        SawmillManager.addRecipe(3200, new ItemStack(Blocks.field_150481_bH, 2), new ItemStack(Blocks.field_150344_f, 3, 3));
        SawmillManager.addRecipe(3200, new ItemStack(Blocks.field_150400_ck, 2), new ItemStack(Blocks.field_150344_f, 3, 4));
        SawmillManager.addRecipe(3200, new ItemStack(Blocks.field_150401_cl, 2), new ItemStack(Blocks.field_150344_f, 3, 5));
        SawmillManager.addRecipe(800, new ItemStack(Blocks.field_150440_ba), new ItemStack(Items.field_151127_ba, 9));
        SawmillManager.addRecipe(800, new ItemStack(Blocks.field_150442_at), new ItemStack(Blocks.field_150347_e, 1), TEItems.sawdust, 12);
        SawmillManager.addRecipe(800, new ItemStack(Blocks.field_150429_aA), new ItemStack(Items.field_151137_ax, 1), TEItems.sawdust, 12);
        SawmillManager.addRecipe(800, new ItemStack(Items.field_151159_an), new ItemStack(Blocks.field_150325_L, 1), ItemHelper.cloneStack((ItemStack)TEItems.sawdust, (int)2));
        SawmillManager.addRecipe(800, new ItemStack(Items.field_151160_bD), new ItemStack(Items.field_151116_aA, 1), ItemHelper.cloneStack((ItemStack)TEItems.sawdust, (int)2));
        SawmillManager.addRecipe(1600, new ItemStack((Item)Items.field_151024_Q), new ItemStack(Items.field_151116_aA, 3), new ItemStack(Items.field_151116_aA, 1), 10);
        SawmillManager.addRecipe(2400, new ItemStack((Item)Items.field_151027_R), new ItemStack(Items.field_151116_aA, 6), new ItemStack(Items.field_151116_aA, 1), 25);
        SawmillManager.addRecipe(2000, new ItemStack((Item)Items.field_151026_S), new ItemStack(Items.field_151116_aA, 5), new ItemStack(Items.field_151116_aA, 1), 15);
        SawmillManager.addRecipe(1600, new ItemStack((Item)Items.field_151021_T), new ItemStack(Items.field_151116_aA, 3), new ItemStack(Items.field_151116_aA, 1), 5);
    }

    public static void loadRecipes() {
        SawmillManager.addAllLogs();
        if (ItemHelper.oreNameExists((String)"woodRubber")) {
            if (ItemHelper.oreNameExists((String)"itemRawRubber")) {
                SawmillManager.addRecipe(1200, (ItemStack)OreDictionary.getOres((String)"woodRubber").get(0), new ItemStack(Blocks.field_150344_f, 5, 3), (ItemStack)OreDictionary.getOres((String)"itemRawRubber").get(0), 50);
            } else if (ItemHelper.oreNameExists((String)"itemRubber")) {
                SawmillManager.addRecipe(1200, (ItemStack)OreDictionary.getOres((String)"woodRubber").get(0), new ItemStack(Blocks.field_150344_f, 5, 3), (ItemStack)OreDictionary.getOres((String)"itemRubber").get(0), 50);
            } else {
                SawmillManager.addRecipe(1200, (ItemStack)OreDictionary.getOres((String)"woodRubber").get(0), new ItemStack(Blocks.field_150344_f, 5, 3));
            }
        }
    }

    public static void refreshRecipes() {
        THashMap tHashMap = new THashMap(recipeMap.size());
        for (Map.Entry<ComparableItemStackSawmill, RecipeSawmill> entry : recipeMap.entrySet()) {
            RecipeSawmill recipeSawmill = entry.getValue();
            tHashMap.put(new ComparableItemStackSawmill(recipeSawmill.input), recipeSawmill);
        }
        recipeMap.clear();
        recipeMap = tHashMap;
    }

    public static boolean addTERecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, int n2) {
        if (itemStack == null || itemStack2 == null || n <= 0) {
            return false;
        }
        RecipeSawmill recipeSawmill = new RecipeSawmill(itemStack, itemStack2, itemStack3, n2, n);
        recipeMap.put(new ComparableItemStackSawmill(itemStack), recipeSawmill);
        return true;
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, int n2, boolean bl) {
        if (itemStack == null || itemStack2 == null || n <= 0 || !(allowOverwrite & bl) && SawmillManager.recipeExists(itemStack)) {
            return false;
        }
        RecipeSawmill recipeSawmill = new RecipeSawmill(itemStack, itemStack2, itemStack3, n2, n);
        recipeMap.put(new ComparableItemStackSawmill(itemStack), recipeSawmill);
        return true;
    }

    public static boolean removeRecipe(ItemStack itemStack) {
        return recipeMap.remove((Object)new ComparableItemStackSawmill(itemStack)) != null;
    }

    public static void addAllLogs() {
        Container container = new Container(){

            public boolean func_75145_c(EntityPlayer entityPlayer) {
                return false;
            }
        };
        InventoryCrafting inventoryCrafting = new InventoryCrafting(container, 3, 3);
        for (int i = 0; i < 9; ++i) {
            inventoryCrafting.func_70299_a(i, null);
        }
        ArrayList arrayList = OreDictionary.getOres((String)"logWood");
        for (int i = 0; i < arrayList.size(); ++i) {
            ItemStack itemStack;
            ItemStack itemStack2;
            ItemStack itemStack3 = (ItemStack)arrayList.get(i);
            if (ItemHelper.getItemDamage((ItemStack)itemStack3) == Short.MAX_VALUE) {
                for (int j = 0; j < 16; ++j) {
                    itemStack2 = ItemHelper.cloneStack((ItemStack)itemStack3, (int)1);
                    itemStack2.func_77964_b(j);
                    inventoryCrafting.func_70299_a(0, itemStack2);
                    itemStack = ItemHelper.findMatchingRecipe((InventoryCrafting)inventoryCrafting, null);
                    if (itemStack == null) continue;
                    ItemStack itemStack4 = itemStack.func_77946_l();
                    itemStack4.field_77994_a = (int)((float)itemStack4.field_77994_a * logMultiplier);
                    SawmillManager.addRecipe(800, itemStack2, itemStack4, TEItems.sawdust);
                }
                continue;
            }
            ItemStack itemStack5 = ItemHelper.cloneStack((ItemStack)itemStack3, (int)1);
            inventoryCrafting.func_70299_a(0, itemStack5);
            itemStack2 = ItemHelper.findMatchingRecipe((InventoryCrafting)inventoryCrafting, null);
            if (itemStack2 == null) continue;
            itemStack = itemStack2.func_77946_l();
            itemStack.field_77994_a = (int)((float)itemStack.field_77994_a * logMultiplier);
            SawmillManager.addRecipe(800, itemStack5, itemStack, TEItems.sawdust);
        }
    }

    public static boolean addTERecipe(int n, ItemStack itemStack, ItemStack itemStack2) {
        return SawmillManager.addTERecipe(n, itemStack, itemStack2, null, 0);
    }

    public static boolean addTERecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3) {
        return SawmillManager.addTERecipe(n, itemStack, itemStack2, itemStack3, 100);
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2) {
        return SawmillManager.addRecipe(n, itemStack, itemStack2, false);
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, boolean bl) {
        return SawmillManager.addRecipe(n, itemStack, itemStack2, null, 0, bl);
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3) {
        return SawmillManager.addRecipe(n, itemStack, itemStack2, itemStack3, false);
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, boolean bl) {
        return SawmillManager.addRecipe(n, itemStack, itemStack2, itemStack3, 100, bl);
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, int n2) {
        return SawmillManager.addRecipe(n, itemStack, itemStack2, itemStack3, n2, false);
    }

    static {
        allowOverwrite = ThermalExpansion.config.get("RecipeManagers.Sawmill", "AllowRecipeOverwrite", false);
        String string = "RecipeManagers.Sawmill.Log";
        String string2 = "This sets the default rate for Log->Plank conversion. This number is used in all automatically generated recipes.";
        logMultiplier = MathHelper.clamp((float)((float)ThermalExpansion.config.get(string, "DefaultMultiplier", (double)logMultiplier, string2)), (float)1.0f, (float)64.0f);
    }

    public static class ComparableItemStackSawmill
    extends ComparableItemStack {
        static final String ORE = "ore";
        static final String INGOT = "ingot";
        static final String NUGGET = "nugget";
        static final String RUBBER = "woodRubber";

        public static boolean safeOreType(String string) {
            return string.startsWith(ORE) || string.startsWith(INGOT) || string.startsWith(NUGGET) || string.equals(RUBBER);
        }

        public static int getOreID(ItemStack itemStack) {
            ArrayList arrayList = OreDictionaryArbiter.getAllOreIDs((ItemStack)itemStack);
            if (arrayList != null) {
                int n = 0;
                int n2 = arrayList.size();
                while (n < n2) {
                    int n3;
                    if ((n3 = ((Integer)arrayList.get(n++)).intValue()) == -1 || !ComparableItemStackSawmill.safeOreType(ItemHelper.oreProxy.getOreName(n3))) continue;
                    return n3;
                }
            }
            return -1;
        }

        public static int getOreID(String string) {
            if (!ComparableItemStackSawmill.safeOreType(string)) {
                return -1;
            }
            return ItemHelper.oreProxy.getOreID(string);
        }

        public ComparableItemStackSawmill(ItemStack itemStack) {
            super(itemStack);
            this.oreID = ComparableItemStackSawmill.getOreID(itemStack);
        }

        public ComparableItemStackSawmill(Item item, int n, int n2) {
            super(item, n, n2);
            this.oreID = ComparableItemStackSawmill.getOreID(this.toItemStack());
        }

        public ComparableItemStackSawmill set(ItemStack itemStack) {
            super.set(itemStack);
            this.oreID = ComparableItemStackSawmill.getOreID(itemStack);
            return this;
        }
    }

    public static class RecipeSawmill
    implements ISawmillRecipe {
        final ItemStack input;
        final ItemStack primaryOutput;
        final ItemStack secondaryOutput;
        final int secondaryChance;
        final int energy;

        RecipeSawmill(ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, int n, int n2) {
            this.input = itemStack;
            this.primaryOutput = itemStack2;
            this.secondaryOutput = itemStack3;
            this.secondaryChance = n;
            this.energy = n2;
            if (itemStack.field_77994_a <= 0) {
                itemStack.field_77994_a = 1;
            }
            if (itemStack2.field_77994_a <= 0) {
                itemStack2.field_77994_a = 1;
            }
            if (itemStack3 != null && itemStack3.field_77994_a <= 0) {
                itemStack3.field_77994_a = 1;
            }
        }

        @Override
        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        @Override
        public ItemStack getPrimaryOutput() {
            return this.primaryOutput.func_77946_l();
        }

        @Override
        public ItemStack getSecondaryOutput() {
            if (this.secondaryOutput == null) {
                return null;
            }
            return this.secondaryOutput.func_77946_l();
        }

        @Override
        public int getSecondaryOutputChance() {
            return this.secondaryChance;
        }

        @Override
        public int getEnergy() {
            return this.energy;
        }
    }
}

