/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.api.energy.EnergyStorage;
import cofh.api.item.IAugmentItem;
import cofh.api.tileentity.IRedstoneControl;
import cofh.core.network.PacketCoFHBase;
import cofh.core.render.IconRegistry;
import cofh.lib.util.TimeTracker;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileAugmentable;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.core.TEProps;
import cofh.thermalexpansion.item.TEAugments;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public abstract class TileMachineBase
extends TileAugmentable {
    protected static final TileTEBase.SideConfig[] defaultSideConfig = new TileTEBase.SideConfig[BlockMachine.Types.values().length];
    protected static final TileTEBase.EnergyConfig[] defaultEnergyConfig = new TileTEBase.EnergyConfig[BlockMachine.Types.values().length];
    protected static final String[] sounds = new String[BlockMachine.Types.values().length];
    protected static final boolean[] enableSound = new boolean[BlockMachine.Types.values().length];
    protected static final int[] lightValue = new int[]{14, 0, 0, 15, 15, 1, 0, 14, 0, 0, 7, 15};
    public static final boolean[] enableSecurity = new boolean[BlockMachine.Types.values().length];
    protected static final int RATE = 500;
    protected static final int[] AUGMENT_COUNT = new int[]{3, 4, 5, 6};
    protected static final int[] ENERGY_CAPACITY = new int[]{2, 3, 4, 5};
    protected static final int[] ENERGY_TRANSFER = new int[]{3, 6, 12, 24};
    protected static final int[] AUTO_TRANSFER = new int[]{8, 16, 32, 64};
    protected static final int[] FLUID_CAPACITY = new int[]{1, 2, 4, 8};
    int processMax;
    int processRem;
    boolean wasActive;
    protected final byte type;
    protected TileTEBase.EnergyConfig energyConfig;
    protected TimeTracker tracker = new TimeTracker();
    boolean augmentSecondaryNull;
    byte level = 0;
    int processMod = 1;
    int energyMod = 1;
    int secondaryChance = 100;

    public static void configure() {
        for (int i = 0; i < BlockMachine.Types.values().length; ++i) {
            String string = StringHelper.titleCase((String)BlockMachine.NAMES[i]);
            String string2 = "Enable this to allow for " + string + "s to be securable.";
            TileMachineBase.enableSecurity[i] = ThermalExpansion.config.get("Security", "Machine." + string + ".Securable", true, string2);
            string2 = "Enable sounds for the " + string + ".";
            TileMachineBase.enableSound[i] = ThermalExpansion.configClient.get("Machine." + string, "Sound.Enable", true, string2);
        }
    }

    public TileMachineBase() {
        this(BlockMachine.Types.FURNACE);
        if (((Object)((Object)this)).getClass() != TileMachineBase.class) {
            throw new IllegalArgumentException();
        }
    }

    public TileMachineBase(BlockMachine.Types types) {
        this.type = (byte)types.ordinal();
        this.sideConfig = defaultSideConfig[this.type];
        this.energyConfig = defaultEnergyConfig[this.type].copy();
        this.energyStorage = new EnergyStorage(this.energyConfig.maxEnergy, this.energyConfig.maxPower * ENERGY_TRANSFER[this.level]);
        this.setDefaultSides();
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return "tile.thermalexpansion.machine." + BlockMachine.NAMES[this.type] + ".name";
    }

    public int getLightValue() {
        return this.isActive ? lightValue[this.type] : 0;
    }

    @Override
    public boolean enableSecurity() {
        return enableSecurity[this.type];
    }

    public void func_145845_h() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return;
        }
        boolean bl = this.isActive;
        if (this.isActive) {
            if (this.processRem > 0) {
                int n = this.calcEnergy();
                this.energyStorage.modifyEnergyStored(-n * this.energyMod);
                this.processRem -= n * this.processMod;
            }
            if (this.canFinish()) {
                this.processFinish();
                this.transferOutput();
                this.transferInput();
                this.energyStorage.modifyEnergyStored(-this.processRem * this.energyMod / this.processMod);
                if (!this.redstoneControlOrDisable() || !this.canStart()) {
                    this.isActive = false;
                    this.wasActive = true;
                    this.tracker.markTime(((TileEntity)this).field_145850_b);
                } else {
                    this.processStart();
                }
            }
        } else if (this.redstoneControlOrDisable()) {
            if (this.timeCheck()) {
                this.transferOutput();
                this.transferInput();
            }
            if (this.timeCheckEighth() && this.canStart()) {
                this.processStart();
                int n = this.calcEnergy();
                this.energyStorage.modifyEnergyStored(-n * this.energyMod);
                this.processRem -= n * this.processMod;
                this.isActive = true;
            }
        }
        this.updateIfChanged(bl);
        this.chargeEnergy();
    }

    protected int calcEnergy() {
        if (!this.isActive) {
            return 0;
        }
        if (this.energyStorage.getEnergyStored() > this.energyConfig.maxPowerLevel) {
            return this.energyConfig.maxPower;
        }
        if (this.energyStorage.getEnergyStored() < this.energyConfig.minPowerLevel) {
            return this.energyConfig.minPower;
        }
        return this.energyStorage.getEnergyStored() / this.energyConfig.energyRamp;
    }

    protected int getMaxInputSlot() {
        return 0;
    }

    protected boolean canStart() {
        return false;
    }

    protected boolean canFinish() {
        return this.processRem > 0 ? false : this.hasValidInput();
    }

    protected boolean hasValidInput() {
        return true;
    }

    protected void processStart() {
    }

    protected void processFinish() {
    }

    protected void transferInput() {
    }

    protected void transferOutput() {
    }

    protected void updateIfChanged(boolean bl) {
        if (bl != this.isActive && !this.wasActive) {
            if (lightValue[this.type] != 0) {
                this.updateLighting();
            }
            this.sendUpdatePacket(Side.CLIENT);
        } else if (this.wasActive && this.tracker.hasDelayPassed(((TileEntity)this).field_145850_b, 100)) {
            this.wasActive = false;
            if (lightValue[this.type] != 0) {
                this.updateLighting();
            }
            this.sendUpdatePacket(Side.CLIENT);
        }
    }

    protected void onLevelChange() {
        this.augments = new ItemStack[AUGMENT_COUNT[this.level]];
        this.augmentStatus = new boolean[this.augments.length];
        this.energyConfig.setParams(this.energyConfig.minPower, this.energyConfig.maxPower, this.energyConfig.maxEnergy * ENERGY_CAPACITY[this.level] / 2);
        this.energyStorage.setCapacity(this.energyConfig.maxEnergy);
        this.energyStorage.setMaxTransfer(this.energyConfig.maxPower * ENERGY_TRANSFER[this.level]);
    }

    @Override
    public int getScaledProgress(int n) {
        if (!this.isActive || this.processMax <= 0 || this.processRem <= 0) {
            return 0;
        }
        return n * (this.processMax - this.processRem) / this.processMax;
    }

    @Override
    public int getScaledSpeed(int n) {
        if (!this.isActive) {
            return 0;
        }
        double d = this.energyStorage.getEnergyStored() / this.energyConfig.energyRamp;
        d = MathHelper.clip((double)d, (double)this.energyConfig.minPower, (double)this.energyConfig.maxPower);
        return MathHelper.round((double)((double)n * d / (double)this.energyConfig.maxPower));
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.processMax = nBTTagCompound.func_74762_e("ProcMax");
        this.processRem = nBTTagCompound.func_74762_e("ProcRem");
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("ProcMax", this.processMax);
        nBTTagCompound.func_74768_a("ProcRem", this.processRem);
    }

    @Override
    public void readAugmentsFromNBT(NBTTagCompound nBTTagCompound) {
        this.level = nBTTagCompound.func_74771_c("Level");
        this.onLevelChange();
        NBTTagList nBTTagList = nBTTagCompound.func_150295_c("Augments", 10);
        for (int i = 0; i < nBTTagList.func_74745_c(); ++i) {
            NBTTagCompound nBTTagCompound2 = nBTTagList.func_150305_b(i);
            int n = nBTTagCompound2.func_74762_e("Slot");
            if (n < 0 || n >= this.augments.length) continue;
            this.augments[n] = ItemStack.func_77949_a((NBTTagCompound)nBTTagCompound2);
        }
    }

    @Override
    public void writeAugmentsToNBT(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74774_a("Level", this.level);
        if (this.augments.length <= 0) {
            return;
        }
        NBTTagList nBTTagList = new NBTTagList();
        for (int i = 0; i < this.augments.length; ++i) {
            if (this.augments[i] == null) continue;
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            nBTTagCompound2.func_74768_a("Slot", i);
            this.augments[i].func_77955_b(nBTTagCompound2);
            nBTTagList.func_74742_a((NBTBase)nBTTagCompound2);
        }
        nBTTagCompound.func_74782_a("Augments", (NBTBase)nBTTagList);
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addByte(this.level);
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase packetCoFHBase = super.getGuiPacket();
        packetCoFHBase.addInt(this.processMax);
        packetCoFHBase.addInt(this.processRem);
        packetCoFHBase.addInt(this.processMod);
        packetCoFHBase.addInt(this.energyMod);
        return packetCoFHBase;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase packetCoFHBase) {
        super.handleGuiPacket(packetCoFHBase);
        this.processMax = packetCoFHBase.getInt();
        this.processRem = packetCoFHBase.getInt();
        this.processMod = packetCoFHBase.getInt();
        this.energyMod = packetCoFHBase.getInt();
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        if (!bl) {
            byte by = this.level;
            this.level = packetCoFHBase.getByte();
            if (by != this.level) {
                this.onLevelChange();
            }
        } else {
            packetCoFHBase.getByte();
        }
    }

    @Override
    protected boolean installAugment(int n) {
        int n2;
        IAugmentItem iAugmentItem = (IAugmentItem)this.augments[n].func_77973_b();
        boolean bl = false;
        if (iAugmentItem.getAugmentLevel(this.augments[n], TEAugments.MACHINE_SECONDARY) > 0) {
            n2 = Math.min(TEAugments.NUM_MACHINE_SECONDARY, iAugmentItem.getAugmentLevel(this.augments[n], TEAugments.MACHINE_SECONDARY));
            if (n2 > this.level) {
                return false;
            }
            if (this.hasDuplicateAugment(TEAugments.MACHINE_SECONDARY, n2, n)) {
                return false;
            }
            if (this.hasAugmentChain(TEAugments.MACHINE_SECONDARY, n2)) {
                this.secondaryChance -= TEAugments.MACHINE_SECONDARY_MOD[n2];
                bl = true;
            } else {
                return false;
            }
        }
        if (iAugmentItem.getAugmentLevel(this.augments[n], TEAugments.MACHINE_SPEED) > 0) {
            n2 = Math.min(TEAugments.NUM_MACHINE_SPEED, iAugmentItem.getAugmentLevel(this.augments[n], TEAugments.MACHINE_SPEED));
            if (n2 > this.level) {
                return false;
            }
            if (this.hasDuplicateAugment(TEAugments.MACHINE_SPEED, n2, n)) {
                return false;
            }
            if (this.hasAugmentChain(TEAugments.MACHINE_SPEED, n2)) {
                this.processMod = Math.max(this.processMod, TEAugments.MACHINE_SPEED_PROCESS_MOD[n2]);
                this.energyMod = Math.max(this.energyMod, TEAugments.MACHINE_SPEED_ENERGY_MOD[n2]);
                bl = true;
            } else {
                return false;
            }
        }
        if (iAugmentItem.getAugmentLevel(this.augments[n], TEAugments.ENERGY_STORAGE) > 0) {
            n2 = Math.min(TEAugments.NUM_ENERGY_STORAGE, iAugmentItem.getAugmentLevel(this.augments[n], TEAugments.ENERGY_STORAGE));
            if (n2 > this.level) {
                return false;
            }
            if (this.hasDuplicateAugment(TEAugments.ENERGY_STORAGE, n2, n)) {
                return false;
            }
            if (this.hasAugmentChain(TEAugments.ENERGY_STORAGE, n2)) {
                this.energyStorage.setCapacity(Math.max(this.energyStorage.getMaxEnergyStored(), this.energyConfig.maxEnergy * TEAugments.ENERGY_STORAGE_MOD[n2]));
                bl = true;
            } else {
                return false;
            }
        }
        if (iAugmentItem.getAugmentLevel(this.augments[n], TEAugments.MACHINE_NULL) > 0) {
            this.augmentSecondaryNull = true;
            bl = true;
        }
        if (iAugmentItem.getAugmentLevel(this.augments[n], TEAugments.GENERAL_AUTO_OUTPUT) > 0) {
            this.augmentAutoOutput = true;
            bl = true;
        }
        if (iAugmentItem.getAugmentLevel(this.augments[n], TEAugments.GENERAL_AUTO_INPUT) > 0) {
            this.augmentAutoInput = true;
            bl = true;
        }
        if (iAugmentItem.getAugmentLevel(this.augments[n], TEAugments.GENERAL_RECONFIG_SIDES) > 0) {
            this.augmentReconfigSides = true;
            bl = true;
        }
        if (iAugmentItem.getAugmentLevel(this.augments[n], TEAugments.GENERAL_REDSTONE_CONTROL) > 0) {
            this.augmentRedstoneControl = true;
            bl = true;
        }
        return bl;
    }

    @Override
    protected void onInstalled() {
        if (!this.augmentReconfigSides) {
            this.setDefaultSides();
            this.sideCache[this.facing] = 0;
        }
        if (!this.augmentRedstoneControl) {
            this.rsMode = IRedstoneControl.ControlMode.DISABLED;
        }
        if (this.isActive && this.energyStorage.getMaxEnergyStored() > 0 && this.processRem * this.energyMod / this.processMod > this.energyStorage.getEnergyStored()) {
            this.processRem = 0;
            this.isActive = false;
            this.wasActive = true;
            this.tracker.markTime(((TileEntity)this).field_145850_b);
        }
    }

    @Override
    protected void resetAugments() {
        super.resetAugments();
        this.augmentSecondaryNull = false;
        this.processMod = 1;
        this.energyMod = 1;
        this.secondaryChance = 100;
    }

    @Override
    public ItemStack func_70298_a(int n, int n2) {
        ItemStack itemStack = super.func_70298_a(n, n2);
        if (ServerHelper.isServerWorld((World)((TileEntity)this).field_145850_b) && n <= this.getMaxInputSlot() && this.isActive && (this.inventory[n] == null || !this.hasValidInput())) {
            this.isActive = false;
            this.wasActive = true;
            this.tracker.markTime(((TileEntity)this).field_145850_b);
            this.processRem = 0;
        }
        return itemStack;
    }

    @Override
    public void func_70299_a(int n, ItemStack itemStack) {
        if (ServerHelper.isServerWorld((World)((TileEntity)this).field_145850_b) && n <= this.getMaxInputSlot() && this.isActive && this.inventory[n] != null && (itemStack == null || !itemStack.func_77969_a(this.inventory[n]) || !this.hasValidInput())) {
            this.isActive = false;
            this.wasActive = true;
            this.tracker.markTime(((TileEntity)this).field_145850_b);
            this.processRem = 0;
        }
        super.func_70299_a(n, itemStack);
    }

    public void func_70296_d() {
        if (this.isActive && !this.hasValidInput()) {
            this.isActive = false;
            this.wasActive = true;
            this.tracker.markTime(((TileEntity)this).field_145850_b);
            this.processRem = 0;
        }
        super.func_70296_d();
    }

    @Override
    public int getInfoEnergyPerTick() {
        return this.calcEnergy() * this.energyMod;
    }

    @Override
    public int getInfoMaxEnergyPerTick() {
        return this.energyConfig.maxPower * this.energyMod;
    }

    @Override
    public boolean setFacing(int n) {
        if (n < 0 || n > 5) {
            return false;
        }
        if (!this.allowYAxisFacing() && n < 2) {
            return false;
        }
        this.sideCache[n] = 0;
        this.facing = (byte)n;
        this.func_70296_d();
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    @Override
    public IIcon getTexture(int n, int n2) {
        if (n2 == 0) {
            if (n == 0) {
                return BlockMachine.machineBottom;
            }
            if (n == 1) {
                return BlockMachine.machineTop;
            }
            return n != this.facing ? BlockMachine.machineSide : (this.isActive ? BlockMachine.machineActive[this.type] : BlockMachine.machineFace[this.type]);
        }
        if (n < 6) {
            return IconRegistry.getIcon((String)TEProps.textureSelection, (int)this.sideConfig.sideTex[this.sideCache[n]]);
        }
        return BlockMachine.machineSide;
    }

    @Override
    public String getSoundName() {
        return enableSound[this.type] ? sounds[this.type] : null;
    }
}

