/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.world.generate;

import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.configuration.configs.ConfigWorld;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class WorldGenMinableCustom
extends WorldGenMinable {
    private final boolean shouldAirGen;
    private final boolean hardAmountCap;
    private final int meta;

    public WorldGenMinableCustom(Block p_i45459_1_, int p_i45459_2_) {
        this(p_i45459_1_, p_i45459_2_, Blocks.field_150348_b);
    }

    public WorldGenMinableCustom(Block p_i45460_1_, int p_i45460_2_, Block p_i45460_3_) {
        this(p_i45460_1_, 0, p_i45460_2_, p_i45460_3_);
    }

    public WorldGenMinableCustom(Block block, int meta, int number, Block target) {
        super(block, meta, number, target);
        this.meta = meta;
        this.shouldAirGen = ConfigWorld.enableAirDebris || block != ModBlocks.ancient_debris;
        this.hardAmountCap = block == ModBlocks.ancient_debris;
    }

    public boolean func_76484_a(World p_76484_1_, Random p_76484_2_, int p_76484_3_, int p_76484_4_, int p_76484_5_) {
        float f = p_76484_2_.nextFloat() * (float)Math.PI;
        double d0 = (float)(p_76484_3_ + 8) + MathHelper.func_76126_a((float)f) * (float)this.field_76541_b / 8.0f;
        double d1 = (float)(p_76484_3_ + 8) - MathHelper.func_76126_a((float)f) * (float)this.field_76541_b / 8.0f;
        double d2 = (float)(p_76484_5_ + 8) + MathHelper.func_76134_b((float)f) * (float)this.field_76541_b / 8.0f;
        double d3 = (float)(p_76484_5_ + 8) - MathHelper.func_76134_b((float)f) * (float)this.field_76541_b / 8.0f;
        double d4 = p_76484_4_ + p_76484_2_.nextInt(3) - 2;
        double d5 = p_76484_4_ + p_76484_2_.nextInt(3) - 2;
        int places = 0;
        for (int l = 0; l <= this.field_76541_b; ++l) {
            double d6 = d0 + (d1 - d0) * (double)l / (double)this.field_76541_b;
            double d7 = d4 + (d5 - d4) * (double)l / (double)this.field_76541_b;
            double d8 = d2 + (d3 - d2) * (double)l / (double)this.field_76541_b;
            double d9 = p_76484_2_.nextDouble() * (double)this.field_76541_b / 16.0;
            double d10 = (double)(MathHelper.func_76126_a((float)((float)l * (float)Math.PI / (float)this.field_76541_b)) + 1.0f) * d9 + 1.0;
            double d11 = (double)(MathHelper.func_76126_a((float)((float)l * (float)Math.PI / (float)this.field_76541_b)) + 1.0f) * d9 + 1.0;
            int i1 = MathHelper.func_76128_c((double)(d6 - d10 / 2.0));
            int j1 = MathHelper.func_76128_c((double)(d7 - d11 / 2.0));
            int k1 = MathHelper.func_76128_c((double)(d8 - d10 / 2.0));
            int l1 = MathHelper.func_76128_c((double)(d6 + d10 / 2.0));
            int i2 = MathHelper.func_76128_c((double)(d7 + d11 / 2.0));
            int j2 = MathHelper.func_76128_c((double)(d8 + d10 / 2.0));
            for (int k2 = i1; k2 <= l1; ++k2) {
                double d12 = ((double)k2 + 0.5 - d6) / (d10 / 2.0);
                if (!(d12 * d12 < 1.0)) continue;
                for (int l2 = j1; l2 <= i2; ++l2) {
                    double d13 = ((double)l2 + 0.5 - d7) / (d11 / 2.0);
                    if (!(d12 * d12 + d13 * d13 < 1.0)) continue;
                    for (int i3 = k1; i3 <= j2; ++i3) {
                        if (!this.canGenerate(p_76484_1_, k2, l2, i3)) continue;
                        if (this.hardAmountCap && places++ >= this.field_76541_b) {
                            return true;
                        }
                        this.setBlock(p_76484_1_, k2, l2, i3, this.field_150519_a, this.meta, 2);
                    }
                }
            }
        }
        return true;
    }

    private boolean canGenerate(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (!block.isReplaceableOreGen(world, x, y, z, this.field_150518_c)) {
            return false;
        }
        if (!this.shouldAirGen) {
            for (EnumFacing facing : EnumFacing.values()) {
                if (!world.func_147437_c(x + facing.func_82601_c(), y + facing.func_96559_d(), z + facing.func_82599_e())) continue;
                return false;
            }
        }
        return true;
    }

    private void setBlock(World world, int x, int y, int z, Block block, int meta, int flag) {
        world.func_147465_d(x, y, z, block, meta, flag);
    }
}

