/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.world.end.dimension;

import cpw.mods.fml.common.eventhandler.Event;
import ganymedes01.etfuturum.blocks.BlockChorusFlower;
import ganymedes01.etfuturum.world.end.gen.WorldGenEndIsland;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorSimplex;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;

public class EndChunkProvider
implements IChunkProvider {
    private Random rand;
    protected static final Block END_STONE = Blocks.field_150377_bs;
    protected static final Block AIR = Blocks.field_150350_a;
    private final NoiseGeneratorOctaves lperlinNoise1;
    private final NoiseGeneratorOctaves lperlinNoise2;
    private final NoiseGeneratorOctaves perlinNoise1;
    public NoiseGeneratorOctaves noiseGen5;
    public NoiseGeneratorOctaves noiseGen6;
    private final World worldObj;
    private final boolean mapFeaturesEnabled;
    private final NoiseGeneratorSimplex islandNoise;
    private double[] buffer;
    private BiomeGenBase[] biomesForGeneration;
    double[] pnr;
    double[] ar;
    double[] br;
    private final WorldGenEndIsland endIslands = new WorldGenEndIsland();

    public EndChunkProvider(World worldObjIn, long seed) {
        this.worldObj = worldObjIn;
        this.mapFeaturesEnabled = true;
        this.rand = new Random(seed);
        this.lperlinNoise1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.lperlinNoise2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.perlinNoise1 = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 10);
        this.noiseGen6 = new NoiseGeneratorOctaves(this.rand, 16);
        this.islandNoise = new NoiseGeneratorSimplex(this.rand);
    }

    public Chunk func_73154_d(int x, int z) {
        Block[] ablock = new Block[32768];
        byte[] meta = new byte[ablock.length];
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.setBlocksInChunk(x, z, ablock);
        this.buildSurfaces(x, z, ablock, this.biomesForGeneration, meta);
        Chunk chunk = new Chunk(this.worldObj, ablock, meta, x, z);
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)this.biomesForGeneration[i].field_76756_M;
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void setBlocksInChunk(int x, int z, Block[] blocks) {
        int i = 2;
        int j = i + 1;
        int k = 33;
        int l = i + 1;
        this.buffer = this.getHeights(this.buffer, x * i, 0, z * i, j, k, l);
        for (int i1 = 0; i1 < i; ++i1) {
            for (int j1 = 0; j1 < i; ++j1) {
                for (int k1 = 0; k1 < 32; ++k1) {
                    double d0 = 0.25;
                    double d1 = this.buffer[((i1 + 0) * l + j1 + 0) * k + k1 + 0];
                    double d2 = this.buffer[((i1 + 0) * l + j1 + 1) * k + k1 + 0];
                    double d3 = this.buffer[((i1 + 1) * l + j1 + 0) * k + k1 + 0];
                    double d4 = this.buffer[((i1 + 1) * l + j1 + 1) * k + k1 + 0];
                    double d5 = (this.buffer[((i1 + 0) * l + j1 + 0) * k + k1 + 1] - d1) * d0;
                    double d6 = (this.buffer[((i1 + 0) * l + j1 + 1) * k + k1 + 1] - d2) * d0;
                    double d7 = (this.buffer[((i1 + 1) * l + j1 + 0) * k + k1 + 1] - d3) * d0;
                    double d8 = (this.buffer[((i1 + 1) * l + j1 + 1) * k + k1 + 1] - d4) * d0;
                    for (int l1 = 0; l1 < 4; ++l1) {
                        double d9 = 0.125;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int i2 = 0; i2 < 8; ++i2) {
                            int j3 = i2 + i1 * 8 << 11 | 0 + j1 * 8 << 7 | k1 * 4 + l1;
                            double d14 = 0.125;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            for (int j2 = 0; j2 < 8; ++j2) {
                                Block iblockstate = AIR;
                                if (d15 > 0.0) {
                                    iblockstate = END_STONE;
                                }
                                blocks[j3] = iblockstate;
                                j3 += 128;
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void buildSurfaces(int x, int z, Block[] blocks, BiomeGenBase[] biomes, byte[] meta) {
        ChunkProviderEvent.ReplaceBiomeBlocks event = new ChunkProviderEvent.ReplaceBiomeBlocks((IChunkProvider)this, x, z, blocks, meta, biomes, this.worldObj);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int k = 1;
                int l = -1;
                Block iblockstate = END_STONE;
                Block iblockstate1 = END_STONE;
                for (int i1 = 127; i1 >= 0; --i1) {
                    int k1 = (j * 16 + i) * 128 + i1;
                    Block iblockstate2 = blocks[k1];
                    if (iblockstate2 == null || iblockstate2.func_149688_o() == Material.field_151579_a) {
                        l = -1;
                        continue;
                    }
                    if (iblockstate2 != Blocks.field_150348_b) continue;
                    if (l == -1) {
                        if (k <= 0) {
                            iblockstate = AIR;
                            iblockstate1 = END_STONE;
                        }
                        l = k;
                        if (i1 >= 0) {
                            blocks[k1] = iblockstate;
                            continue;
                        }
                        blocks[k1] = iblockstate1;
                        continue;
                    }
                    if (l <= 0) continue;
                    --l;
                    blocks[k1] = iblockstate1;
                }
            }
        }
    }

    private float getIslandHeightValue(int p_185960_1_, int p_185960_2_, int p_185960_3_, int p_185960_4_) {
        float f = p_185960_1_ * 2 + p_185960_3_;
        float f1 = p_185960_2_ * 2 + p_185960_4_;
        float f2 = 100.0f - MathHelper.func_76129_c((float)(f * f + f1 * f1)) * 8.0f;
        if (f2 > 80.0f) {
            f2 = 80.0f;
        }
        if (f2 < -100.0f) {
            f2 = -100.0f;
        }
        for (int i = -12; i <= 12; ++i) {
            for (int j = -12; j <= 12; ++j) {
                long k = p_185960_1_ + i;
                long l = p_185960_2_ + j;
                if (k * k + l * l <= 4096L || !(this.islandNoise.func_151605_a((double)k, (double)l) < (double)-0.9f)) continue;
                float f3 = (MathHelper.func_76135_e((float)k) * 3439.0f + MathHelper.func_76135_e((float)l) * 147.0f) % 13.0f + 9.0f;
                f = p_185960_3_ - i * 2;
                f1 = p_185960_4_ - j * 2;
                float f4 = 100.0f - MathHelper.func_76129_c((float)(f * f + f1 * f1)) * f3;
                if (f4 > 80.0f) {
                    f4 = 80.0f;
                }
                if (f4 < -100.0f) {
                    f4 = -100.0f;
                }
                if (!(f4 > f2)) continue;
                f2 = f4;
            }
        }
        return f2;
    }

    public boolean isIslandChunk(int p_185961_1_, int p_185961_2_) {
        return (long)p_185961_1_ * (long)p_185961_1_ + (long)p_185961_2_ * (long)p_185961_2_ > 4096L && this.getIslandHeightValue(p_185961_1_, p_185961_2_, 1, 1) >= 0.0f;
    }

    private double[] getHeights(double[] p_185963_1_, int p_185963_2_, int p_185963_3_, int p_185963_4_, int p_185963_5_, int p_185963_6_, int p_185963_7_) {
        if (p_185963_1_ == null) {
            p_185963_1_ = new double[p_185963_5_ * p_185963_6_ * p_185963_7_];
        }
        double d0 = 684.412;
        double d1 = 684.412;
        this.pnr = this.perlinNoise1.func_76304_a(this.pnr, p_185963_2_, p_185963_3_, p_185963_4_, p_185963_5_, p_185963_6_, p_185963_7_, (d0 *= 2.0) / 80.0, d1 / 160.0, d0 / 80.0);
        this.ar = this.lperlinNoise1.func_76304_a(this.ar, p_185963_2_, p_185963_3_, p_185963_4_, p_185963_5_, p_185963_6_, p_185963_7_, d0, d1, d0);
        this.br = this.lperlinNoise2.func_76304_a(this.br, p_185963_2_, p_185963_3_, p_185963_4_, p_185963_5_, p_185963_6_, p_185963_7_, d0, d1, d0);
        int i = p_185963_2_ / 2;
        int j = p_185963_4_ / 2;
        int k = 0;
        for (int l = 0; l < p_185963_5_; ++l) {
            for (int i1 = 0; i1 < p_185963_7_; ++i1) {
                float f = this.getIslandHeightValue(i, j, l, i1);
                for (int j1 = 0; j1 < p_185963_6_; ++j1) {
                    double d2 = 0.0;
                    double d3 = this.ar[k] / 512.0;
                    double d4 = this.br[k] / 512.0;
                    double d5 = (this.pnr[k] / 10.0 + 1.0) / 2.0;
                    d2 = d5 < 0.0 ? d3 : (d5 > 1.0 ? d4 : d3 + (d4 - d3) * d5);
                    d2 -= 8.0;
                    d2 += (double)f;
                    int k1 = 2;
                    if (j1 > p_185963_6_ / 2 - k1) {
                        double d6 = (float)(j1 - (p_185963_6_ / 2 - k1)) / 64.0f;
                        d6 = MathHelper.func_151237_a((double)d6, (double)0.0, (double)1.0);
                        d2 = d2 * (1.0 - d6) + -3000.0 * d6;
                    }
                    if (j1 < (k1 = 8)) {
                        double d7 = (float)(k1 - j1) / ((float)k1 - 1.0f);
                        d2 = d2 * (1.0 - d7) + -30.0 * d7;
                    }
                    p_185963_1_[k] = d2;
                    ++k;
                }
            }
        }
        return p_185963_1_;
    }

    public boolean func_73149_a(int p_73149_1_, int p_73149_2_) {
        return true;
    }

    public boolean func_73151_a(boolean p_73151_1_, IProgressUpdate p_73151_2_) {
        return true;
    }

    public void func_104112_b() {
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "RandomLevelSource";
    }

    public List func_73155_a(EnumCreatureType creatureType, int x, int p_73155_3_, int z) {
        return this.worldObj.func_72807_a(x, z).func_76747_a(creatureType);
    }

    public ChunkPosition func_147416_a(World p_147416_1_, String p_147416_2_, int p_147416_3_, int p_147416_4_, int p_147416_5_) {
        return null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int p_82695_1_, int p_82695_2_) {
    }

    public Chunk func_73158_c(int x, int z) {
        return this.func_73154_d(x, z);
    }

    public void func_73153_a(IChunkProvider chunkProvider, int x, int z) {
        BlockFalling.field_149832_M = true;
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(chunkProvider, this.worldObj, this.rand, x, z, false));
        int xPos = x * 16;
        int yPos = 0;
        int zPos = z * 16;
        if (this.mapFeaturesEnabled) {
            // empty if block
        }
        this.worldObj.func_72807_a(xPos + 16, zPos + 16).func_76728_a(this.worldObj, this.rand, xPos, zPos);
        long i = (long)x * (long)x + (long)z * (long)z;
        if (i > 4096L) {
            float f = this.getIslandHeightValue(x, z, 1, 1);
            if (f < -20.0f && this.rand.nextInt(14) == 0) {
                this.endIslands.func_76484_a(this.worldObj, this.rand, xPos + (this.rand.nextInt(16) + 8), yPos + (55 + this.rand.nextInt(16)), zPos + (this.rand.nextInt(16) + 8));
                if (this.rand.nextInt(4) == 0) {
                    this.endIslands.func_76484_a(this.worldObj, this.rand, xPos + (this.rand.nextInt(16) + 8), yPos + (55 + this.rand.nextInt(16)), zPos + (this.rand.nextInt(16) + 8));
                }
            }
            if (this.getIslandHeightValue(x, z, 1, 1) > 40.0f) {
                int j = this.rand.nextInt(5);
                for (int k = 0; k < j; ++k) {
                    int k1;
                    int i1;
                    int l = this.rand.nextInt(16) + 8;
                    int j1 = this.worldObj.func_72825_h(xPos + l, zPos + (i1 = this.rand.nextInt(16) + 8));
                    if (j1 <= 0 || !this.worldObj.func_147437_c(xPos + l, yPos + (k1 = j1), zPos + i1) || this.worldObj.func_147439_a(xPos + l, yPos + k1 - 1, zPos + i1) != Blocks.field_150377_bs) continue;
                    BlockChorusFlower.generatePlant(this.worldObj, xPos + l, yPos + k1, zPos + i1, this.rand, 8);
                }
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(chunkProvider, this.worldObj, this.rand, x, z, false));
        BlockFalling.field_149832_M = false;
    }
}

