/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.world;

import cpw.mods.fml.common.IWorldGenerator;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.blocks.BlockChorusFlower;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.configuration.configs.ConfigWorld;
import ganymedes01.etfuturum.world.end.dimension.EndWorldProvider;
import ganymedes01.etfuturum.world.generate.WorldGenDeepslateLayerBlob;
import ganymedes01.etfuturum.world.generate.WorldGenMinableCustom;
import ganymedes01.etfuturum.world.generate.feature.WorldGenAmethystGeode;
import ganymedes01.etfuturum.world.generate.feature.WorldGenFossil;
import ganymedes01.etfuturum.world.structure.MapGenMesaMineshaft;
import ganymedes01.etfuturum.world.structure.OceanMonument;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.lang3.ArrayUtils;

public class EtFuturumWorldGenerator
implements IWorldGenerator {
    public static final EtFuturumWorldGenerator INSTANCE = new EtFuturumWorldGenerator();
    protected final List<WorldGenMinable> stoneGen = new LinkedList<WorldGenMinable>();
    protected final List<WorldGenFlowers> flowers = new LinkedList<WorldGenFlowers>();
    protected final WorldGenMinable copperGen = new WorldGenMinable(ModBlocks.copper_ore, ConfigWorld.maxCopperPerCluster);
    protected final WorldGenMinable magmaGen = new WorldGenMinable(ModBlocks.magma_block, ConfigWorld.maxMagmaPerCluster, Blocks.field_150424_aL);
    protected final WorldGenMinable netherGoldGen = new WorldGenMinable(ModBlocks.nether_gold_ore, ConfigWorld.maxNetherGoldPerCluster, Blocks.field_150424_aL);
    protected final WorldGenMinable debrisGen = new WorldGenMinableCustom(ModBlocks.ancient_debris, ConfigWorld.debrisMax, Blocks.field_150424_aL);
    protected final WorldGenMinable smallDebrisGen = new WorldGenMinableCustom(ModBlocks.ancient_debris, ConfigWorld.smallDebrisMax, Blocks.field_150424_aL);
    protected final WorldGenMinable mesaGoldGen = new WorldGenMinable(Blocks.field_150352_o, 8);
    protected final WorldGenMinable deepslateBlobGen = new WorldGenDeepslateLayerBlob(ConfigWorld.maxDeepslatePerCluster, false);
    protected final WorldGenMinable tuffGen = new WorldGenDeepslateLayerBlob(ConfigWorld.maxTuffPerCluster, true);
    public final MapGenMesaMineshaft mesaMineshaftGen = new MapGenMesaMineshaft();

    protected EtFuturumWorldGenerator() {
        this.stoneGen.add(new WorldGenMinableCustom(ModBlocks.stone, 1, ConfigWorld.maxStonesPerCluster, Blocks.field_150348_b));
        this.stoneGen.add(new WorldGenMinableCustom(ModBlocks.stone, 3, ConfigWorld.maxStonesPerCluster, Blocks.field_150348_b));
        this.stoneGen.add(new WorldGenMinableCustom(ModBlocks.stone, 5, ConfigWorld.maxStonesPerCluster, Blocks.field_150348_b));
        this.flowers.add(new WorldGenFlowers(ModBlocks.lily_of_the_valley));
        this.flowers.add(new WorldGenFlowers(ModBlocks.cornflower));
        this.flowers.add(new WorldGenFlowers(ModBlocks.sweet_berry_bush));
        this.flowers.get(2).func_150550_a(ModBlocks.sweet_berry_bush, 3);
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int y;
        int x;
        if (world.func_72912_H().func_76067_t() != WorldType.field_77138_c || world.func_72912_H().func_82571_y().contains("decoration") || world.field_73011_w.field_76574_g != 0) {
            BiomeGenBase biome;
            Object[] biomeList;
            int z;
            if (ConfigBlocksItems.enableStones && ConfigWorld.maxStonesPerCluster > 0 && world.field_73011_w.field_76574_g != -1 && world.field_73011_w.field_76574_g != 1) {
                for (WorldGenMinable stoneGenerator : this.stoneGen) {
                    for (int i = 0; i < 10; ++i) {
                        this.generateOre(stoneGenerator, world, rand, chunkX, chunkZ, 1.0f, 0, 80);
                    }
                }
            }
            if (ConfigBlocksItems.enableAmethyst && ArrayUtils.contains((int[])ConfigWorld.amethystDimensionBlacklist, (int)world.field_73011_w.field_76574_g) == ConfigWorld.amethystDimensionBlacklistAsWhitelist) {
                x = chunkX * 16 + rand.nextInt(16) + 8;
                z = chunkZ * 16 + rand.nextInt(16) + 8;
                if (ConfigWorld.enableAmethystGeodes && rand.nextInt(ConfigWorld.amethystRarity) == 0) {
                    new WorldGenAmethystGeode().func_76484_a(world, rand, x, rand.nextInt(ConfigWorld.amethystMaxY - 9) + 9, z);
                }
            }
            if (ConfigBlocksItems.enableCopper) {
                this.generateOre(this.copperGen, world, rand, chunkX, chunkZ, 8.0f, 4, 80);
            }
            if (ConfigWorld.enableExtraMesaGold && ArrayUtils.contains((Object[])BiomeDictionary.getTypesForBiome((BiomeGenBase)world.func_72807_a(chunkX * 16, chunkZ * 16)), (Object)BiomeDictionary.Type.MESA)) {
                this.generateOre(this.mesaGoldGen, world, rand, chunkX, chunkZ, 20.0f, 32, 80);
            }
            if (ConfigBlocksItems.enableLilyOfTheValley && ArrayUtils.contains((Object[])(biomeList = BiomeDictionary.getTypesForBiome((BiomeGenBase)(biome = world.func_72807_a(x = chunkX * 16 + rand.nextInt(16) + 8, z = chunkZ * 16 + rand.nextInt(16) + 8)))), (Object)BiomeDictionary.Type.FOREST) && !ArrayUtils.contains((Object[])biomeList, (Object)BiomeDictionary.Type.SNOWY) && world.func_72976_f(x, z) > 0) {
                this.flowers.get(0).func_76484_a(world, rand, x, this.nextHeightInt(rand, world.func_72976_f(x, z) * 2), z);
            }
            if (ConfigBlocksItems.enableCornflower) {
                x = chunkX * 16 + rand.nextInt(16) + 8;
                z = chunkZ * 16 + rand.nextInt(16) + 8;
                biome = world.func_72807_a(x, z);
                biomeList = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
                if (biome.field_76756_M == 132 || ArrayUtils.contains((Object[])biomeList, (Object)BiomeDictionary.Type.PLAINS) && !ArrayUtils.contains((Object[])biomeList, (Object)BiomeDictionary.Type.SNOWY) && !ArrayUtils.contains((Object[])biomeList, (Object)BiomeDictionary.Type.SAVANNA) && world.func_72976_f(x, z) > 0) {
                    this.flowers.get(1).func_76484_a(world, rand, x, this.nextHeightInt(rand, world.func_72976_f(x, z) * 2), z);
                }
            }
            if (ConfigBlocksItems.enableSweetBerryBushes && ArrayUtils.contains((Object[])(biomeList = BiomeDictionary.getTypesForBiome((BiomeGenBase)(biome = world.func_72807_a(x = chunkX * 16 + rand.nextInt(16) + 8, z = chunkZ * 16 + rand.nextInt(16) + 8)))), (Object)BiomeDictionary.Type.CONIFEROUS) && world.func_72976_f(x, z) > 0) {
                this.flowers.get(2).func_76484_a(world, rand, x, this.nextHeightInt(rand, world.func_72976_f(x, z) * 2), z);
            }
            if (ArrayUtils.contains((int[])ConfigWorld.fossilDimensionBlacklist, (int)world.field_73011_w.field_76574_g) == ConfigWorld.fossilDimensionBlacklistAsWhitelist) {
                x = chunkX * 16 + rand.nextInt(16) + 8;
                z = chunkZ * 16 + rand.nextInt(16) + 8;
                biome = world.func_72807_a(x, z);
                biomeList = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
                if (ConfigWorld.enableFossils && rand.nextInt(64) == 0 && (ArrayUtils.contains((Object[])biomeList, (Object)BiomeDictionary.Type.SANDY) && ArrayUtils.contains((Object[])biomeList, (Object)BiomeDictionary.Type.DRY) || ArrayUtils.contains((Object[])biomeList, (Object)BiomeDictionary.Type.SWAMP))) {
                    new WorldGenFossil().func_76484_a(world, rand, x, rand.nextInt(9) + 41, z);
                }
            }
        }
        if (world.field_73011_w.field_76574_g == -1) {
            if (ConfigBlocksItems.enableMagmaBlock) {
                this.generateOre(this.magmaGen, world, rand, chunkX, chunkZ, 4.0f, 23, 37);
            }
            if (ConfigBlocksItems.enableNetherGold) {
                this.generateOre(this.netherGoldGen, world, rand, chunkX, chunkZ, 10.0f, 10, 117);
            }
            if (ConfigBlocksItems.enableNetherite) {
                this.generateOre(this.debrisGen, world, rand, chunkX, chunkZ, 1.0f, 8, 22);
                this.generateOre(this.smallDebrisGen, world, rand, chunkX, chunkZ, 1.0f, 8, 119);
            }
        }
        if (ConfigWorld.enableOceanMonuments && ConfigBlocksItems.enablePrismarine && world.field_73011_w.field_76574_g != -1 && world.field_73011_w.field_76574_g != 1 && OceanMonument.canSpawnAt(world, chunkX, chunkZ)) {
            x = chunkX * 16 + rand.nextInt(16) + 8;
            int z = chunkZ * 16 + rand.nextInt(16) + 8;
            for (y = 256; y > 0 && world.func_147437_c(x, y, z); --y) {
            }
            int monumentCeiling = y - (1 + rand.nextInt(3));
            OceanMonument.buildTemple(world, x, monumentCeiling - 22, z);
            return;
        }
        if (ConfigBlocksItems.enableChorusFruit && !(world.field_73011_w instanceof EndWorldProvider) && world.field_73011_w.field_76574_g == 1) {
            x = chunkX * 16 + rand.nextInt(16) + 8;
            int z = chunkZ * 16 + rand.nextInt(16) + 8;
            for (y = 256; y > 0; --y) {
                if (world.func_147439_a(x, y, z).isAir((IBlockAccess)world, x, y, z) || y <= 0 || !BlockChorusFlower.canPlantStay(world, x, y + 1, z)) continue;
                BlockChorusFlower.generatePlant(world, x, y + 1, z, rand, 8);
                break;
            }
        }
    }

    public void generateSingleOre(Block block, int meta, World world, Random random, int chunkX, int chunkZ, float chance, int minY, int maxY, Block generateIn) {
        if (maxY <= 0 || minY < 0 || maxY < minY || chance <= 0.0f) {
            return;
        }
        int i = 0;
        while (true) {
            float f = i;
            float f2 = chance < 1.0f ? 1.0f : chance;
            if (!(f < f2)) break;
            if (chance > 1.0f || random.nextFloat() < chance) {
                int zRand;
                int yRand;
                int heightRange = maxY - minY;
                int xRand = chunkX * 16 + random.nextInt(16);
                if (world.func_147439_a(xRand, yRand = random.nextInt(heightRange) + minY, zRand = chunkZ * 16 + random.nextInt(16)).isReplaceableOreGen(world, xRand, yRand, zRand, generateIn)) {
                    world.func_147465_d(xRand, yRand, zRand, block, meta, 3);
                }
            }
            ++i;
        }
    }

    public void generateOre(WorldGenMinable gen, World world, Random random, int chunkX, int chunkZ, float chance, int minY, int maxY) {
        if (maxY <= 0 || minY < 0 || maxY < minY || gen.field_76541_b <= 0 || chance <= 0.0f) {
            return;
        }
        int heightRange = maxY - minY;
        for (int i = 0; i < (chance < 1.0f ? 1 : (int)chance); ++i) {
            if (!(chance >= 1.0f) && !(random.nextFloat() < chance)) continue;
            int xRand = chunkX * 16 + random.nextInt(16);
            int yRand = random.nextInt(heightRange) + minY;
            int zRand = chunkZ * 16 + random.nextInt(16);
            gen.func_76484_a(world, random, xRand, yRand, zRand);
        }
    }

    protected int nextHeightInt(Random rand, int i) {
        if (i <= 1) {
            return 1;
        }
        return rand.nextInt(i);
    }
}

