/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.world;

import com.google.common.collect.Maps;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.configuration.configs.ConfigTweaks;
import ganymedes01.etfuturum.configuration.configs.ConfigWorld;
import ganymedes01.etfuturum.core.utils.DeepslateOreRegistry;
import ganymedes01.etfuturum.core.utils.helpers.BlockAndMetadataMapping;
import ganymedes01.etfuturum.world.EtFuturumWorldGenerator;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.apache.commons.lang3.ArrayUtils;

public class EtFuturumLateWorldGenerator
extends EtFuturumWorldGenerator {
    public static final EtFuturumLateWorldGenerator INSTANCE = new EtFuturumLateWorldGenerator();
    public static final Map<Integer, Map<Long, Set<Integer>>> deepslateRedoCache = Maps.newConcurrentMap();
    public static boolean stopRecording;

    @Override
    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.func_72912_H().func_76067_t() != WorldType.field_77138_c || world.field_73011_w.field_76574_g != 0 || world.func_72912_H().func_82571_y().contains("decoration")) {
            if (ConfigBlocksItems.enableDeepslate && ConfigWorld.deepslateGenerationMode == 1 && world.field_73011_w.field_76574_g != -1 && world.field_73011_w.field_76574_g != 1) {
                this.generateOre(this.deepslateBlobGen, world, rand, chunkX, chunkZ, 1.0f, 6, ConfigWorld.deepslateMaxY);
            }
            if (ConfigBlocksItems.enableTuff && world.field_73011_w.field_76574_g != -1 && world.field_73011_w.field_76574_g != 1) {
                this.generateOre(this.tuffGen, world, rand, chunkX, chunkZ, 1.0f, 6, ConfigWorld.deepslateMaxY);
            }
        }
        Chunk chunk = null;
        if (this.doesChunkSupportLayerDeepslate(world.func_72912_H().func_76067_t(), world.field_73011_w.field_76574_g)) {
            stopRecording = true;
            Map<Long, Set<Integer>> map = deepslateRedoCache.get(world.field_73011_w.field_76574_g);
            if (map != null) {
                Iterator<Map.Entry<Long, Set<Integer>>> mapIterator = map.entrySet().iterator();
                while (mapIterator.hasNext()) {
                    Map.Entry<Long, Set<Integer>> set = mapIterator.next();
                    Set<Integer> posSet = set.getValue();
                    if (posSet != null) {
                        long packedChunkCoords = set.getKey();
                        int redoX = (int)packedChunkCoords;
                        int redoZ = (int)(packedChunkCoords >> 32);
                        Chunk cachedChunk = world.func_72964_e(redoX, redoZ);
                        for (int pos : posSet) {
                            byte posX = (byte)(pos >> 12);
                            short posY = (short)(pos >> 4 & 0xFF);
                            byte posZ = (byte)(pos & 0xF);
                            this.replaceBlockInChunk(cachedChunk, posX, posZ, redoX << 4 + posX, posY, redoZ << 4 + posZ);
                        }
                    }
                    mapIterator.remove();
                }
            }
            chunk = world.func_72964_e(chunkX, chunkZ);
            this.doDeepslateGen(chunk);
            stopRecording = false;
        }
        if (ConfigBlocksItems.enableCoarseDirt && ConfigWorld.enableCoarseDirtReplacement) {
            if (chunk == null) {
                chunk = world.func_72964_e(chunkX, chunkZ);
            }
            this.doCoarseDirtGen(chunk);
        }
    }

    private void doCoarseDirtGen(Chunk chunk) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < chunk.func_76611_b(x, z); ++y) {
                    ExtendedBlockStorage array = chunk.func_76587_i()[y >> 4];
                    if (array == null || array.func_76665_b(x, y & 0xF, z) != 1 || array.func_150819_a(x, y & 0xF, z) != Blocks.field_150346_d) continue;
                    array.func_150818_a(x, y & 0xF, z, ModBlocks.coarse_dirt);
                    array.func_76654_b(x, y & 0xF, z, 0);
                }
            }
        }
    }

    private void doDeepslateGen(Chunk chunk) {
        int chunkMultiplierX = chunk.field_76635_g << 4;
        int chunkMultiplierZ = chunk.field_76647_h << 4;
        for (int y = 0; y <= ConfigWorld.deepslateMaxY; ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    if (ConfigWorld.deepslateMaxY < 255 && y >= ConfigWorld.deepslateMaxY - 4 && y > ConfigWorld.deepslateMaxY - chunk.field_76637_e.field_73012_v.nextInt(4)) continue;
                    int worldX = x + chunkMultiplierX;
                    int worldZ = z + chunkMultiplierZ;
                    this.replaceBlockInChunk(chunk, x, z, worldX, y, worldZ);
                }
            }
        }
    }

    private void replaceBlockInChunk(Chunk chunk, int x, int z, int worldX, int worldY, int worldZ) {
        this.replaceBlockInChunk(chunk, chunk.func_150810_a(x, worldY, z), x, z, worldX, worldY, worldZ);
    }

    private void replaceBlockInChunk(Chunk chunk, Block block, int x, int z, int worldX, int worldY, int worldZ) {
        if (block.func_149688_o() != Material.field_151579_a && block != ModBlocks.deepslate && block != ModBlocks.tuff && block != ModBlocks.cobbled_deepslate) {
            BlockAndMetadataMapping mapping;
            ExtendedBlockStorage array = chunk.func_76587_i()[worldY >> 4];
            if (array == null) {
                return;
            }
            if (block.isReplaceableOreGen(chunk.field_76637_e, worldX, worldY, worldZ, Blocks.field_150348_b) && (ConfigWorld.deepslateReplacesStones || block != ModBlocks.stone) || ConfigWorld.deepslateReplacesDirt && block == Blocks.field_150346_d) {
                array.func_150818_a(x, worldY & 0xF, z, ModBlocks.deepslate);
                array.func_76654_b(x, worldY & 0xF, z, 0);
            } else if (ConfigTweaks.deepslateReplacesCobblestone && block.isReplaceableOreGen(chunk.field_76637_e, worldX, worldY, worldZ, Blocks.field_150347_e)) {
                array.func_150818_a(x, worldY & 0xF, z, ModBlocks.cobbled_deepslate);
                array.func_76654_b(x, worldY & 0xF, z, 0);
            } else if (!DeepslateOreRegistry.getOreMap().isEmpty() && (mapping = DeepslateOreRegistry.getOre(block, array.func_76665_b(x, worldY & 0xF, z))) != null) {
                array.func_150818_a(x, worldY & 0xF, z, mapping.getBlock());
                array.func_76654_b(x, worldY & 0xF, z, mapping.getMeta());
            }
        }
    }

    private boolean doesChunkSupportLayerDeepslate(WorldType terrain, int dimId) {
        return ConfigBlocksItems.enableDeepslate && ConfigWorld.deepslateGenerationMode == 0 && ConfigWorld.deepslateMaxY > 0 && terrain != WorldType.field_77138_c && ArrayUtils.contains((int[])ConfigWorld.deepslateLayerDimensionBlacklist, (int)dimId) == ConfigWorld.deepslateLayerDimensionBlacklistAsWhitelist;
    }
}

