/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.core.utils;

import ganymedes01.etfuturum.api.brewing.IBrewingFuel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class BrewingFuelRegistry {
    private static final Map<ItemStack, Integer> fuels = new HashMap<ItemStack, Integer>();
    private static final List<IBrewingFuel> advFuels = new ArrayList<IBrewingFuel>();

    public static void registerFuel(ItemStack fuel, int brews) {
        fuels.put(fuel, brews);
    }

    public static void registerAdvancedFuel(IBrewingFuel fuel) {
        advFuels.add(fuel);
    }

    public static boolean isFuel(ItemStack fuel) {
        return BrewingFuelRegistry.getBrewAmount(fuel) > 0;
    }

    public static int getBrewAmount(ItemStack fuel) {
        for (IBrewingFuel iBrewingFuel : advFuels) {
            int time = iBrewingFuel.getBrewingAmount(fuel);
            if (time <= 0) continue;
            return time;
        }
        for (Map.Entry entry : fuels.entrySet()) {
            if (!OreDictionary.itemMatches((ItemStack)((ItemStack)entry.getKey()), (ItemStack)fuel, (boolean)false)) continue;
            return (Integer)entry.getValue();
        }
        return 0;
    }

    static {
        fuels.put(new ItemStack(Items.field_151065_br), 30);
    }
}

