/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.blocks.IConfigurable;
import ganymedes01.etfuturum.client.sound.ModSounds;
import ganymedes01.etfuturum.configuration.configs.ConfigWorld;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.lib.RenderIDs;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPointedDripstone
extends Block
implements IConfigurable {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] downIcons;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] upIcons;
    private static final int states = 5;
    public static DamageSource STALACTITE_DAMAGE;

    public BlockPointedDripstone() {
        super(Material.field_151576_e);
        this.func_149672_a(ConfigWorld.enableNewBlocksSounds ? ModSounds.soundPointedDripstone : Block.field_149769_e);
        this.func_149711_c(1.5f);
        this.func_149752_b(3.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149663_c(Utils.getUnlocalisedName("pointed_dripstone"));
        this.func_149658_d("pointed_dripstone");
        this.func_149647_a((CreativeTabs)(this.isEnabled() ? EtFuturum.creativeTabBlocks : null));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister p_149651_1_) {
        this.downIcons = new IIcon[5];
        this.downIcons[0] = p_149651_1_.func_94245_a(this.func_149641_N() + "_down_tip");
        this.downIcons[1] = p_149651_1_.func_94245_a(this.func_149641_N() + "_down_frustum");
        this.downIcons[2] = p_149651_1_.func_94245_a(this.func_149641_N() + "_down_middle");
        this.downIcons[3] = p_149651_1_.func_94245_a(this.func_149641_N() + "_down_base");
        this.downIcons[4] = p_149651_1_.func_94245_a(this.func_149641_N() + "_down_tip_merge");
        this.upIcons = new IIcon[5];
        this.upIcons[0] = p_149651_1_.func_94245_a(this.func_149641_N() + "_up_tip");
        this.upIcons[1] = p_149651_1_.func_94245_a(this.func_149641_N() + "_up_frustum");
        this.upIcons[2] = p_149651_1_.func_94245_a(this.func_149641_N() + "_up_middle");
        this.upIcons[3] = p_149651_1_.func_94245_a(this.func_149641_N() + "_up_base");
        this.upIcons[4] = p_149651_1_.func_94245_a(this.func_149641_N() + "_up_tip_merge");
        this.field_149761_L = this.downIcons[3];
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float p_149660_6_, float p_149660_7_, float p_149660_8_, int p_149660_9_) {
        if (side < 2) {
            return side * 5;
        }
        if (this.canDripstoneStayHere(world, x, y, z, -1)) {
            return 5;
        }
        return 0;
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        int checkY = side == 0 || world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN) ? 1 : -1;
        return this.canDripstoneStayHere(world, x, y, z, checkY);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!this.func_149718_j(world, x, y, z)) {
            world.func_147468_f(x, y, z);
            this.func_149697_b(world, x, y, z, 0, 0);
            return;
        }
        this.setState(world, x, y, z);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta % 5 == 4) {
            meta = 0;
        }
        float offset = 0.0625f + (float)(2 - meta % 5) * 0.125f;
        return AxisAlignedBB.func_72330_a((double)((float)x + offset), (double)y, (double)((float)z + offset), (double)((float)x + (1.0f - offset)), (double)((float)y + 1.0f), (double)((float)z + (1.0f - offset)));
    }

    public void func_149719_a(IBlockAccess access, int x, int y, int z) {
        int meta = access.func_72805_g(x, y, z);
        if (meta % 5 == 4) {
            meta = 0;
        }
        float offset = 0.0625f + (float)(2 - meta % 5) * 0.0625f;
        this.func_149676_a(offset, 0.0f, offset, 1.0f - offset, 1.0f, 1.0f - offset);
    }

    private void setState(World world, int x, int y, int z) {
        int meta = 0;
        boolean up = world.func_72805_g(x, y, z) > 4;
        for (meta = 0; meta < 2 && world.func_72805_g(x, y + (up ? 1 : -1) + (up ? meta : -meta), z) > 4 == up && world.func_147439_a(x, y + (up ? 1 : -1) + (up ? meta : -meta), z) == this; ++meta) {
        }
        if (meta % 5 == 0 && world.func_147439_a(x, y + (up ? 1 : -1), z) == this && world.func_72805_g(x, y + (up ? 1 : -1), z) > 4 != up) {
            meta = 4;
        }
        if (meta % 5 == 2 && world.func_147439_a(x, y + (up ? 1 : -1), z) == this && world.func_72805_g(x, y + (up ? 1 : -1), z) % 5 == 2 && world.func_147439_a(x, y + (up ? -1 : 1), z).isSideSolid((IBlockAccess)world, x, y + (up ? -1 : 1), z, up ? ForgeDirection.DOWN : ForgeDirection.UP)) {
            meta = 3;
        }
        if (up) {
            meta += 5;
        }
        world.func_72921_c(x, y, z, meta, 3);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        int checkY = world.func_72805_g(x, y, z) < 5 ? 1 : -1;
        return this.canDripstoneStayHere(world, x, y, z, checkY);
    }

    private boolean canDripstoneStayHere(World world, int x, int y, int z, int offset) {
        return world.func_147445_c(x, y + offset, z, false) || offset == (world.func_72805_g(x, y + offset, z) < 5 ? 1 : -1) && world.func_147439_a(x, y + offset, z) == this;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return meta < 5 ? this.downIcons[meta % 5] : this.upIcons[meta % 5];
    }

    @Override
    public boolean isEnabled() {
        return EtFuturum.TESTING;
    }

    public int func_149645_b() {
        return RenderIDs.POINTED_DRIPSTONE;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_149702_O() {
        return "pointed_dripstone";
    }
}

