/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum;

import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.configuration.configs.ConfigEnchantsPotions;
import ganymedes01.etfuturum.configuration.configs.ConfigEntities;
import ganymedes01.etfuturum.configuration.configs.ConfigFunctions;
import ganymedes01.etfuturum.configuration.configs.ConfigMixins;
import ganymedes01.etfuturum.configuration.configs.ConfigTweaks;
import ganymedes01.etfuturum.configuration.configs.ConfigWorld;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.launchwrapper.Launch;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class EtFuturumMixinPlugin
implements IMixinConfigPlugin {
    public static boolean launchConfigWarning;
    protected static boolean serverSide;
    public static final MixinEnvironment.Side side;

    @Override
    public void onLoad(String mixinPackage) {
        String configDir = "config" + File.separator + "etfuturum";
        File olderFile = new File(Launch.minecraftHome, "config" + File.separator + "etfuturum.cfg");
        File oldFile = new File(Launch.minecraftHome, configDir + File.separator + "etfuturum.cfg");
        oldFile.getParentFile().mkdirs();
        if (olderFile.exists()) {
            try {
                Files.copy(olderFile.toPath(), oldFile.toPath(), new CopyOption[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            olderFile.delete();
            launchConfigWarning = true;
        }
        if (oldFile.exists()) {
            launchConfigWarning = true;
        }
        ConfigBlocksItems.configInstance.syncConfig();
        ConfigEnchantsPotions.configInstance.syncConfig();
        ConfigFunctions.configInstance.syncConfig();
        ConfigTweaks.configInstance.syncConfig();
        ConfigWorld.configInstance.syncConfig();
        ConfigEntities.configInstance.syncConfig();
        ConfigMixins.configInstance.syncConfig();
    }

    @Override
    public String getRefMapperConfig() {
        return null;
    }

    @Override
    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    @Override
    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    @Override
    public List<String> getMixins() {
        ArrayList<String> mixins = new ArrayList<String>();
        if (ConfigMixins.endPortalFix) {
            mixins.add("MixinBlockEndPortal");
        }
        if (ConfigMixins.fenceWallConnectFix) {
            mixins.add("MixinBlockWall");
            mixins.add("MixinBlockFence");
        }
        if (ConfigMixins.stepHeightFix) {
            mixins.add("MixinEntity");
        }
        if (ConfigMixins.enableSpectatorMode) {
            mixins.add("MixinGameType");
            mixins.add("MixinEntity_Spectator");
            mixins.add("MixinWorld_Spectator");
            mixins.add("MixinEntityPlayer_Spectator");
            mixins.add("MixinNetHandlerPlayServer");
        }
        if (ConfigMixins.avoidDroppingItemsWhenClosing) {
            mixins.add("MixinEntityPlayerMP");
        }
        if (side == MixinEnvironment.Side.CLIENT) {
            if (ConfigMixins.furnaceCrackle) {
                mixins.add("client.MixinBlockFurnace");
            }
            if (ConfigMixins.enableSpectatorMode) {
                mixins.add("client.MixinEntityRenderer");
                mixins.add("client.MixinEntityPlayer");
                mixins.add("client.MixinWorldRenderer_Spectator");
            }
            if (ConfigEnchantsPotions.enableSwiftSneak) {
                mixins.add("client.MixinMovementInputFromOptions");
            }
        }
        return mixins;
    }

    @Override
    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    @Override
    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    static {
        side = MixinEnvironment.getCurrentEnvironment().getSide();
    }
}

