/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.security;

import com.jrockit.mc.core.security.ActionNotGrantedException;
import com.jrockit.mc.core.security.FailedToSaveException;
import com.jrockit.mc.core.security.ISecurityManager;
import com.jrockit.mc.core.security.SecureStore;
import com.jrockit.mc.core.security.SecurityException;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.security.MasterPasswordWizardPage;
import com.jrockit.mc.ui.security.Messages;
import com.jrockit.mc.ui.wizards.OnePageWizardDialog;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DialogSecurityManager
implements ISecurityManager {
    private final SecureStore secureStore = SecureStore.createDefault();

    public void showUi(final boolean replacePwd) throws ActionNotGrantedException {
        final boolean[] accessNotGranted = new boolean[1];
        DisplayToolkit.safeSyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell;
                block12: {
                    shell = Display.getCurrent().getActiveShell();
                    if (!DialogSecurityManager.this.secureStore.isPersistable()) {
                        MessageDialog.openError((Shell)shell, (String)Messages.SecurityDialogs_NO_CIPHER_AVAILABLE_TEXT, (String)Messages.SecurityDialogs_SECURE_STORE_WILL_NOT_BE_ABLE_TO_SAVE);
                        return;
                    }
                    if (DialogSecurityManager.this.secureStore.isEncrypted()) {
                        String cipher = DialogSecurityManager.this.secureStore.getEncryptionCipher();
                        if (SecureStore.ENCRYPTION_CIPHERS.contains(cipher)) {
                            while (true) {
                                try {
                                    String pwd = DialogSecurityManager.this.getPassword(shell, false, false);
                                    if (pwd != null) {
                                        DialogSecurityManager.this.secureStore.initialize(pwd);
                                    }
                                    break block12;
                                }
                                catch (Exception e) {
                                    UIPlugin.getDefault().getLogger().log(Level.FINE, "Could not decrypt store");
                                    continue;
                                }
                                break;
                            }
                        }
                        if (!MessageDialog.openQuestion((Shell)shell, (String)NLS.bind((String)Messages.SecurityDialogs_CIPHER_NOT_AVAILABLE_TITLE, (Object)(String.valueOf('\'') + cipher + '\'')), (String)Messages.SecurityDialogs_CIPHER_NOT_AVAILABLE_TEXT)) {
                            accessNotGranted[0] = true;
                            return;
                        }
                    }
                }
                if (!DialogSecurityManager.this.secureStore.isInitialized() || replacePwd) {
                    String pwd = DialogSecurityManager.this.getPassword(shell, true, DialogSecurityManager.this.secureStore.isEncrypted());
                    if (pwd == null) {
                        accessNotGranted[0] = true;
                        return;
                    }
                    DialogSecurityManager.this.secureStore.initialize();
                    try {
                        DialogSecurityManager.this.secureStore.setPassword(pwd);
                    }
                    catch (FailedToSaveException e) {
                        MessageDialog.openError((Shell)shell, (String)Messages.SecurityDialogs_FAILED_TO_SAVE, (String)Messages.SecurityDialogs_SECURE_STORE_WILL_NOT_BE_ABLE_TO_SAVE);
                    }
                }
            }
        });
        if (accessNotGranted[0]) {
            throw new ActionNotGrantedException();
        }
    }

    public Object withdraw(String key) throws SecurityException {
        return this.secureStore.remove(key);
    }

    public void clearFamily(String family, Set<String> keys) throws FailedToSaveException {
        this.secureStore.clearFamily(family, keys);
    }

    public Object get(String key) throws SecurityException {
        return this.hasKey(key) ? this.getInitialised().get(key) : null;
    }

    public String store(byte ... value) throws SecurityException {
        return this.getInitialised().insert(null, true, (Object)value);
    }

    public String store(String ... value) throws SecurityException {
        return this.getInitialised().insert(null, true, (Object)value);
    }

    public String storeInFamily(String family, byte ... value) throws SecurityException {
        return this.getInitialised().insert(family, true, (Object)value);
    }

    public String storeInFamily(String family, String ... value) throws SecurityException {
        return this.getInitialised().insert(family, true, (Object)value);
    }

    public void storeWithKey(String key, byte ... value) throws SecurityException {
        this.getInitialised().insert(key, false, (Object)value);
    }

    public void storeWithKey(String key, String ... value) throws SecurityException {
        this.getInitialised().insert(key, false, (Object)value);
    }

    public Set<String> getEncryptionCiphers() {
        return SecureStore.ENCRYPTION_CIPHERS;
    }

    public String getEncryptionCipher() {
        return this.secureStore.getEncryptionCipher();
    }

    public void setEncryptionCipher(String encryptionCipher) throws SecurityException {
        this.getInitialised().setEncryptionCipher(encryptionCipher);
    }

    public void changeMasterPassword() throws SecurityException {
        this.showUi(true);
    }

    private SecureStore getInitialised() throws ActionNotGrantedException {
        if (!this.secureStore.isInitialized()) {
            this.showUi(false);
        }
        return this.secureStore;
    }

    private String getPassword(Shell shell, boolean usePasswordVerification, boolean warnForDataClear) {
        MasterPasswordWizardPage page = new MasterPasswordWizardPage(usePasswordVerification, warnForDataClear);
        OnePageWizardDialog owp = new OnePageWizardDialog(shell, (IWizardPage)page);
        owp.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
        owp.setTitle(Messages.MasterPasswordWizardPage_ENTER_MASTER_PASSWORD_TITLE);
        owp.open();
        return page.getMasterPassword();
    }

    public boolean hasKey(String key) {
        return this.secureStore.hasKey(key);
    }

    public boolean isLocked() {
        return !this.secureStore.isInitialized();
    }

    public void unlock() throws ActionNotGrantedException {
        this.getInitialised();
    }
}

