/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.util.mappings;

import net.fabricmc.mapping.tree.ClassDef;
import net.fabricmc.mapping.tree.FieldDef;
import net.fabricmc.mapping.tree.MethodDef;
import net.fabricmc.mapping.tree.TinyTree;
import net.fabricmc.tinyremapper.IMappingProvider;

public class TinyRemapperMappingsHelper {
    private TinyRemapperMappingsHelper() {
    }

    private static IMappingProvider.Member memberOf(String className, String memberName, String descriptor) {
        return new IMappingProvider.Member(className, memberName, descriptor);
    }

    public static IMappingProvider create(TinyTree mappings, String from, String to) {
        return acceptor -> {
            for (ClassDef classDef : mappings.getClasses()) {
                String className = classDef.getName(from);
                acceptor.acceptClass(className, classDef.getName(to));
                for (FieldDef field : classDef.getFields()) {
                    acceptor.acceptField(TinyRemapperMappingsHelper.memberOf(className, field.getName(from), field.getDescriptor(from)), field.getName(to));
                }
                for (MethodDef method : classDef.getMethods()) {
                    IMappingProvider.Member methodIdentifier = TinyRemapperMappingsHelper.memberOf(className, method.getName(from), method.getDescriptor(from));
                    acceptor.acceptMethod(methodIdentifier, method.getName(to));
                }
            }
        };
    }
}

