/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.util;

import java.io.File;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.fabricmc.loader.util.UrlConversionException;

public final class UrlUtil {
    private UrlUtil() {
    }

    public static URL getSource(String filename, URL resourceURL) throws UrlConversionException {
        URL codeSourceURL;
        block4: {
            try {
                URLConnection connection = resourceURL.openConnection();
                if (connection instanceof JarURLConnection) {
                    codeSourceURL = ((JarURLConnection)connection).getJarFileURL();
                    break block4;
                }
                String path = resourceURL.getPath();
                if (path.endsWith(filename)) {
                    codeSourceURL = new URL(resourceURL.getProtocol(), resourceURL.getHost(), resourceURL.getPort(), path.substring(0, path.length() - filename.length()));
                    break block4;
                }
                throw new UrlConversionException("Could not figure out code source for file '" + filename + "' and URL '" + resourceURL + "'!");
            }
            catch (Exception e) {
                throw new UrlConversionException(e);
            }
        }
        return codeSourceURL;
    }

    public static File asFile(URL url) throws UrlConversionException {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new UrlConversionException(e);
        }
    }

    public static Path asPath(URL url) throws UrlConversionException {
        if (url.getProtocol().equals("file")) {
            return UrlUtil.asFile(url).toPath();
        }
        try {
            return Paths.get(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new UrlConversionException(e);
        }
    }

    public static URL asUrl(File file) throws UrlConversionException {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new UrlConversionException(e);
        }
    }

    public static URL asUrl(Path path) throws UrlConversionException {
        try {
            return new URL(null, path.toUri().toString());
        }
        catch (MalformedURLException e) {
            throw new UrlConversionException(e);
        }
    }
}

