/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class Arguments {
    public static final String GAME_VERSION = "fabric.gameVersion";
    private final Map<String, String> values = new LinkedHashMap<String, String>();
    private final List<String> extraArgs = new ArrayList<String>();

    public Collection<String> keys() {
        return this.values.keySet();
    }

    public List<String> getExtraArgs() {
        return Collections.unmodifiableList(this.extraArgs);
    }

    public boolean containsKey(String key) {
        return this.values.containsKey(key);
    }

    public String get(String key) {
        return this.values.get(key);
    }

    public String getOrDefault(String key, String value) {
        return this.values.getOrDefault(key, value);
    }

    public void put(String key, String value) {
        this.values.put(key, value);
    }

    public void addExtraArg(String value) {
        this.extraArgs.add(value);
    }

    public void parse(String[] args) {
        this.parse(Arrays.asList(args));
    }

    public void parse(List<String> args) {
        for (int i = 0; i < args.size(); ++i) {
            String arg = args.get(i);
            if (arg.startsWith("--") && i < args.size() - 1) {
                this.values.put(arg.substring(2), args.get(++i));
                continue;
            }
            this.extraArgs.add(arg);
        }
    }

    public String[] toArray() {
        String[] newArgs = new String[this.values.size() * 2 + this.extraArgs.size()];
        int i = 0;
        for (String s : this.values.keySet()) {
            newArgs[i++] = "--" + s;
            newArgs[i++] = this.values.get(s);
        }
        for (String s : this.extraArgs) {
            newArgs[i++] = s;
        }
        return newArgs;
    }

    public String remove(String s) {
        return this.values.remove(s);
    }
}

