/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.minecraft;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.loader.lib.gson.JsonReader;
import net.fabricmc.loader.lib.gson.JsonToken;
import net.fabricmc.loader.metadata.ParseMetadataException;
import net.fabricmc.loader.util.FileSystemUtil;
import net.fabricmc.loader.util.version.SemanticVersionImpl;
import net.fabricmc.loader.util.version.SemanticVersionPredicateParser;
import net.fabricmc.loader.util.version.VersionParsingException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public final class McVersionLookup {
    private static final Pattern VERSION_PATTERN = Pattern.compile("0\\.\\d+(\\.\\d+)?a?(_\\d+)?|\\d+\\.\\d+(\\.\\d+)?(-pre\\d+| Pre-[Rr]elease \\d+)?|\\d+\\.\\d+(\\.\\d+)?(-rc\\d+| Rr]elease Candidate \\d+)?|\\d+w\\d+[a-z]|[a-c]\\d\\.\\d+(\\.\\d+)?[a-z]?(_\\d+)?[a-z]?|(Alpha|Beta) v?\\d+\\.\\d+(\\.\\d+)?[a-z]?(_\\d+)?[a-z]?|Inf?dev (0\\.31 )?\\d+(-\\d+)?|(rd|inf)-\\d+|1\\.RV-Pre1|3D Shareware v1\\.34");
    private static final Pattern RELEASE_PATTERN = Pattern.compile("\\d+\\.\\d+(\\.\\d+)?");
    private static final Pattern PRE_RELEASE_PATTERN = Pattern.compile(".+(?:-pre| Pre-[Rr]elease )(\\d+)");
    private static final Pattern RELEASE_CANDIDATE_PATTERN = Pattern.compile(".+(?:-rc| [Rr]elease Candidate )(\\d+)");
    private static final Pattern SNAPSHOT_PATTERN = Pattern.compile("(?:Snapshot )?(\\d+)w0?(0|[1-9]\\d*)([a-z])");
    private static final Pattern BETA_PATTERN = Pattern.compile("(?:b|Beta v?)1\\.(\\d+(\\.\\d+)?[a-z]?(_\\d+)?[a-z]?)");
    private static final Pattern ALPHA_PATTERN = Pattern.compile("(?:a|Alpha v?)1\\.(\\d+(\\.\\d+)?[a-z]?(_\\d+)?[a-z]?)");
    private static final Pattern INDEV_PATTERN = Pattern.compile("(?:inf-|Inf?dev )(?:0\\.31 )?(\\d+(-\\d+)?)");
    private static final String STRING_DESC = "Ljava/lang/String;";

    public static McVersion getVersion(String version) {
        return new McVersion(version, McVersionLookup.getRelease(version));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static McVersion getVersion(Path gameJar) {
        try (FileSystemUtil.FileSystemDelegate jarFs = FileSystemUtil.getJarFileSystem(gameJar, false);){
            McVersion ret;
            FileSystem fs = jarFs.get();
            Path file = fs.getPath("version.json", new String[0]);
            if (Files.isRegularFile(file, new LinkOption[0]) && (ret = McVersionLookup.fromVersionJson(Files.newInputStream(file, new OpenOption[0]))) != null) {
                McVersion mcVersion = ret;
                return mcVersion;
            }
            file = fs.getPath("net/minecraft/realms/RealmsSharedConstants.class", new String[0]);
            if (Files.isRegularFile(file, new LinkOption[0]) && (ret = McVersionLookup.fromAnalyzer(Files.newInputStream(file, new OpenOption[0]), new FieldStringConstantVisitor("VERSION_STRING"))) != null) {
                McVersion mcVersion = ret;
                return mcVersion;
            }
            file = fs.getPath("net/minecraft/realms/RealmsBridge.class", new String[0]);
            if (Files.isRegularFile(file, new LinkOption[0]) && (ret = McVersionLookup.fromAnalyzer(Files.newInputStream(file, new OpenOption[0]), new MethodConstantRetVisitor("getVersionString"))) != null) {
                McVersion mcVersion = ret;
                return mcVersion;
            }
            file = fs.getPath("net/minecraft/server/MinecraftServer.class", new String[0]);
            if (Files.isRegularFile(file, new LinkOption[0]) && (ret = McVersionLookup.fromAnalyzer(Files.newInputStream(file, new OpenOption[0]), new MethodConstantVisitor("run"))) != null) {
                McVersion mcVersion = ret;
                return mcVersion;
            }
            file = fs.getPath("net/minecraft/client/Minecraft.class", new String[0]);
            if (!Files.isRegularFile(file, new LinkOption[0])) return McVersionLookup.fromFileName(gameJar.getFileName().toString());
            ret = McVersionLookup.fromAnalyzer(Files.newInputStream(file, new OpenOption[0]), new MethodConstantRetVisitor(null));
            if (ret != null) {
                McVersion mcVersion = ret;
                return mcVersion;
            }
            ret = McVersionLookup.fromAnalyzer(Files.newInputStream(file, new OpenOption[0]), new MethodStringConstantContainsVisitor("org/lwjgl/opengl/Display", "setTitle"));
            if (ret == null) return McVersionLookup.fromFileName(gameJar.getFileName().toString());
            McVersion mcVersion = ret;
            return mcVersion;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return McVersionLookup.fromFileName(gameJar.getFileName().toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static McVersion fromVersionJson(InputStream is) {
        try (JsonReader reader = new JsonReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String id = null;
            String name = null;
            String release = null;
            reader.beginObject();
            block17: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "id": {
                        if (reader.peek() != JsonToken.STRING) {
                            throw new ParseMetadataException("\"id\" in version json must be a string");
                        }
                        id = reader.nextString();
                        continue block17;
                    }
                    case "name": {
                        if (reader.peek() != JsonToken.STRING) {
                            throw new ParseMetadataException("\"name\" in version json must be a string");
                        }
                        name = reader.nextString();
                        continue block17;
                    }
                    case "release_target": {
                        if (reader.peek() != JsonToken.STRING) {
                            throw new ParseMetadataException("\"release_target\" in version json must be a string");
                        }
                        release = reader.nextString();
                        continue block17;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            if (name == null) {
                name = id;
            } else if (id != null && id.length() < name.length()) {
                name = id;
            }
            if (name == null) return null;
            if (release == null) return null;
            Object object = new McVersion(name, release);
            return object;
        }
        catch (IOException | ParseMetadataException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends ClassVisitor> McVersion fromAnalyzer(InputStream is, T analyzer) {
        try {
            ClassReader cr = new ClassReader(is);
            cr.accept(analyzer, 6);
            String result = ((Analyzer)analyzer).getResult();
            if (result != null) {
                McVersion mcVersion = new McVersion(result, McVersionLookup.getRelease(result));
                return mcVersion;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static McVersion fromFileName(String name) {
        int pos = name.lastIndexOf(46);
        if (pos > 0) {
            name = name.substring(0, pos);
        }
        return new McVersion(name, McVersionLookup.getRelease(name));
    }

    private static String getRelease(String version) {
        if (RELEASE_PATTERN.matcher(version).matches()) {
            return version;
        }
        assert (McVersionLookup.isProbableVersion(version));
        int pos = version.indexOf("-pre");
        if (pos >= 0) {
            return version.substring(0, pos);
        }
        pos = version.indexOf(" Pre-Release ");
        if (pos >= 0) {
            return version.substring(0, pos);
        }
        pos = version.indexOf(" Pre-release ");
        if (pos >= 0) {
            return version.substring(0, pos);
        }
        pos = version.indexOf(" Release Candidate ");
        if (pos >= 0) {
            return version.substring(0, pos);
        }
        Matcher matcher = SNAPSHOT_PATTERN.matcher(version);
        if (matcher.matches()) {
            int year = Integer.parseInt(matcher.group(1));
            int week = Integer.parseInt(matcher.group(2));
            if (year == 20 && week >= 6) {
                return "1.16";
            }
            if (year == 19 && week >= 34) {
                return "1.15";
            }
            if (year == 18 && week >= 43 || year == 19 && week <= 14) {
                return "1.14";
            }
            if (year == 18 && week >= 30 && week <= 33) {
                return "1.13.1";
            }
            if (year == 17 && week >= 43 || year == 18 && week <= 22) {
                return "1.13";
            }
            if (year == 17 && week == 31) {
                return "1.12.1";
            }
            if (year == 17 && week >= 6 && week <= 18) {
                return "1.12";
            }
            if (year == 16 && week == 50) {
                return "1.11.1";
            }
            if (year == 16 && week >= 32 && week <= 44) {
                return "1.11";
            }
            if (year == 16 && week >= 20 && week <= 21) {
                return "1.10";
            }
            if (year == 16 && week >= 14 && week <= 15) {
                return "1.9.3";
            }
            if (year == 15 && week >= 31 || year == 16 && week <= 7) {
                return "1.9";
            }
            if (year == 14 && week >= 2 && week <= 34) {
                return "1.8";
            }
            if (year == 13 && week >= 47 && week <= 49) {
                return "1.7.4";
            }
            if (year == 13 && week >= 36 && week <= 43) {
                return "1.7.2";
            }
            if (year == 13 && week >= 16 && week <= 26) {
                return "1.6";
            }
            if (year == 13 && week >= 11 && week <= 12) {
                return "1.5.1";
            }
            if (year == 13 && week >= 1 && week <= 10) {
                return "1.5";
            }
            if (year == 12 && week >= 49 && week <= 50) {
                return "1.4.6";
            }
            if (year == 12 && week >= 32 && week <= 42) {
                return "1.4.2";
            }
            if (year == 12 && week >= 15 && week <= 30) {
                return "1.3.1";
            }
            if (year == 12 && week >= 3 && week <= 8) {
                return "1.2.1";
            }
            if (year == 11 && week >= 47 || year == 12 && week <= 1) {
                return "1.1";
            }
        }
        return null;
    }

    private static boolean isProbableVersion(String str) {
        return VERSION_PATTERN.matcher(str).matches();
    }

    private static String findProbableVersion(String str) {
        Matcher matcher = VERSION_PATTERN.matcher(str);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    private static String normalizeVersion(String name, String release) {
        if (release == null || name.equals(release)) {
            return McVersionLookup.normalizeVersion(name);
        }
        if (name.startsWith(release)) {
            Matcher matcher = RELEASE_CANDIDATE_PATTERN.matcher(name);
            if (matcher.matches()) {
                String rcBuild = matcher.group(1);
                if (release.equals("1.16")) {
                    int build = Integer.parseInt(rcBuild);
                    rcBuild = Integer.toString(8 + build);
                }
                name = String.format("rc.%s", rcBuild);
            } else {
                matcher = PRE_RELEASE_PATTERN.matcher(name);
                if (matcher.matches()) {
                    boolean legacyVersion;
                    try {
                        legacyVersion = SemanticVersionPredicateParser.create("<=1.16").test(new SemanticVersionImpl(release, false));
                    }
                    catch (VersionParsingException e) {
                        throw new RuntimeException("Failed to parse version: " + release);
                    }
                    name = legacyVersion ? String.format("rc.%s", matcher.group(1)) : String.format("beta.%s", matcher.group(1));
                }
            }
        } else {
            Matcher matcher = SNAPSHOT_PATTERN.matcher(name);
            name = matcher.matches() ? String.format("alpha.%s.%s.%s", matcher.group(1), matcher.group(2), matcher.group(3)) : McVersionLookup.normalizeVersion(name);
        }
        return String.format("%s-%s", release, name);
    }

    private static String normalizeVersion(String version) {
        int end;
        int start;
        Matcher matcher = BETA_PATTERN.matcher(version);
        if (matcher.matches()) {
            version = "1.0.0-beta." + matcher.group(1);
        } else {
            matcher = ALPHA_PATTERN.matcher(version);
            if (matcher.matches()) {
                version = "1.0.0-alpha." + matcher.group(1);
            } else {
                matcher = INDEV_PATTERN.matcher(version);
                if (matcher.matches()) {
                    version = "0.31." + matcher.group(1);
                } else if (version.startsWith("c0.")) {
                    version = version.substring(1);
                } else if (version.startsWith("rd-")) {
                    if ("20090515".equals(version = version.substring("rd-".length()))) {
                        version = "150000";
                    }
                    version = "0.0.0-rd." + version;
                }
            }
        }
        StringBuilder ret = new StringBuilder(version.length() + 5);
        boolean lastIsDigit = false;
        boolean lastIsLeadingZero = false;
        boolean lastIsSeparator = false;
        int max = version.length();
        for (int i = 0; i < max; ++i) {
            int c = version.charAt(i);
            if (c >= 48 && c <= 57) {
                if (i > 0 && !lastIsDigit && !lastIsSeparator) {
                    ret.append('.');
                } else if (lastIsDigit && lastIsLeadingZero) {
                    ret.setLength(ret.length() - 1);
                }
                lastIsLeadingZero = c == 48 && (!lastIsDigit || lastIsLeadingZero);
                lastIsSeparator = false;
                lastIsDigit = true;
            } else if (c == 46 || c == 45) {
                if (lastIsSeparator) continue;
                lastIsSeparator = true;
                lastIsDigit = false;
            } else if (!(c >= 65 && c <= 90 || c >= 97 && c <= 122)) {
                if (lastIsSeparator) continue;
                c = 46;
                lastIsSeparator = true;
                lastIsDigit = false;
            } else {
                if (lastIsDigit) {
                    ret.append('.');
                }
                lastIsSeparator = false;
                lastIsDigit = false;
            }
            ret.append((char)c);
        }
        for (start = 0; start < ret.length() && ret.charAt(start) == '.'; ++start) {
        }
        for (end = ret.length(); end > start && ret.charAt(end - 1) == '.'; --end) {
        }
        return ret.substring(start, end);
    }

    public static final class McVersion {
        public final String raw;
        public final String normalized;

        private McVersion(String name, String release) {
            this.raw = name;
            this.normalized = McVersionLookup.normalizeVersion(name, release);
        }

        public String toString() {
            return String.format("%s/%s", this.raw, this.normalized);
        }
    }

    private static final class FieldStringConstantVisitor
    extends ClassVisitor
    implements Analyzer {
        private final String fieldName;
        private String className;
        private String result;

        public FieldStringConstantVisitor(String fieldName) {
            super(589824);
            this.fieldName = fieldName;
        }

        @Override
        public String getResult() {
            return this.result;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.className = name;
        }

        public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
            if (this.result == null && name.equals(this.fieldName) && descriptor.equals(McVersionLookup.STRING_DESC) && value instanceof String) {
                this.result = (String)value;
            }
            return null;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            if (this.result != null || !name.equals("<clinit>")) {
                return null;
            }
            return new InsnFwdMethodVisitor(){
                String lastLdc;

                @Override
                public void visitLdcInsn(Object value) {
                    String str;
                    this.lastLdc = value instanceof String && McVersionLookup.isProbableVersion(str = (String)value) ? str : null;
                }

                @Override
                public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                    if (result == null && this.lastLdc != null && opcode == 179 && owner.equals(className) && name.equals(fieldName) && descriptor.equals(McVersionLookup.STRING_DESC)) {
                        result = this.lastLdc;
                    }
                    this.lastLdc = null;
                }

                @Override
                protected void visitAnyInsn() {
                    this.lastLdc = null;
                }
            };
        }
    }

    private static final class MethodConstantRetVisitor
    extends ClassVisitor
    implements Analyzer {
        private final String methodName;
        private String result;

        public MethodConstantRetVisitor(String methodName) {
            super(589824);
            this.methodName = methodName;
        }

        @Override
        public String getResult() {
            return this.result;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            if (this.result != null || this.methodName != null && !name.equals(this.methodName) || !descriptor.endsWith(McVersionLookup.STRING_DESC) || descriptor.charAt(descriptor.length() - McVersionLookup.STRING_DESC.length() - 1) != ')') {
                return null;
            }
            return new InsnFwdMethodVisitor(){
                String lastLdc;

                @Override
                public void visitLdcInsn(Object value) {
                    String str;
                    this.lastLdc = value instanceof String && McVersionLookup.isProbableVersion(str = (String)value) ? str : null;
                }

                @Override
                public void visitInsn(int opcode) {
                    if (result == null && this.lastLdc != null && opcode == 176) {
                        result = this.lastLdc;
                    }
                    this.lastLdc = null;
                }

                @Override
                protected void visitAnyInsn() {
                    this.lastLdc = null;
                }
            };
        }
    }

    private static final class MethodConstantVisitor
    extends ClassVisitor
    implements Analyzer {
        private final String methodNameHint;
        private String result;
        private boolean foundInMethodHint;

        public MethodConstantVisitor(String methodNameHint) {
            super(589824);
            this.methodNameHint = methodNameHint;
        }

        @Override
        public String getResult() {
            return this.result;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            final boolean isRequestedMethod = name.equals(this.methodNameHint);
            if (this.result != null && !isRequestedMethod) {
                return null;
            }
            return new MethodVisitor(589824){

                public void visitLdcInsn(Object value) {
                    String str;
                    if ((result == null || !foundInMethodHint && isRequestedMethod) && value instanceof String && McVersionLookup.isProbableVersion(str = (String)value)) {
                        result = str;
                        foundInMethodHint = isRequestedMethod;
                    }
                }
            };
        }
    }

    private static final class MethodStringConstantContainsVisitor
    extends ClassVisitor
    implements Analyzer {
        private final String methodOwner;
        private final String methodName;
        private String result;

        public MethodStringConstantContainsVisitor(String methodOwner, String methodName) {
            super(589824);
            this.methodOwner = methodOwner;
            this.methodName = methodName;
        }

        @Override
        public String getResult() {
            return this.result;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            if (this.result != null) {
                return null;
            }
            return new InsnFwdMethodVisitor(){
                String lastLdc;

                @Override
                public void visitLdcInsn(Object value) {
                    this.lastLdc = value instanceof String ? McVersionLookup.findProbableVersion((String)value) : null;
                }

                @Override
                public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean itf) {
                    if (result == null && this.lastLdc != null && owner.equals(methodOwner) && name.equals(methodName) && descriptor.startsWith("(Ljava/lang/String;)")) {
                        result = this.lastLdc;
                    }
                    this.lastLdc = null;
                }

                @Override
                protected void visitAnyInsn() {
                    this.lastLdc = null;
                }
            };
        }
    }

    private static interface Analyzer {
        public String getResult();
    }

    private static abstract class InsnFwdMethodVisitor
    extends MethodVisitor {
        public InsnFwdMethodVisitor() {
            super(589824);
        }

        protected abstract void visitAnyInsn();

        public void visitLdcInsn(Object value) {
            this.visitAnyInsn();
        }

        public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
            this.visitAnyInsn();
        }

        public void visitInsn(int opcode) {
            this.visitAnyInsn();
        }

        public void visitIntInsn(int opcode, int operand) {
            this.visitAnyInsn();
        }

        public void visitVarInsn(int opcode, int var) {
            this.visitAnyInsn();
        }

        public void visitTypeInsn(int opcode, String type) {
            this.visitAnyInsn();
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            this.visitAnyInsn();
        }

        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            this.visitAnyInsn();
        }

        public void visitJumpInsn(int opcode, Label label) {
            this.visitAnyInsn();
        }

        public void visitIincInsn(int var, int increment) {
            this.visitAnyInsn();
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
            this.visitAnyInsn();
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            this.visitAnyInsn();
        }

        public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
            this.visitAnyInsn();
        }
    }
}

