/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.metadata.ContactInformation;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModDependency;
import net.fabricmc.loader.api.metadata.ModEnvironment;
import net.fabricmc.loader.api.metadata.Person;
import net.fabricmc.loader.metadata.AbstractModMetadata;
import net.fabricmc.loader.metadata.DependencyOverrides;
import net.fabricmc.loader.metadata.EntrypointMetadata;
import net.fabricmc.loader.metadata.LoaderModMetadata;
import net.fabricmc.loader.metadata.NestedJarEntry;
import org.apache.logging.log4j.Logger;

final class V1ModMetadata
extends AbstractModMetadata
implements LoaderModMetadata {
    static final IconEntry NO_ICON = size -> Optional.empty();
    private final String id;
    private final Version version;
    private final Collection<String> provides;
    private final ModEnvironment environment;
    private final Map<String, List<EntrypointMetadata>> entrypoints;
    private final Collection<NestedJarEntry> jars;
    private final Collection<MixinEntry> mixins;
    private final String accessWidener;
    private final Map<String, ModDependency> depends;
    private final Map<String, ModDependency> recommends;
    private final Map<String, ModDependency> suggests;
    private final Map<String, ModDependency> conflicts;
    private final Map<String, ModDependency> breaks;
    @Deprecated
    private final Map<String, ModDependency> requires;
    private final String name;
    private final String description;
    private final Collection<Person> authors;
    private final Collection<Person> contributors;
    private final ContactInformation contact;
    private final Collection<String> license;
    private final IconEntry icon;
    private final Map<String, String> languageAdapters;
    private final Map<String, CustomValue> customValues;

    V1ModMetadata(String id, Version version, Collection<String> provides, ModEnvironment environment, Map<String, List<EntrypointMetadata>> entrypoints, Collection<NestedJarEntry> jars, Collection<MixinEntry> mixins, String accessWidener, Map<String, ModDependency> depends, Map<String, ModDependency> recommends, Map<String, ModDependency> suggests, Map<String, ModDependency> conflicts, Map<String, ModDependency> breaks, Map<String, ModDependency> requires, String name, String description, Collection<Person> authors, Collection<Person> contributors, ContactInformation contact, Collection<String> license, IconEntry icon, Map<String, String> languageAdapters, Map<String, CustomValue> customValues) {
        this.id = id;
        this.version = version;
        this.provides = Collections.unmodifiableCollection(provides);
        this.environment = environment;
        this.entrypoints = Collections.unmodifiableMap(entrypoints);
        this.jars = Collections.unmodifiableCollection(jars);
        this.mixins = Collections.unmodifiableCollection(mixins);
        this.accessWidener = accessWidener;
        this.depends = DependencyOverrides.INSTANCE.getActiveDependencyMap("depends", id, Collections.unmodifiableMap(depends));
        this.recommends = DependencyOverrides.INSTANCE.getActiveDependencyMap("recommends", id, Collections.unmodifiableMap(recommends));
        this.suggests = DependencyOverrides.INSTANCE.getActiveDependencyMap("suggests", id, Collections.unmodifiableMap(suggests));
        this.conflicts = DependencyOverrides.INSTANCE.getActiveDependencyMap("conflicts", id, Collections.unmodifiableMap(conflicts));
        this.breaks = DependencyOverrides.INSTANCE.getActiveDependencyMap("breaks", id, Collections.unmodifiableMap(breaks));
        this.requires = Collections.unmodifiableMap(requires);
        this.name = name;
        this.description = description != null ? description : "";
        this.authors = Collections.unmodifiableCollection(authors);
        this.contributors = Collections.unmodifiableCollection(contributors);
        this.contact = contact != null ? contact : ContactInformation.EMPTY;
        this.license = Collections.unmodifiableCollection(license);
        this.icon = icon != null ? icon : NO_ICON;
        this.languageAdapters = Collections.unmodifiableMap(languageAdapters);
        this.customValues = Collections.unmodifiableMap(customValues);
    }

    @Override
    public int getSchemaVersion() {
        return 1;
    }

    @Override
    public String getType() {
        return "fabric";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Collection<String> getProvides() {
        return this.provides;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public ModEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    public boolean loadsInEnvironment(EnvType type) {
        return this.environment.matches(type);
    }

    @Override
    public Collection<ModDependency> getDepends() {
        return this.depends.values();
    }

    @Override
    public Collection<ModDependency> getRecommends() {
        return this.recommends.values();
    }

    @Override
    public Collection<ModDependency> getSuggests() {
        return this.suggests.values();
    }

    @Override
    public Collection<ModDependency> getConflicts() {
        return this.conflicts.values();
    }

    @Override
    public Collection<ModDependency> getBreaks() {
        return this.breaks.values();
    }

    @Override
    public String getName() {
        if (this.name == null || this.name.isEmpty()) {
            return this.id;
        }
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Collection<Person> getAuthors() {
        return this.authors;
    }

    @Override
    public Collection<Person> getContributors() {
        return this.contributors;
    }

    @Override
    public ContactInformation getContact() {
        return this.contact;
    }

    @Override
    public Collection<String> getLicense() {
        return this.license;
    }

    @Override
    public Optional<String> getIconPath(int size) {
        return this.icon.getIconPath(size);
    }

    @Override
    public Map<String, CustomValue> getCustomValues() {
        return this.customValues;
    }

    @Override
    public Map<String, String> getLanguageAdapterDefinitions() {
        return this.languageAdapters;
    }

    @Override
    public Collection<NestedJarEntry> getJars() {
        return this.jars;
    }

    @Override
    public Collection<String> getMixinConfigs(EnvType type) {
        ArrayList<String> mixinConfigs = new ArrayList<String>();
        for (MixinEntry mixin : this.mixins) {
            if (!mixin.environment.matches(type)) continue;
            mixinConfigs.add(mixin.config);
        }
        return mixinConfigs;
    }

    @Override
    public String getAccessWidener() {
        return this.accessWidener;
    }

    @Override
    public Collection<String> getOldInitializers() {
        return Collections.emptyList();
    }

    @Override
    public List<EntrypointMetadata> getEntrypoints(String type) {
        if (type == null) {
            return Collections.emptyList();
        }
        List<EntrypointMetadata> entrypoints = this.entrypoints.get(type);
        if (entrypoints != null) {
            return entrypoints;
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<String> getEntrypointKeys() {
        return this.entrypoints.keySet();
    }

    @Override
    public void emitFormatWarnings(Logger logger) {
        if (!this.requires.isEmpty()) {
            logger.warn("Mod `{}` ({}) uses 'requires' key in fabric.mod.json, which is not supported - use 'depends'", (Object)this.id, (Object)this.version);
        }
    }

    static interface IconEntry {
        public Optional<String> getIconPath(int var1);
    }

    static final class MixinEntry {
        private final String config;
        private final ModEnvironment environment;

        MixinEntry(String config, ModEnvironment environment) {
            this.config = config;
            this.environment = environment;
        }
    }

    static final class MapEntry
    implements IconEntry {
        private final SortedMap<Integer, String> icons;

        MapEntry(SortedMap<Integer, String> icons) {
            this.icons = icons;
        }

        @Override
        public Optional<String> getIconPath(int size) {
            int i;
            int iconValue = -1;
            Iterator<Integer> iterator = this.icons.keySet().iterator();
            while (iterator.hasNext() && (iconValue = (i = iterator.next().intValue())) < size) {
            }
            return Optional.of((String)this.icons.get(iconValue));
        }
    }

    static final class Single
    implements IconEntry {
        private final String icon;

        Single(String icon) {
            this.icon = icon;
        }

        @Override
        public Optional<String> getIconPath(int size) {
            return Optional.of(this.icon);
        }
    }

    static final class JarEntry
    implements NestedJarEntry {
        private final String file;

        JarEntry(String file) {
            this.file = file;
        }

        @Override
        public String getFile() {
            return this.file;
        }
    }

    static final class EntrypointMetadataImpl
    implements EntrypointMetadata {
        private final String adapter;
        private final String value;

        EntrypointMetadataImpl(String adapter, String value) {
            this.adapter = adapter;
            this.value = value;
        }

        @Override
        public String getAdapter() {
            return this.adapter;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

