/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.launch.knot;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.game.GameProvider;
import net.fabricmc.loader.launch.knot.KnotClassDelegate;
import net.fabricmc.loader.launch.knot.KnotClassLoaderInterface;

class KnotCompatibilityClassLoader
extends URLClassLoader
implements KnotClassLoaderInterface {
    private final KnotClassDelegate delegate;

    KnotCompatibilityClassLoader(boolean isDevelopment, EnvType envType, GameProvider provider) {
        super(new URL[0], KnotCompatibilityClassLoader.class.getClassLoader());
        this.delegate = new KnotClassDelegate(isDevelopment, envType, this, provider);
    }

    @Override
    public KnotClassDelegate getDelegate() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClassLoaded(String name) {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            return this.findLoadedClass(name) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            byte[] input;
            Class<?> c = this.findLoadedClass(name);
            if (c == null && (input = this.delegate.getPostMixinClassByteArray(name)) != null) {
                String pkgString;
                KnotClassDelegate.Metadata metadata = this.delegate.getMetadata(name, this.getResource(this.delegate.getClassFileName(name)));
                int pkgDelimiterPos = name.lastIndexOf(46);
                if (pkgDelimiterPos > 0 && this.getPackage(pkgString = name.substring(0, pkgDelimiterPos)) == null) {
                    this.definePackage(pkgString, null, null, null, null, null, null, null);
                }
                c = this.defineClass(name, input, 0, input.length, metadata.codeSource);
            }
            if (c == null) {
                c = this.getParent().loadClass(name);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    @Override
    public InputStream getResourceAsStream(String classFile, boolean skipOriginalLoader) throws IOException {
        if (skipOriginalLoader && this.findResource(classFile) == null) {
            return null;
        }
        return super.getResourceAsStream(classFile);
    }

    static {
        KnotCompatibilityClassLoader.registerAsParallelCapable();
    }
}

