/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cofh.core.util.fluid.FluidTankAdv;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import powercrystals.minefactoryreloaded.core.AutoEnchantmentHelper;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.gui.client.GuiAutoEnchanter;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerAutoEnchanter;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityAutoEnchanter
extends TileEntityFactoryPowered
implements ITankContainerBucketable {
    private Random _rand = new Random();
    private int _targetLevel = 30;

    public TileEntityAutoEnchanter() {
        super(Machine.AutoEnchanter);
        this.setManageSolids(true);
        this._tanks[0].setLock(FluidRegistry.getFluid((String)"mobessence"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiAutoEnchanter(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerAutoEnchanter getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerAutoEnchanter(this, inventoryPlayer);
    }

    @Override
    public int getWorkMax() {
        if (this._inventory[0] != null && this._inventory[0].func_77973_b().equals(Items.field_151069_bo)) {
            return 250;
        }
        return this._targetLevel + (int)(Math.pow((double)this._targetLevel / 7.5, 4.0) * 10.0 * this.getEnchantmentMultiplier());
    }

    private double getEnchantmentMultiplier() {
        ItemStack itemStack = this._inventory[0];
        if (itemStack == null) {
            return 1.0;
        }
        Map map = AutoEnchantmentHelper.func_82781_a((ItemStack)itemStack);
        if (map == null || map.size() == 0) {
            return 1.0;
        }
        return Math.pow((double)map.size() + 1.0, 2.0);
    }

    @Override
    public int getIdleTicksMax() {
        return 1;
    }

    public int getTargetLevel() {
        return this._targetLevel;
    }

    public void setTargetLevel(int n) {
        this._targetLevel = n;
        if (this._targetLevel > 30) {
            this._targetLevel = 30;
        }
        if (this._targetLevel < 1) {
            this._targetLevel = 1;
        }
        if (this.getWorkDone() >= this.getWorkMax()) {
            this.activateMachine();
        }
    }

    @Override
    protected boolean activateMachine() {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        ItemStack itemStack = this._inventory[0];
        ItemStack itemStack2 = this._inventory[1];
        if (itemStack == null) {
            this.setWorkDone(0);
            return false;
        }
        if (itemStack.field_77994_a <= 0) {
            this.func_70299_a(0, null);
            this.setWorkDone(0);
            return false;
        }
        if (itemStack2 != null) {
            if (itemStack2.field_77994_a >= itemStack2.func_77976_d() || itemStack2.field_77994_a >= this.func_70297_j_()) {
                this.setWorkDone(0);
                return false;
            }
            if (itemStack2.field_77994_a <= 0) {
                this.func_70299_a(1, null);
                itemStack2 = null;
            }
        }
        if (itemStack.func_77973_b().getItemEnchantability(itemStack) == 0 && !itemStack.func_77973_b().equals(Items.field_151069_bo) || itemStack.func_77973_b().equals(Items.field_151134_bR)) {
            if (itemStack2 == null) {
                this._inventory[0] = null;
                this.func_70299_a(1, itemStack);
            } else if (itemStack.func_77969_a(itemStack2) && ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)itemStack2)) {
                int n = Math.min(itemStack2.func_77976_d() - itemStack2.field_77994_a, itemStack.field_77994_a);
                n = Math.min(this.func_70297_j_() - itemStack2.field_77994_a, n);
                if (n <= 0) {
                    this.setWorkDone(0);
                    return false;
                }
                itemStack2.field_77994_a += n;
                itemStack.field_77994_a -= n;
                if (itemStack.field_77994_a <= 0) {
                    this.func_70299_a(0, null);
                }
            } else {
                this.setWorkDone(0);
                return false;
            }
            this.setWorkDone(0);
            return true;
        }
        if (this.getWorkDone() >= this.getWorkMax()) {
            if (itemStack.func_77973_b().equals(Items.field_151069_bo)) {
                if (itemStack2 == null) {
                    itemStack2 = new ItemStack(Items.field_151062_by, 0, 0);
                }
                if (!itemStack2.func_77973_b().equals(Items.field_151062_by)) {
                    this.setWorkDone(0);
                    return false;
                }
                if (--itemStack.field_77994_a <= 0) {
                    this._inventory[0] = null;
                }
                ++itemStack2.field_77994_a;
                this.func_70299_a(1, itemStack2);
                this.setWorkDone(0);
            } else if (itemStack2 == null) {
                itemStack2 = AutoEnchantmentHelper.func_77504_a(this._rand, itemStack, this._targetLevel);
                if (itemStack.field_77994_a <= 0) {
                    this._inventory[0] = null;
                }
                this.func_70299_a(1, itemStack2);
                this.setWorkDone(0);
            } else {
                return false;
            }
            return true;
        }
        if (this.drain(this._tanks[0], 4, false) == 4) {
            if (!this.incrementWorkDone()) {
                return false;
            }
            this.drain(this._tanks[0], 4, true);
            return true;
        }
        return false;
    }

    public int func_70302_i_() {
        return 2;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection forgeDirection) {
        return 2;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        if (n == 0) {
            ItemStack itemStack2 = this._inventory[0];
            return itemStack2 == null || itemStack2.field_77994_a < this.func_70297_j_() && itemStack.func_77969_a(itemStack2) && ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)itemStack2);
        }
        return false;
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return n == 1;
    }

    @Override
    public void writePortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74768_a("targetLevel", this._targetLevel);
    }

    @Override
    public void readPortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        this.setTargetLevel(nBTTagCompound.func_74762_e("targetLevel"));
    }

    @Override
    public void writeItemNBT(NBTTagCompound nBTTagCompound) {
        super.writeItemNBT(nBTTagCompound);
        if (this._targetLevel != 30) {
            nBTTagCompound.func_74768_a("targetLevel", this._targetLevel);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this._targetLevel = nBTTagCompound.func_74762_e("targetLevel");
    }

    @Override
    public boolean allowBucketFill(ItemStack itemStack) {
        return true;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return this.fill(fluidStack, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return this.drain(n, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return this.drain(fluidStack, bl);
    }

    @Override
    protected FluidTankAdv[] createTanks() {
        return new FluidTankAdv[]{new FluidTankAdv(4000)};
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }
}

