/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.modhelpers.forestry;

import forestry.api.genetics.IFruitBearer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import powercrystals.minefactoryreloaded.api.FertilizerType;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.api.IFactoryFertilizable;
import powercrystals.minefactoryreloaded.api.IFactoryFruit;
import powercrystals.minefactoryreloaded.api.ReplacementBlock;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableStandard;
import powercrystals.minefactoryreloaded.modhelpers.EmptyReplacement;

public class ForestryPod
extends HarvestableStandard
implements IFactoryFruit,
IFactoryFertilizable {
    private Item grafter;
    private ReplacementBlock repl = EmptyReplacement.INSTANCE;

    public ForestryPod(Block block, Item item) {
        super(block, HarvestType.TreeFruit);
        this.grafter = item;
    }

    @Override
    public boolean canBeHarvested(World world, Map<String, Boolean> map, int n, int n2, int n3) {
        if (map.get("isHarvestingTree") == Boolean.TRUE) {
            return true;
        }
        return this.canBePicked(world, n, n2, n3);
    }

    @Override
    public boolean canFertilize(World world, int n, int n2, int n3, FertilizerType fertilizerType) {
        if (fertilizerType != FertilizerType.GrowPlant) {
            return false;
        }
        return !this.canBePicked(world, n, n2, n3);
    }

    @Override
    public boolean canBePicked(World world, int n, int n2, int n3) {
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof IFruitBearer) {
            IFruitBearer iFruitBearer = (IFruitBearer)tileEntity;
            return iFruitBearer.getRipeness() >= 0.99f;
        }
        return false;
    }

    @Override
    public boolean fertilize(World world, Random random, int n, int n2, int n3, FertilizerType fertilizerType) {
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof IFruitBearer) {
            IFruitBearer iFruitBearer = (IFruitBearer)tileEntity;
            iFruitBearer.addRipeness(1.0f);
            return true;
        }
        return false;
    }

    @Override
    public ReplacementBlock getReplacementBlock(World world, int n, int n2, int n3) {
        return this.repl;
    }

    @Override
    public void prePick(World world, int n, int n2, int n3) {
    }

    @Override
    public List<ItemStack> getDrops(World world, Random random, Map<String, Boolean> map, int n, int n2, int n3) {
        return this.getDrops(world, random, n, n2, n3);
    }

    @Override
    public List<ItemStack> getDrops(World world, Random random, int n, int n2, int n3) {
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof IFruitBearer) {
            ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
            arrayList.addAll(((IFruitBearer)tileEntity).pickFruit(new ItemStack(this.grafter)));
            return arrayList;
        }
        return null;
    }

    @Override
    public void postPick(World world, int n, int n2, int n3) {
    }
}

