/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.systems.steam;

import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import cpw.mods.fml.common.Optional;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import powercrystals.powerconverters.position.BlockPosition;
import powercrystals.powerconverters.power.PowerSystemManager;
import powercrystals.powerconverters.power.base.TileEntityEnergyProducer;
import powercrystals.powerconverters.power.systems.PowerSteam;

@Optional.Interface(modid="BuildCraft|Core", iface="buildcraft.api.transport.IPipeConnection")
public class TileEntitySteamProducer
extends TileEntityEnergyProducer<IFluidHandler>
implements IFluidHandler,
IPipeConnection {
    PowerSteam powerSteam = (PowerSteam)PowerSystemManager.getInstance().getPowerSystemByName(PowerSteam.id);
    int steamId;

    public TileEntitySteamProducer(int steamId) {
        super(PowerSystemManager.getInstance().getPowerSystemByName(PowerSteam.id), 0, IFluidHandler.class);
        this.steamId = steamId;
    }

    @Override
    public double produceEnergy(double energy) {
        boolean powered;
        boolean bl = powered = this.func_145831_w().func_94572_D(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0;
        if (powered || this.steamId < 0 || this.powerSteam.getInternalEnergyPerOutput(this.steamId + 1) == 0.0f) {
            return energy;
        }
        energy /= (double)this.powerSteam.getInternalEnergyPerOutput(this.steamId + 1);
        for (int i = 0; i < 6; ++i) {
            BlockPosition bp = new BlockPosition(this);
            bp.orientation = ForgeDirection.getOrientation((int)i);
            bp.moveForwards(1);
            TileEntity te = this.field_145850_b.func_147438_o(bp.x, bp.y, bp.z);
            if (te instanceof IFluidHandler) {
                int steam = (int)Math.min(energy, (double)this.powerSteam.getThrottleProducer());
                PowerSteam.SteamType steamType = this.powerSteam.getSteamType(this.steamId);
                FluidStack stack = FluidRegistry.getFluidStack((String)steamType.name, (int)steam);
                if (stack != null) {
                    energy -= (double)((IFluidHandler)te).fill(bp.orientation.getOpposite(), stack, true);
                }
            }
            if (!(energy <= 0.0)) continue;
            return 0.0;
        }
        return energy * (double)this.powerSteam.getInternalEnergyPerOutput(this.steamId + 1);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[0];
    }

    @Override
    public int getSubtype() {
        PowerSteam.SteamType type = this.powerSteam.getSteamType(this.steamId);
        return this.powerSteam.getSteamSubtype(type);
    }

    @Optional.Method(modid="BuildCraft|Core")
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType pipeType, ForgeDirection direction) {
        if (pipeType == IPipeTile.PipeType.FLUID) {
            return IPipeConnection.ConnectOverride.CONNECT;
        }
        return IPipeConnection.ConnectOverride.DISCONNECT;
    }
}

