/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.systems.rf;

import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyReceiver;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.powerconverters.common.TileEntityEnergyBridge;
import powercrystals.powerconverters.power.PowerSystemManager;
import powercrystals.powerconverters.power.base.TileEntityEnergyConsumer;

public class TileEntityRFConsumer
extends TileEntityEnergyConsumer<IEnergyConnection>
implements IEnergyReceiver {
    private int lastReceivedRF;

    public TileEntityRFConsumer() {
        super(PowerSystemManager.getInstance().getPowerSystemByName("RF"), 0, IEnergyConnection.class);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
    }

    @Override
    public double getInputRate() {
        int last = this.lastReceivedRF;
        this.lastReceivedRF = 0;
        return last;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        boolean powered = this.func_145831_w().func_94572_D(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0;
        int received = 0;
        if (!powered) {
            TileEntityEnergyBridge bridge = this.getFirstBridge();
            if (bridge == null) {
                return 0;
            }
            float energyToReceive = this.getPowerSystem().getInternalEnergyPerInput(0) * (float)maxReceive;
            received = (int)((double)energyToReceive - this.storeEnergy(energyToReceive, simulate));
            if (!simulate) {
                this.lastReceivedRF = (int)((float)received / this.getPowerSystem().getInternalEnergyPerInput(0));
                return this.lastReceivedRF;
            }
        }
        return (int)((float)received / this.getPowerSystem().getInternalEnergyPerInput(0));
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public int getEnergyStored(ForgeDirection from) {
        TileEntityEnergyBridge bridge = this.getFirstBridge();
        if (bridge == null) {
            return 0;
        }
        return (int)((float)bridge.getEnergyStored() / this.getPowerSystem().getInternalEnergyPerInput(0));
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        TileEntityEnergyBridge bridge = this.getFirstBridge();
        if (bridge == null) {
            return 0;
        }
        return (int)((float)bridge.getEnergyStoredMax() / this.getPowerSystem().getInternalEnergyPerInput(0));
    }
}

