/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.systems;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.config.Configuration;
import powercrystals.powerconverters.power.PowerSystem;
import powercrystals.powerconverters.power.systems.steam.BlockSteam;
import powercrystals.powerconverters.power.systems.steam.ItemBlockSteam;
import powercrystals.powerconverters.power.systems.steam.TileEntitySteamConsumer;
import powercrystals.powerconverters.power.systems.steam.TileEntitySteamProducer;

public class PowerSteam
extends PowerSystem {
    public static String id = "STEAM";
    private HashMap<String, SteamType> steamTypes = new HashMap();
    private HashMap<String, SteamType> serverSteamTypes = new HashMap();
    private List<String> serverSteamTypeNames = new ArrayList<String>();
    public static final String CATEGORY_STEAM = "powersystems.steam";
    private static final int THROTTLE_CONSUMER_DEFAULT = 1000;
    private static final int THROTTLE_PRODUCER_DEFAULT = 1000;
    private int throttleConsumer = 1000;
    private int throttleProducer = 1000;

    public PowerSteam() {
        this.name = "Steam";
        this._unit = "mB";
        this.block = new BlockSteam();
        this.itemBlock = ItemBlockSteam.class;
        this.consumer = TileEntitySteamConsumer.class;
        this.producer = TileEntitySteamProducer.class;
    }

    @Override
    public void readEnergyValues(NBTTagCompound nbt) {
        this.serverSteamTypes.clear();
        this.serverSteamTypeNames.clear();
        NBTTagList types = nbt.func_150295_c("steamTypes", 10);
        for (int i = 0; i < types.func_74745_c(); ++i) {
            NBTTagCompound type = types.func_150305_b(i);
            SteamType newSteam = new SteamType(type.func_74779_i("name"), type.func_74779_i("display"), type.func_74760_g("Input"), type.func_74760_g("Output"));
            this.serverSteamTypes.put(newSteam.name, newSteam);
            this.serverSteamTypeNames.add(newSteam.name);
        }
        Collections.sort(this.serverSteamTypeNames, String.CASE_INSENSITIVE_ORDER);
    }

    @Override
    public NBTTagCompound writeEnergyValues() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList types = new NBTTagList();
        for (SteamType type : this.steamTypes.values()) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("name", type.name);
            data.func_74778_a("display", type.displayName);
            data.func_74776_a("Input", type.energyPerInput);
            data.func_74776_a("Output", type.energyPerOutput);
            types.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("steamTypes", (NBTBase)types);
        return nbt;
    }

    public void addSteamType(String name, String displayName, float input, float output) {
        if (!this.steamTypes.containsKey(name)) {
            this.steamTypes.put(name, new SteamType(name, displayName, input, output));
        }
    }

    public SteamType getSteamType(String name) {
        return this.serverSteamTypes.get(name);
    }

    public SteamType getSteamType(int index) {
        return index < this.serverSteamTypeNames.size() ? this.serverSteamTypes.get(this.serverSteamTypeNames.get(index)) : null;
    }

    public int getSteamSubtype(SteamType steamType) {
        return this.serverSteamTypeNames.indexOf(steamType.name);
    }

    @Override
    public float getInternalEnergyPerInput(int meta) {
        SteamType type = this.getSteamType(meta);
        return type == null ? 0.0f : type.energyPerOutput;
    }

    @Override
    public float getInternalEnergyPerOutput(int meta) {
        SteamType type;
        if (meta < 0) {
            return 0.0f;
        }
        if (meta == 0) {
            ++meta;
        }
        return (type = this.getSteamType(meta - 1)) == null ? 0.0f : type.energyPerOutput;
    }

    @Override
    public String getUnit(int subtype) {
        if (subtype == -1) {
            return super.getUnit(subtype);
        }
        return String.format("%s (%s)", super.getUnit(subtype), this.getSteamType((int)subtype).displayName);
    }

    public int getSteamTypeCount() {
        return this.steamTypes.size();
    }

    @Override
    public void registerBlocks() {
        GameRegistry.registerBlock((Block)this.block, (Class)this.itemBlock, (String)"converter.steam");
        GameRegistry.registerTileEntity((Class)this.consumer, (String)"powerConverterSteamConsumer");
        GameRegistry.registerTileEntity((Class)this.producer, (String)"powerConverterSteamProducer");
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public void registerCommonRecipes() {
        for (int i = 0; i < this.serverSteamTypeNames.size(); ++i) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, i), (Object[])new Object[]{new ItemStack((Block)this.block, 1, i + 1)});
        }
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, 1, this.serverSteamTypeNames.size()), (Object[])new Object[]{new ItemStack((Block)this.block, 1, 0)});
    }

    @Override
    public void loadConfig(Configuration c) {
        for (String typeName : this.steamTypes.keySet()) {
            SteamType updatedType = this.steamTypes.get(typeName);
            updatedType.energyPerInput = (float)c.get(CATEGORY_STEAM, String.format("%s.internalEnergyPerInput", updatedType.name), (double)updatedType.defaultEnergyPerInput).getDouble((double)updatedType.defaultEnergyPerInput);
            updatedType.energyPerOutput = (float)c.get(CATEGORY_STEAM, String.format("%s.internalEnergyPerOutput", updatedType.name), (double)updatedType.defaultEnergyPerOutput).getDouble((double)updatedType.defaultEnergyPerOutput);
            this.steamTypes.put(typeName, updatedType);
        }
        this.throttleConsumer = c.get(CATEGORY_STEAM, "throttle.steamConsumer", 1000, "mB/t").getInt(1000);
        this.throttleProducer = c.get(CATEGORY_STEAM, "throttle.steamProducer", 1000, "mB/t\n (Suggested value for mod expoit handling = 1; this does not diminish steam return)").getInt(1000);
    }

    @Override
    public void saveConfig(Configuration c) {
        for (SteamType type : this.steamTypes.values()) {
            c.getCategory(CATEGORY_STEAM).get(String.format("%s.internalEnergyPerInput", type.name)).set((double)type.energyPerInput);
            c.getCategory(CATEGORY_STEAM).get(String.format("%s.internalEnergyPerOutput", type.name)).set((double)type.energyPerOutput);
        }
        c.getCategory(CATEGORY_STEAM).get("throttle.steamConsumer").set(this.throttleConsumer);
        c.getCategory(CATEGORY_STEAM).get("throttle.steamProducer").set(this.throttleProducer);
    }

    public int getThrottleConsumer() {
        return this.throttleConsumer;
    }

    public int getThrottleProducer() {
        return this.throttleProducer;
    }

    public class SteamType {
        public String name;
        public String displayName;
        public float defaultEnergyPerInput;
        public float defaultEnergyPerOutput;
        public float energyPerInput;
        public float energyPerOutput;

        public SteamType(String name, String displayName, float input, float output) {
            this.name = name;
            this.displayName = displayName;
            this.defaultEnergyPerInput = input;
            this.defaultEnergyPerOutput = output;
            this.energyPerInput = input;
            this.energyPerOutput = output;
        }
    }
}

