/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.power.base;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.powerconverters.common.TileEntityEnergyBridge;
import powercrystals.powerconverters.position.BlockPosition;
import powercrystals.powerconverters.position.INeighboorUpdateTile;
import powercrystals.powerconverters.power.PowerSystem;

public class TileEntityBridgeComponent<T>
extends TileEntity
implements INeighboorUpdateTile {
    private Map<ForgeDirection, TileEntityEnergyBridge> _adjacentBridges = new HashMap<ForgeDirection, TileEntityEnergyBridge>();
    private Map<ForgeDirection, T> _adjacentTiles = new HashMap<ForgeDirection, T>();
    private Class<?> _adjacentClass;
    protected PowerSystem _powerSystem;
    protected int _voltageIndex;
    private boolean _initialized;

    protected TileEntityBridgeComponent(PowerSystem powersystem, int voltageNameIndex, Class<T> adjacentClass) {
        this._powerSystem = powersystem;
        this._voltageIndex = voltageNameIndex;
        this._adjacentClass = adjacentClass;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this._initialized && !this.field_145846_f) {
            this.onNeighboorChanged();
            this._initialized = true;
        }
    }

    @Override
    public void onNeighboorChanged() {
        HashMap<ForgeDirection, TileEntityEnergyBridge> adjacentBridges = new HashMap<ForgeDirection, TileEntityEnergyBridge>();
        HashMap<ForgeDirection, T> adjacentTiles = new HashMap<ForgeDirection, T>();
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity te = BlockPosition.getAdjacentTileEntity(this, d);
            if (te instanceof TileEntityEnergyBridge) {
                adjacentBridges.put(d, (TileEntityEnergyBridge)te);
                continue;
            }
            if (te == null || !this._adjacentClass.isAssignableFrom(te.getClass())) continue;
            adjacentTiles.put(d, te);
        }
        this._adjacentBridges = adjacentBridges;
        this._adjacentTiles = adjacentTiles;
    }

    public PowerSystem getPowerSystem() {
        return this._powerSystem;
    }

    public boolean isConnected() {
        return this._adjacentTiles.size() > 0;
    }

    public boolean isSideConnected(int side) {
        return this._adjacentTiles.get(ForgeDirection.getOrientation((int)side)) != null;
    }

    public boolean isSideConnectedClient(int side) {
        TileEntity te = BlockPosition.getAdjacentTileEntity(this, ForgeDirection.getOrientation((int)side));
        return te != null && this._adjacentClass.isAssignableFrom(te.getClass());
    }

    public int getVoltageIndex() {
        return this._voltageIndex;
    }

    public int getSubtype() {
        return -1;
    }

    public TileEntityEnergyBridge getFirstBridge() {
        return this._adjacentBridges.size() == 0 ? null : (TileEntityEnergyBridge)this._adjacentBridges.values().toArray()[0];
    }

    protected Map<ForgeDirection, TileEntityEnergyBridge> getBridges() {
        return this._adjacentBridges;
    }

    protected Map<ForgeDirection, T> getTiles() {
        return this._adjacentTiles;
    }

    public void onChunkUnload() {
        this.func_145843_s();
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (this._voltageIndex == 0) {
            this._voltageIndex = tagCompound.func_74762_e("voltageIndex");
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("voltageIndex", this._voltageIndex);
    }
}

