/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.position;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPosition {
    public int x;
    public int y;
    public int z;
    public ForgeDirection orientation;

    public BlockPosition(int x, int y, int z) {
        this(x, y, z, ForgeDirection.UNKNOWN);
    }

    public BlockPosition(TileEntity tile) {
        this(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, ForgeDirection.UNKNOWN);
    }

    public BlockPosition(int x, int y, int z, ForgeDirection orientation) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.orientation = orientation;
    }

    public void moveRight(int step) {
        switch (this.orientation) {
            case SOUTH: {
                this.x -= step;
                break;
            }
            case NORTH: {
                this.x += step;
                break;
            }
            case EAST: {
                this.z += step;
                break;
            }
            case WEST: {
                this.z -= step;
                break;
            }
        }
    }

    public void moveLeft(int step) {
        this.moveRight(-step);
    }

    public void moveForwards(int step) {
        switch (this.orientation) {
            case UP: {
                this.y += step;
                break;
            }
            case DOWN: {
                this.y -= step;
                break;
            }
            case SOUTH: {
                this.z += step;
                break;
            }
            case NORTH: {
                this.z -= step;
                break;
            }
            case EAST: {
                this.x += step;
                break;
            }
            case WEST: {
                this.x -= step;
                break;
            }
        }
    }

    public void moveBackwards(int step) {
        this.moveForwards(-step);
    }

    public void moveUp(int step) {
        switch (this.orientation) {
            case SOUTH: 
            case NORTH: 
            case EAST: 
            case WEST: {
                this.y += step;
                break;
            }
        }
    }

    public void moveDown(int step) {
        this.moveUp(-step);
    }

    public String toString() {
        if (this.orientation == null) {
            return "{" + this.x + ", " + this.y + ", " + this.z + "}";
        }
        return "{" + this.x + ", " + this.y + ", " + this.z + ";" + this.orientation.toString() + "}";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlockPosition)) {
            return false;
        }
        BlockPosition bp = (BlockPosition)obj;
        return bp.x == this.x && bp.y == this.y && bp.z == this.z && bp.orientation == this.orientation;
    }

    public int hashCode() {
        return this.x & 0xFFF | this.y & 0xFF00 | this.z & 0xFFF000;
    }

    public List<BlockPosition> getAdjacent(boolean includeVertical) {
        ArrayList<BlockPosition> a = new ArrayList<BlockPosition>();
        a.add(new BlockPosition(this.x + 1, this.y, this.z, ForgeDirection.EAST));
        a.add(new BlockPosition(this.x - 1, this.y, this.z, ForgeDirection.WEST));
        a.add(new BlockPosition(this.x, this.y, this.z + 1, ForgeDirection.SOUTH));
        a.add(new BlockPosition(this.x, this.y, this.z - 1, ForgeDirection.NORTH));
        if (includeVertical) {
            a.add(new BlockPosition(this.x, this.y + 1, this.z, ForgeDirection.UP));
            a.add(new BlockPosition(this.x, this.y - 1, this.z, ForgeDirection.DOWN));
        }
        return a;
    }

    public static TileEntity getAdjacentTileEntity(TileEntity start, ForgeDirection direction) {
        BlockPosition p = new BlockPosition(start);
        p.orientation = direction;
        p.moveForwards(1);
        return start.func_145831_w().func_147438_o(p.x, p.y, p.z);
    }
}

