/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.gui;

import java.text.DecimalFormat;
import java.util.ArrayList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import powercrystals.powerconverters.common.BridgeSideData;
import powercrystals.powerconverters.common.TileEntityEnergyBridge;
import powercrystals.powerconverters.gui.ContainerEnergyBridge;
import powercrystals.powerconverters.renderer.ExposedGuiContainer;
import powercrystals.powerconverters.renderer.RenderUtility;

public class GuiEnergyBridge
extends ExposedGuiContainer {
    private static final ResourceLocation loc = new ResourceLocation("PowerConverters:textures/gui/energybridge.png");
    private static final int _barColor = -16734721;
    private static final DecimalFormat format = new DecimalFormat("###.##");
    protected TileEntityEnergyBridge _bridge;
    private RenderUtility utility = new RenderUtility(this);

    public GuiEnergyBridge(ContainerEnergyBridge container, TileEntityEnergyBridge te) {
        super(container);
        this.field_147000_g = 195;
        this._bridge = te;
    }

    public void func_73863_a(int mouseX, int mouseY, float gameTicks) {
        super.func_73863_a(mouseX, mouseY, gameTicks);
        if (this.isPointInRegion(46, 90, 122, 9, mouseX, mouseY)) {
            ArrayList<String> tooltips = new ArrayList<String>(ForgeDirection.VALID_DIRECTIONS.length);
            float percentage = 100.0f * ((float)this._bridge.getEnergyStored() / (float)this._bridge.getEnergyStoredMax());
            tooltips.add(format.format(percentage) + "% " + StatCollector.func_74838_a((String)"powerconverters.percentfull"));
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                BridgeSideData data = this._bridge.getDataForSide(dir);
                if (data == null || data.powerSystem == null) continue;
                String unit = data.powerSystem.getUnit(data.subtype);
                String toAdd = (float)this._bridge.getEnergyStored() / data.powerSystem.getInternalEnergyPerOutput(data.subtype) + " " + unit;
                if (tooltips.contains(toAdd)) continue;
                tooltips.add(toAdd);
            }
            this.utility.drawTooltips(tooltips, mouseX, mouseY);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"powerconverters.common.bridge.name"), 8, 6, 0x404040);
        if (this._bridge.isInputLimited()) {
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"powerconverters.inputlimited"), 98, 6, -1);
        } else {
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"powerconverters.outputlimited"), 90, 6, -1);
        }
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)("powerconverters." + dir.toString().toLowerCase())), 10, 6 + 12 * (i + 1), -1);
            BridgeSideData data = this._bridge.getDataForSide(dir);
            if ((data.isConsumer || data.isProducer) && data.powerSystem != null) {
                String name = data.powerSystem.getId();
                if (data.powerSystem.getVoltageNames() != null) {
                    name = name + " " + data.powerSystem.getVoltageNames()[data.voltageNameIndex];
                }
                this.field_146289_q.func_78276_b(name, 49, 6 + 12 * (i + 1), -1);
                this.field_146289_q.func_78276_b(data.isConsumer ? StatCollector.func_74838_a((String)"powerconverters.in") : StatCollector.func_74838_a((String)"powerconverters.out"), 92, 6 + 12 * (i + 1), -1);
                String rate = data.isConnected ? data.powerSystem.getRateString(data) : StatCollector.func_74838_a((String)"powerconverters.nolink");
                this.field_146289_q.func_78276_b(rate, 119, 6 + 12 * (i + 1), -1);
                continue;
            }
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"powerconverters.none"), 49, 6 + 12 * (i + 1), -1);
        }
        this.field_146289_q.func_78276_b("% CHG", 10, 90, -1);
        GL11.glDisable((int)2896);
        GuiEnergyBridge.func_73734_a((int)46, (int)97, (int)(46 + this._bridge.getEnergyScaled()), (int)89, (int)-16734721);
        GL11.glEnable((int)2896);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float gameTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(loc);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            BridgeSideData data = this._bridge.getDataForSide(dir);
            if ((data.isConsumer || data.isProducer) && data.powerSystem != null) {
                if (!data.isConnected) {
                    this.func_73729_b(x + 7, y + 15 + 12 * i, 0, 208, 162, 12);
                    continue;
                }
                if (data.outputRate == 0.0) {
                    this.func_73729_b(x + 7, y + 15 + 12 * i, 0, 234, 162, 12);
                    continue;
                }
                this.func_73729_b(x + 7, y + 15 + 12 * i, 0, 195, 162, 12);
                continue;
            }
            this.func_73729_b(x + 7, y + 15 + 12 * i, 0, 221, 162, 12);
        }
    }
}

