/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.powerconverters.common;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import powercrystals.powerconverters.common.IChargeHandler;
import powercrystals.powerconverters.power.PowerSystemManager;
import powercrystals.powerconverters.power.base.TileEntityEnergyProducer;

public class TileEntityCharger
extends TileEntityEnergyProducer<IInventory> {
    private static List<IChargeHandler> _chargeHandlers = new ArrayList<IChargeHandler>();
    private EntityPlayer _player;

    public static void registerChargeHandler(IChargeHandler handler) {
        _chargeHandlers.add(handler);
    }

    public TileEntityCharger() {
        super(PowerSystemManager.getInstance().getPowerSystemByName("IC2"), 0, IInventory.class);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this._player != null) {
            int pX = (int)Math.floor(this._player.field_70165_t);
            int pY = (int)Math.floor(this._player.field_70163_u - this._player.func_70033_W());
            int pZ = (int)Math.floor(this._player.field_70161_v);
            if (pX != this.field_145851_c || pY - 1 != this.field_145848_d || pZ != this.field_145849_e) {
                this.setPlayer(null);
            }
        }
    }

    @Override
    public double produceEnergy(double energy) {
        boolean powered;
        if (energy == 0.0) {
            return 0.0;
        }
        int energyRemaining = (int)energy;
        boolean bl = powered = this.func_145831_w().func_94572_D(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0;
        if (!powered) {
            if (this._player != null) {
                energyRemaining = this.chargeInventory((IInventory)this._player.field_71071_by, energyRemaining);
            }
            for (IInventory inv : this.getTiles().values()) {
                energyRemaining = this.chargeInventory(inv, energyRemaining);
            }
        }
        return energyRemaining;
    }

    private int chargeInventory(IInventory inventory, int energy) {
        int energyRemaining = energy;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            for (IChargeHandler chargeHandler : _chargeHandlers) {
                ItemStack s = inventory.func_70301_a(i);
                if (s == null || !chargeHandler.canHandle(s) || (energyRemaining = chargeHandler.charge(s, energyRemaining)) >= energy) continue;
                this._powerSystem = chargeHandler.getPowerSystem();
                energy = energyRemaining;
            }
        }
        return energyRemaining;
    }

    public void setPlayer(EntityPlayer player) {
        if (this._player != player) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this._player = player;
        }
    }

    @Override
    public boolean isConnected() {
        return super.isConnected() || this._player != null;
    }

    @Override
    public boolean isSideConnected(int side) {
        return side == 1 && this._player != null || super.isSideConnected(side);
    }

    @Override
    public boolean isSideConnectedClient(int side) {
        return side == 1 && this._player != null || super.isSideConnectedClient(side);
    }
}

