/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.pneumaticcraft.handlers;

import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.item.ItemStack;
import pneumaticCraft.api.recipe.AssemblyRecipe;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.pneumaticcraft.Assembly")
public class Assembly {
    public static final String name = "PneumaticCraft Assembly";

    @ZenMethod
    public static void addDrillRecipe(IItemStack input, IItemStack output) {
        Assembly.addRecipe(input, output, AssemblyRecipe.drillRecipes);
    }

    @ZenMethod
    public static void addLaserRecipe(IItemStack input, IItemStack output) {
        Assembly.addRecipe(input, output, AssemblyRecipe.laserRecipes);
    }

    @ZenMethod
    public static void addLaserDrillRecipe(IItemStack input, IItemStack output) {
        Assembly.addRecipe(input, output, AssemblyRecipe.drillLaserRecipes);
    }

    public static void addRecipe(IItemStack input, IItemStack output, List<AssemblyRecipe> list) {
        if (input == null || output == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        ItemStack in = InputHelper.toStack(input);
        for (AssemblyRecipe recipe : list) {
            if (!StackHelper.areEqual(recipe.getInput(), in)) continue;
            LogHelper.logWarning(String.format("Duplicate %s Recipe found for %s. Command ignored!", name, LogHelper.getStackDescription(in)));
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new Add(new AssemblyRecipe(InputHelper.toStack(input), InputHelper.toStack(output)), list));
    }

    @ZenMethod
    public static void removeDrillRecipe(IIngredient output) {
        Assembly.removeRecipe(AssemblyRecipe.drillRecipes, output);
    }

    @ZenMethod
    public static void removeLaserRecipe(IIngredient output) {
        Assembly.removeRecipe(AssemblyRecipe.laserRecipes, output);
    }

    @ZenMethod
    public static void removeLaserDrillRecipe(IIngredient output) {
        Assembly.removeRecipe(AssemblyRecipe.drillLaserRecipes, output);
    }

    public static void removeRecipe(List<AssemblyRecipe> list, IIngredient output) {
        LinkedList<AssemblyRecipe> recipes = new LinkedList<AssemblyRecipe>();
        for (AssemblyRecipe r : list) {
            if (r.getOutput() == null || !StackHelper.matches(output, InputHelper.toIItemStack(r.getOutput()))) continue;
            recipes.add(r);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(list, recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, output.toString()));
        }
    }

    private static class Remove
    extends BaseListRemoval<AssemblyRecipe> {
        public Remove(List<AssemblyRecipe> list, List<AssemblyRecipe> recipes) {
            super(Assembly.name, list, recipes);
        }

        @Override
        public String getRecipeInfo(AssemblyRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getOutput());
        }
    }

    private static class Add
    extends BaseListAddition<AssemblyRecipe> {
        public Add(AssemblyRecipe recipe, List<AssemblyRecipe> list) {
            super(Assembly.name, list);
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(AssemblyRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getOutput());
        }
    }
}

