/*
 * Decompiled with CFR 0.152.
 */
package brad16840.plugins;

import brad16840.common.Common;
import brad16840.common.GenericBlock164;
import brad16840.common.UnknownItem;
import brad16840.plugins.nei.FurnaceRecipeHandlerOverride;
import brad16840.plugins.nei.ShapedRecipeHandlerOverride;
import brad16840.plugins.nei.ShapelessRecipeHandlerOverride;
import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.recipe.FurnaceRecipeHandler;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.recipe.ShapedRecipeHandler;
import codechicken.nei.recipe.ShapelessRecipeHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;

public class NEIBackpacksConfig
implements IConfigureNEI {
    private ICraftingHandler defaultShapedRecipeHandler = null;
    private ICraftingHandler defaultShapelessRecipeHandler = null;
    private ICraftingHandler defaultFurnaceRecipeHandler = null;
    private IUsageHandler defaultShapedUsageHandler = null;
    private IUsageHandler defaultShapelessUsageHandler = null;
    private IUsageHandler defaultFurnaceUsageHandler = null;

    public String getName() {
        return "Backpacks!";
    }

    public String getVersion() {
        return "3.5.8";
    }

    private void addRecipeHandler(int desiredIndex, ICraftingHandler h, IUsageHandler u) {
        if (h != null) {
            try {
                GuiCraftingRecipe.craftinghandlers.add(desiredIndex, h);
            }
            catch (Exception e) {
                API.registerRecipeHandler((ICraftingHandler)h);
            }
        }
        if (u != null) {
            try {
                GuiUsageRecipe.usagehandlers.add(desiredIndex, u);
            }
            catch (Exception e) {
                API.registerUsageHandler((IUsageHandler)u);
            }
        }
    }

    public static List<IRecipe> GetRecipes() {
        List recipeList = CraftingManager.func_77594_a().func_77592_b();
        return new ArrayList<IRecipe>(recipeList);
    }

    public void loadConfig() {
        if (Common.disableNEIPlugin) {
            return;
        }
        if (Common.overrideNEI) {
            ListIterator recipes = GuiCraftingRecipe.craftinghandlers.listIterator();
            while (recipes.hasNext()) {
                ICraftingHandler handler = (ICraftingHandler)recipes.next();
                if (handler.getClass() == ShapedRecipeHandler.class) {
                    this.defaultShapedRecipeHandler = handler;
                    recipes.remove();
                }
                if (handler.getClass() == ShapelessRecipeHandler.class) {
                    this.defaultShapelessRecipeHandler = handler;
                    recipes.remove();
                }
                if (handler.getClass() != FurnaceRecipeHandler.class) continue;
                this.defaultFurnaceRecipeHandler = handler;
                recipes.remove();
            }
            ListIterator usages = GuiUsageRecipe.usagehandlers.listIterator();
            while (usages.hasNext()) {
                IUsageHandler handler = (IUsageHandler)usages.next();
                if (handler.getClass() == ShapedRecipeHandler.class) {
                    this.defaultShapedUsageHandler = handler;
                    usages.remove();
                }
                if (handler.getClass() == ShapelessRecipeHandler.class) {
                    this.defaultShapelessUsageHandler = handler;
                    usages.remove();
                }
                if (handler.getClass() != FurnaceRecipeHandler.class) continue;
                this.defaultFurnaceUsageHandler = handler;
                usages.remove();
            }
            this.addRecipeHandler(0, (ICraftingHandler)new ShapedRecipeHandlerOverride(), (IUsageHandler)new ShapedRecipeHandlerOverride());
            this.addRecipeHandler(1, (ICraftingHandler)new ShapelessRecipeHandlerOverride(), (IUsageHandler)new ShapelessRecipeHandlerOverride());
            this.addRecipeHandler(3, (ICraftingHandler)new FurnaceRecipeHandlerOverride(), (IUsageHandler)new FurnaceRecipeHandlerOverride());
        } else {
            this.addRecipeHandler(0, this.defaultShapedRecipeHandler, this.defaultShapedUsageHandler);
            this.addRecipeHandler(1, (ICraftingHandler)new ShapedRecipeHandlerOverride(), (IUsageHandler)new ShapedRecipeHandlerOverride());
            this.addRecipeHandler(2, this.defaultShapelessRecipeHandler, this.defaultShapelessUsageHandler);
            this.addRecipeHandler(3, (ICraftingHandler)new ShapelessRecipeHandlerOverride(), (IUsageHandler)new ShapelessRecipeHandlerOverride());
            this.addRecipeHandler(5, this.defaultFurnaceRecipeHandler, this.defaultFurnaceUsageHandler);
            this.addRecipeHandler(6, (ICraftingHandler)new FurnaceRecipeHandlerOverride(), (IUsageHandler)new FurnaceRecipeHandlerOverride());
            this.defaultShapedRecipeHandler = null;
            this.defaultShapedUsageHandler = null;
            this.defaultShapelessRecipeHandler = null;
            this.defaultShapelessUsageHandler = null;
            this.defaultFurnaceRecipeHandler = null;
            this.defaultFurnaceUsageHandler = null;
        }
        API.hideItem((ItemStack)new ItemStack((Block)Common.backpackBlock));
        for (Block upgradeBlock : GenericBlock164.genericBlocks) {
            API.hideItem((ItemStack)new ItemStack(upgradeBlock));
        }
        for (String id : UnknownItem.customItems.keySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            if (UnknownItem.customItems.containsKey(id)) {
                NBTTagCompound tag2 = UnknownItem.customItems.get(id);
                for (Object key : tag2.func_150296_c()) {
                    if (tag.func_74764_b((String)key)) continue;
                    tag.func_74782_a((String)key, tag2.func_74781_a((String)key).func_74737_b());
                }
            }
            ItemStack stack = UnknownItem.wrap(id, 0, 1);
            stack.func_77982_d(tag);
            API.addItemVariant((Item)Common.unknownItem, (ItemStack)stack);
        }
    }
}

