/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common.permissions;

import brad16840.common.Common;
import brad16840.common.PacketHandler;
import brad16840.common.Translatable;
import brad16840.common.UniqueItemData;
import brad16840.common.permissions.ItemPermission;
import brad16840.common.permissions.PermissionData;
import brad16840.common.permissions.PermissionPlayer;
import brad16840.common.permissions.PermissionRule;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.WeakHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.world.World;

public class PermissionGroup {
    public PermissionGroup owner;
    public PermissionGroup parent;
    public HashSet<PermissionGroup> subscribedGroups;
    public HashMap<PermissionPlayer, Integer> accessCache;
    public String name;
    public int tempId;
    public ArrayList<PermissionRule> rules;
    public static int currentId = 132;
    public int visibility;
    public boolean deleted = false;
    public World world;
    public static Translatable _name = new Translatable("permission.group", new Object[0]);
    public static HashMap<String, Boolean> isOpped = new HashMap();

    public static boolean hasGroup(World world, String id) {
        PermissionData.get(world);
        return PermissionData.groups.containsKey(id);
    }

    public static PermissionPlayer getPlayerPermission(EntityPlayer player) {
        return PermissionGroup.getPlayerPermission(player.field_70170_p, "P_" + player.func_70005_c_());
    }

    public static PermissionGroup createGroup(World world, String string, String owner) {
        PermissionData data = PermissionData.get(world);
        String id = "G_" + string;
        if (PermissionData.groups.containsKey(id)) {
            return PermissionData.groups.get(id);
        }
        PermissionGroup group = new PermissionGroup(id.substring(2), data, world);
        group.owner = PermissionGroup.getGroup(world, "P_" + owner);
        group.markDirty(world);
        return group;
    }

    public static PermissionPlayer getPlayerPermission(World world, String id) {
        PermissionData data = PermissionData.get(world);
        if (!id.startsWith("P_")) {
            id = "P_" + id;
        }
        if (PermissionData.groups.containsKey(id)) {
            return (PermissionPlayer)PermissionData.groups.get(id);
        }
        return new PermissionPlayer(data, world, id.substring(2));
    }

    public static PermissionGroup getItemPermission(World world, String id) {
        PermissionData data = PermissionData.get(world);
        if (!id.startsWith("I_")) {
            id = "I_" + id;
        }
        if (PermissionData.groups.containsKey(id)) {
            return PermissionData.groups.get(id);
        }
        return new ItemPermission(data, world, id.substring(2));
    }

    public static PermissionGroup getSpecialGroup(World world, String id) {
        PermissionData data = PermissionData.get(world);
        if (PermissionData.groups.containsKey(id)) {
            return PermissionData.groups.get(id);
        }
        if (id.equals(SpecialPermissionGroup.allowId)) {
            return new SpecialPermissionGroup(data, world, true);
        }
        if (id.equals(SpecialPermissionGroup.denyId)) {
            return new SpecialPermissionGroup(data, world, false);
        }
        if (id.equals(ModeratorPermissionGroup.id)) {
            return new ModeratorPermissionGroup(data, world);
        }
        throw new RuntimeException("Invalid permission id: " + id);
    }

    public static PermissionGroup getGroup(World world, String id) {
        PermissionData data = PermissionData.get(world);
        if (PermissionData.groups.containsKey(id)) {
            return PermissionData.groups.get(id);
        }
        if (id.startsWith("S_")) {
            if (id.equals(SpecialPermissionGroup.allowId)) {
                return new SpecialPermissionGroup(data, world, true);
            }
            if (id.equals(SpecialPermissionGroup.denyId)) {
                return new SpecialPermissionGroup(data, world, false);
            }
            if (id.equals(ModeratorPermissionGroup.id)) {
                return new ModeratorPermissionGroup(data, world);
            }
        } else {
            if (id.startsWith("G_")) {
                if (!data.permissions.containsKey(id)) {
                    return null;
                }
                return new PermissionGroup(id.substring(2), data, world);
            }
            if (id.startsWith("I_")) {
                return new ItemPermission(data, world, id.substring(2));
            }
            if (id.startsWith("P_")) {
                return new PermissionPlayer(data, world, id.substring(2));
            }
        }
        return null;
    }

    protected PermissionGroup(PermissionData data, World world, String name) {
        this.name = name;
        this.world = world;
        this.owner = null;
        this.parent = null;
        this.visibility = 1;
        this.subscribedGroups = new HashSet();
        this.accessCache = new HashMap();
        this.rules = new ArrayList();
        this.tempId = currentId++;
        PermissionData.groups.put(this.getId(), this);
    }

    protected PermissionGroup(String name, PermissionData data, World world) {
        this(data, world, name);
        boolean newGroup = !data.hasPermission(this);
        NBTTagCompound tag = data.getPermission(this);
        if (tag.func_74764_b("owner")) {
            this.owner = PermissionGroup.getGroup(world, tag.func_74779_i("owner"));
        }
        if (this.owner == null) {
            this.owner = PermissionGroup.getGroup(world, SpecialPermissionGroup.allowId);
        }
        if (tag.func_74764_b("parent")) {
            this.parent = PermissionGroup.getGroup(world, tag.func_74779_i("parent"));
        }
        if (this.parent == null) {
            this.parent = PermissionGroup.getGroup(world, SpecialPermissionGroup.denyId);
        }
        if (tag.func_74764_b("visibility")) {
            this.visibility = tag.func_74762_e("visibility");
        }
        NBTTagList tagList = tag.func_150295_c("rules", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            tag = tagList.func_150305_b(i);
            if (tag.func_74764_b("group")) {
                PermissionRule rule = new PermissionRule(PermissionGroup.getGroup(world, tag.func_74779_i("group")), tag.func_74767_n("allow"));
                if (rule.group == null) continue;
                this.rules.add(rule);
                continue;
            }
            this.rules.add(null);
        }
        if (this.rules.size() < 1) {
            this.rules.add(null);
        }
        if (newGroup) {
            data.func_76185_a();
        }
    }

    public String getId() {
        return "G_" + this.name;
    }

    private static boolean canSendCommands(MinecraftServer server, String playerName) {
        if (isOpped.containsKey(playerName)) {
            return isOpped.get(playerName);
        }
        ServerConfigurationManager serverConfig = server.func_71203_ab();
        if (serverConfig.func_152603_m().func_152700_a(playerName) != null) {
            isOpped.put(playerName, true);
            return true;
        }
        isOpped.put(playerName, server.func_71264_H() && server.field_71305_c[0].func_72912_H().func_76086_u() && server.func_71214_G().equalsIgnoreCase(playerName));
        return isOpped.get(playerName);
    }

    public static boolean isOp(PermissionPlayer player) {
        boolean b;
        boolean bl = b = FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && PermissionGroup.canSendCommands(MinecraftServer.func_71276_C(), player.name);
        if (!b && Common.allowOpFunctionsInSinglePlayer) {
            return MinecraftServer.func_71276_C().func_71203_ab().func_72365_p().func_71264_H() && MinecraftServer.func_71276_C().func_71203_ab().func_72365_p().func_71214_G().equalsIgnoreCase(player.name);
        }
        return b;
    }

    public boolean isModerator(PermissionPlayer player) {
        if (FMLCommonHandler.instance().getEffectiveSide() != Side.SERVER) {
            return false;
        }
        PermissionGroup moderators = PermissionGroup.getGroup(this.world, ModeratorPermissionGroup.id);
        moderators.subscribedGroups.add(this);
        return moderators.canUse(player);
    }

    public boolean isOwner(PermissionPlayer player) {
        if (this.deleted) {
            return false;
        }
        if (this.isModerator(player)) {
            return true;
        }
        try {
            if (this.owner != null) {
                this.owner.subscribedGroups.add(this);
                if (this.owner.isMember(player, new HashMap<PermissionGroup, Boolean>(), true, false)) {
                    return true;
                }
            }
        }
        catch (InvalidPermissionException invalidPermissionException) {
            // empty catch block
        }
        return false;
    }

    public boolean canUse(PermissionPlayer player) {
        try {
            return this.isMember(player, new HashMap<PermissionGroup, Boolean>(), true, false);
        }
        catch (InvalidPermissionException ignored) {
            return false;
        }
    }

    public int getAccessLevel(PermissionPlayer player) {
        if (this.accessCache.containsKey(player)) {
            return this.accessCache.get(player);
        }
        if (this.isOwner(player)) {
            this.accessCache.put(player, 4);
            return 4;
        }
        if (this.canEdit(player)) {
            this.accessCache.put(player, 3);
            return 3;
        }
        if (this.canUse(player)) {
            this.accessCache.put(player, 2);
            return 2;
        }
        if (this.canView(player, false)) {
            this.accessCache.put(player, 1);
            return 1;
        }
        this.accessCache.put(player, 0);
        return 0;
    }

    public boolean canEdit(PermissionPlayer player) {
        try {
            return this.isMember(player, new HashMap<PermissionGroup, Boolean>(), true, true);
        }
        catch (InvalidPermissionException ignored) {
            return false;
        }
    }

    public final int getEditPrivilige(PermissionPlayer player) {
        if (this.deleted) {
            return -1;
        }
        HashMap<PermissionGroup, Boolean> map = new HashMap<PermissionGroup, Boolean>();
        map.put(this, this.canUse(player));
        if (map.containsKey(this) && !((Boolean)map.get(this)).booleanValue()) {
            return -1;
        }
        try {
            if (this.isModerator(player)) {
                return 0;
            }
            if (this.owner != null) {
                this.owner.subscribedGroups.add(this);
                if (this.owner.isMember(player, map, true, false)) {
                    return 0;
                }
            }
        }
        catch (InvalidPermissionException e) {
            return this.rules.size();
        }
        int ruleNum = 0;
        for (PermissionRule rule : this.rules) {
            ++ruleNum;
            if (rule == null) break;
            try {
                rule.group.subscribedGroups.add(this);
                if (!rule.group.isMember(player, map, true, false)) continue;
                return rule.isAllowed ? ruleNum : -1;
            }
            catch (InvalidPermissionException e) {
                return this.rules.size();
            }
        }
        if (this.parent != null && this.parent.canEdit(player)) {
            return ruleNum;
        }
        return -1;
    }

    protected boolean isMember(PermissionPlayer player, HashMap<PermissionGroup, Boolean> map, boolean includeOwner, boolean onlyAdmins) throws InvalidPermissionException {
        if (this.deleted) {
            return false;
        }
        if (map.containsKey(this)) {
            return map.get(this);
        }
        boolean result = true;
        try {
            result = this.tryIsMember(player, map, includeOwner, onlyAdmins, false);
        }
        catch (InvalidPermissionException invalidPermissionException) {
            // empty catch block
        }
        if (result && !(result = this.tryIsMember(player, map, includeOwner, onlyAdmins, true))) {
            throw new InvalidPermissionException("Permission group " + this.name + " is inconsistent for player " + player.name);
        }
        map.remove(this);
        return result;
    }

    private boolean tryIsMember(PermissionPlayer player, HashMap<PermissionGroup, Boolean> map, boolean includeOwner, boolean onlyAdmins, boolean state) throws InvalidPermissionException {
        map.put(this, state);
        if (includeOwner) {
            if (this.isModerator(player)) {
                return true;
            }
            if (this.owner != null) {
                try {
                    this.owner.subscribedGroups.add(this);
                    if (this.owner.isMember(player, map, includeOwner, false)) {
                        return true;
                    }
                }
                catch (InvalidPermissionException invalidPermissionException) {
                    // empty catch block
                }
            }
        }
        for (PermissionRule rule : this.rules) {
            if (rule == null) {
                if (!onlyAdmins) continue;
                break;
            }
            rule.group.subscribedGroups.add(this);
            if (!rule.group.isMember(player, map, includeOwner && rule.isAllowed, false)) continue;
            return rule.isAllowed;
        }
        this.parent.subscribedGroups.add(this);
        return this.parent != null && this.parent.isMember(player, map, includeOwner, onlyAdmins);
    }

    public boolean canView(PermissionPlayer player, boolean hasRule) {
        if (this.deleted) {
            return false;
        }
        if (this.visibility == 0) {
            return true;
        }
        if (this.visibility == 1) {
            return hasRule || this.canUse(player);
        }
        if (this.visibility == 2) {
            return this.isOwner(player);
        }
        return false;
    }

    public NBTTagCompound getTagCompound() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("id", this.getId());
        tag.func_74778_a("name", this.name);
        if (this.owner != null) {
            tag.func_74778_a("owner", this.owner.getId());
        }
        if (this.parent != null) {
            tag.func_74778_a("parent", this.parent.getId());
        }
        tag.func_74768_a("visibility", this.visibility);
        NBTTagList tagList = new NBTTagList();
        for (PermissionRule rule : this.rules) {
            NBTTagCompound ruleTag = new NBTTagCompound();
            if (rule != null) {
                ruleTag.func_74757_a("allow", rule.isAllowed);
                ruleTag.func_74778_a("group", rule.group.getId());
            }
            tagList.func_74742_a((NBTBase)ruleTag);
        }
        tag.func_74782_a("rules", (NBTBase)tagList);
        return tag;
    }

    public void markDirty(World world) {
        PermissionData.get(world);
        for (PermissionGroup group : PermissionData.groups.values()) {
            if (group == null || group.deleted) continue;
            group.accessCache.clear();
        }
        PermissionData.get(world).setPermission(this);
        this.updateSubscribedGroups(world);
    }

    public void deleteGroup(World world) {
        if (this.getId().startsWith("G_")) {
            PermissionData.get(world).deletePermission(this);
            this.deleted = true;
            HashSet<PermissionGroup> groups = new HashSet<PermissionGroup>(this.subscribedGroups);
            for (PermissionGroup group : groups) {
                if (group == null || group.deleted) continue;
                if (group.owner == this) {
                    group.owner = PermissionGroup.getGroup(world, SpecialPermissionGroup.allowId);
                }
                if (group.parent == this) {
                    group.parent = PermissionGroup.getGroup(world, SpecialPermissionGroup.denyId);
                }
                Iterator<PermissionRule> iterator = group.rules.iterator();
                while (iterator.hasNext()) {
                    PermissionRule rule = iterator.next();
                    if (rule == null || rule.group != this) continue;
                    iterator.remove();
                }
                group.markDirty(world);
            }
            this.updateSubscribedGroups(world);
        } else if (this.getId().startsWith("I_")) {
            if (this.deleted) {
                return;
            }
            this.deleted = true;
            UniqueItemData.get(world).deleteItem(world, this.name);
            PermissionData.get(world).deletePermission(this);
        }
    }

    public void updateSubscribedGroups(World world) {
        if (world.field_72995_K) {
            return;
        }
        HashSet<PermissionGroup> visited = new HashSet<PermissionGroup>();
        HashSet<PermissionGroup> groups = new HashSet<PermissionGroup>(this.subscribedGroups);
        boolean newStuff = true;
        block0: while (newStuff) {
            newStuff = false;
            for (PermissionGroup permissionGroup : groups) {
                if (permissionGroup != null && permissionGroup.deleted || visited.contains(permissionGroup)) continue;
                groups.addAll(permissionGroup.subscribedGroups);
                visited.add(permissionGroup);
                newStuff = true;
                continue block0;
            }
        }
        HashSet<String> uuids = new HashSet<String>();
        if (this instanceof ItemPermission) {
            uuids.add(this.name);
        }
        for (PermissionGroup group : groups) {
            if (!(group instanceof ItemPermission)) continue;
            uuids.add(group.name);
        }
        UniqueItemData uniqueItemData = UniqueItemData.get(world);
        HashMap toUpdate = new HashMap();
        for (String uuid : uuids) {
            if (!uniqueItemData.subscribedPlayers.containsKey(uuid) || !PermissionGroup.hasGroup(world, "I_" + uuid)) continue;
            WeakHashMap<EntityPlayer, Integer> subscribers = uniqueItemData.subscribedPlayers.get(uuid);
            for (EntityPlayer player : subscribers.keySet()) {
                if (player == null) continue;
                if (!toUpdate.containsKey(player)) {
                    toUpdate.put(player, new ArrayList());
                }
                ((ArrayList)toUpdate.get(player)).add(uuid);
            }
        }
        for (EntityPlayer player : toUpdate.keySet()) {
            ArrayList<NBTTagCompound> tags = new ArrayList<NBTTagCompound>();
            for (String uuid : (ArrayList)toUpdate.get(player)) {
                uniqueItemData.subscribePlayer(player, uuid, tags, false);
            }
            Common.channel.sendToPlayer(player, new PacketHandler.DataUpdate(tags));
        }
    }

    public class InvalidPermissionException
    extends Exception {
        public InvalidPermissionException(String message) {
            super(message);
        }
    }

    public static class ModeratorPermissionGroup
    extends SpecialPermissionGroup {
        public static String id = "S_OPS";
        private HashMap<PermissionPlayer, Boolean> moderators = new HashMap();

        private ModeratorPermissionGroup(PermissionData data, World world) {
            super(data, world, "Moderators");
            NBTTagCompound tag = data.getPermission(this);
            NBTTagList tagList = tag.func_150295_c("disabled", 8);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                this.moderators.put((PermissionPlayer)ModeratorPermissionGroup.getGroup(world, tagList.func_150307_f(i)), false);
            }
        }

        @Override
        public NBTTagCompound getTagCompound() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("id", this.getId());
            tag.func_74778_a("name", this.name);
            NBTTagList tagList = new NBTTagList();
            for (PermissionPlayer player : this.moderators.keySet()) {
                if (this.moderators.get(player).booleanValue()) continue;
                tagList.func_74742_a((NBTBase)new NBTTagString(player.getId()));
            }
            tag.func_74782_a("disabled", (NBTBase)tagList);
            return tag;
        }

        @Override
        public String getId() {
            return id;
        }

        @Override
        protected boolean isMember(PermissionPlayer player, HashMap<PermissionGroup, Boolean> map, boolean includeOwner, boolean onlyAdmins) throws InvalidPermissionException {
            if (!ModeratorPermissionGroup.isOp(player)) {
                return false;
            }
            if (!this.moderators.containsKey(player)) {
                return true;
            }
            return this.moderators.get(player);
        }

        public void setModerationStatus(World world, PermissionPlayer player, boolean enabled) {
            if (this.moderators.containsKey(player) && this.moderators.get(player) == enabled) {
                return;
            }
            this.moderators.put(player, enabled);
            this.markDirty(world);
        }
    }

    public static class SpecialPermissionGroup
    extends PermissionGroup {
        public static String allowName = "all";
        public static String allowId = "S_ALL";
        public static String denyName = "none";
        public static String denyId = "S_NONE";
        private boolean allow;

        protected SpecialPermissionGroup(PermissionData data, World world, String name) {
            super(data, world, name);
            this.allow = false;
        }

        private SpecialPermissionGroup(PermissionData data, World world, boolean allow) {
            super(data, world, allow ? allowName : denyName);
            this.allow = allow;
        }

        @Override
        public String getId() {
            return this.name.equals(allowName) ? allowId : denyId;
        }

        @Override
        protected boolean isMember(PermissionPlayer player, HashMap<PermissionGroup, Boolean> map, boolean includeOwner, boolean onlyAdmins) throws InvalidPermissionException {
            return this.allow;
        }
    }
}

