/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common.gui;

import brad16840.common.Common;
import brad16840.common.ContainerStack;
import brad16840.common.PacketHandler;
import brad16840.common.StackableContainer;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RestorerContainer
extends StackableContainer.SimpleContainer
implements IInventory {
    private String typeId;
    public int selectedStack = -1;
    private int scrollPos = 0;
    private boolean navigating;
    private ArrayList<ItemStack> stacks;
    private StackableContainer.ContainerButton acceptButton;
    private StackableContainer.ContainerButton cancelButton;
    private ScrollButton leftButton;
    private ScrollButton rightButton;
    private static final ResourceLocation texture = new ResourceLocation("backpacks16840", "textures/gui/restorer.png");
    private RestoreSlot[] slots;
    private int playerInventorySlot;

    public RestorerContainer(String typeId, int playerInventorySlot) {
        super(176, 54);
        this.typeId = typeId;
        this.stacks = new ArrayList();
        this.slots = new RestoreSlot[6];
        this.navigating = false;
        this.playerInventorySlot = playerInventorySlot;
    }

    @Override
    public boolean initContainer(EntityPlayer player) {
        this.stacks.clear();
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        try {
            for (String uuid : data.items.keySet()) {
                NBTTagCompound tag;
                if (!data.hasRequiredPermission(player, uuid, 4) || (tag = data.getItemData(player, uuid)) == null || !tag.func_74764_b("inventory") || !tag.func_74775_l("inventory").func_74764_b("container-type")) continue;
                String type = tag.func_74775_l("inventory").func_74779_i("container-type");
                if (this.typeId != null && !type.equals(this.typeId)) continue;
                UniqueItem.ContainerItem itemType = UniqueItem.getContainerType(type);
                ItemStack stack = new ItemStack((Item)itemType, 1);
                if (tag.func_74764_b("custom-name")) {
                    stack.func_151001_c(tag.func_74779_i("custom-name"));
                }
                if (tag.func_74764_b("color")) {
                    stack.func_77964_b(tag.func_74762_e("color"));
                }
                if ((tag = stack.func_77978_p()) == null) {
                    tag = new NBTTagCompound();
                    stack.func_77982_d(tag);
                }
                tag.func_74778_a("stackId", uuid);
                this.stacks.add(stack);
            }
        }
        catch (ConcurrentModificationException e) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            this.slots[i] = new RestoreSlot(player, (IInventory)this, i, 35 + i * 18, 8);
            this.container.addSlotToContainer(this, ContainerStack.ContainerSection.ENCHANTMENT, this.slots[i]);
        }
        return true;
    }

    public void specialButton(EntityPlayer player, int button, String uuid) {
        if (button == 0 && !uuid.equals("none")) {
            if (this.container.chainOrder.size() == 0 || this.container.chainOrder.get(this.container.chainOrder.size() - 1) == null) {
                while (this.container.chainOrder.size() > 0 && this.container.chainOrder.get(this.container.chainOrder.size() - 1) != null) {
                    this.container.closeContainer(player);
                }
                ItemStack restorerStack = player.field_71071_by.func_70301_a(this.playerInventorySlot);
                if (restorerStack != null && restorerStack.func_77973_b() instanceof UniqueItem.ItemRestorer) {
                    UniqueItemData data = UniqueItemData.get(player.field_70170_p);
                    NBTTagCompound tag = data.getItemData(player, uuid);
                    if (tag != null && tag.func_74764_b("inventory") && tag.func_74775_l("inventory").func_74764_b("container-type")) {
                        String type = tag.func_74775_l("inventory").func_74779_i("container-type");
                        UniqueItem.ContainerItem itemType = UniqueItem.getContainerType(type);
                        ItemStack stack = new ItemStack((Item)itemType, 1);
                        if (tag.func_74764_b("custom-name")) {
                            stack.func_151001_c(tag.func_74779_i("custom-name"));
                        }
                        if (tag.func_74764_b("color")) {
                            stack.func_77964_b(tag.func_74762_e("color"));
                        }
                        if ((tag = stack.func_77978_p()) == null) {
                            tag = new NBTTagCompound();
                            stack.func_77982_d(tag);
                        }
                        player.field_71071_by.func_70299_a(this.playerInventorySlot, stack);
                        UniqueItem.setIdentifier(player, stack, uuid);
                        player.field_71071_by.func_70296_d();
                    }
                } else {
                    new Translatable("problem.restorer404", new Object[0]).log(player);
                }
            }
            this.container.closeContainer(player);
        } else if (button == 1) {
            while (this.container.chainOrder.size() > 0 && this.container.chainOrder.get(this.container.chainOrder.size() - 1) != null) {
                this.container.closeContainer(player);
            }
            this.container.closeContainer(player);
        }
        this.updateButtons();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initButtons() {
        this.leftButton = new ScrollButton(1, 14, 7, 18, 18, this.guiWidth, 0);
        this.gui.addButton(this.leftButton);
        this.rightButton = new ScrollButton(2, 144, 7, 18, 18, this.guiWidth, 18);
        this.gui.addButton(this.rightButton);
        this.acceptButton = new StackableContainer.ContainerButton(this, 0, 14, 27, 73, 20, new Translatable("button.accept", new Object[0]).translate(), new ContainerStack.Callback(){

            @Override
            public void call() {
                String uuid = UniqueItem.getIdentifier((ItemStack)RestorerContainer.this.stacks.get(RestorerContainer.this.selectedStack));
                Common.channel.sendToServer(new PacketHandler.RestorerButtonClicked(0, uuid));
                RestorerContainer.this.specialButton((EntityPlayer)Minecraft.func_71410_x().field_71439_g, 0, uuid);
            }
        });
        this.gui.addButton(this.acceptButton);
        this.cancelButton = new StackableContainer.ContainerButton(this, 0, 90, 27, 73, 20, new Translatable("button.cancel", new Object[0]).translate(), new ContainerStack.Callback(){

            @Override
            public void call() {
                Common.channel.sendToServer(new PacketHandler.RestorerButtonClicked(1, "none"));
                RestorerContainer.this.specialButton((EntityPlayer)Minecraft.func_71410_x().field_71439_g, 1, "none");
            }
        });
        this.gui.addButton(this.cancelButton);
        this.updateButtons();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void actionPerformed(StackableContainer.ContainerButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == 1) {
                --this.scrollPos;
                this.updateButtons();
            } else if (button.field_146127_k == 2) {
                ++this.scrollPos;
                this.updateButtons();
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForeground(int x, int y) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.bindTexture(texture);
        this.gui.drawTexture(this, 0, 0, this.guiWidth, this.guiHeight, 0, 0);
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (i + this.scrollPos != this.selectedStack) continue;
            this.gui.drawRectangle(this, 35 + 18 * i, 8, 35 + 18 * i + 16, 24, this.navigating ? -8850318 : -14751714);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseDown(int x, int y, int button) {
        boolean clicked;
        boolean bl = clicked = button == 0 || button == 1 || button == Minecraft.func_71410_x().field_71474_y.field_74322_I.func_151463_i() + 100;
        if (y >= 8 && y < 26 && x >= 34 && x < 142) {
            int sel = (x - 34) / 18 + this.scrollPos;
            if (sel < this.stacks.size()) {
                this.selectedStack = sel;
                RestorerContainer.createView((EntityPlayer)Minecraft.func_71410_x().field_71439_g, this.typeId, UniqueItem.getIdentifier(this.stacks.get(this.selectedStack)), false, true, true, this.playerInventorySlot);
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseUp(int x, int y, int button) {
        return false;
    }

    @Override
    public boolean customRightClick(EntityPlayer player, int slot, boolean holdingShift) {
        return false;
    }

    public int func_70302_i_() {
        return 6;
    }

    public ItemStack func_70301_a(int i) {
        if (this.scrollPos + i >= this.stacks.size()) {
            return null;
        }
        return this.stacks.get(this.scrollPos + i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return null;
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
    }

    public String func_145825_b() {
        return "restorer";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public static void createView(EntityPlayer player, String type, String selectedId, boolean addRestorer, boolean clearExistingViews, boolean alreadyOpened, int playerInventorySlot) {
        UniqueItem.ContainerItem itemType = UniqueItem.getContainerType(type);
        if (!(itemType instanceof UniqueItem.ViewableItem)) {
            if (!player.field_70170_p.field_72995_K) {
                ContainerStack.closeScreen(player);
            }
            new Translatable("problem.viewitemunviewable", new Object[0]).log(player);
            return;
        }
        if (!(player.field_71070_bA instanceof ContainerStack)) {
            if (!player.field_70170_p.field_72995_K) {
                ContainerStack.closeScreen(player);
            }
            return;
        }
        StackableContainer c = ((UniqueItem.ViewableItem)((Object)itemType)).viewItem(player, selectedId, playerInventorySlot);
        if (c == null) {
            if (!player.field_70170_p.field_72995_K) {
                ContainerStack.closeScreen(player);
            }
            return;
        }
        ContainerStack container = (ContainerStack)player.field_71070_bA;
        if (addRestorer) {
            container.addContainers(player, new StackableContainer[]{c, new RestorerContainer(type, playerInventorySlot)});
        } else if (clearExistingViews) {
            while (container.chainOrder.size() > 0 && container.chainOrder.get(container.chainOrder.size() - 1) != null) {
                container.closeContainer(player);
            }
            container.replaceContainer(player, 0, c);
            if (container.stacks.length > 1 && container.getContainer(1) instanceof RestorerContainer) {
                ((RestorerContainer)container.getContainer(1)).updateButtons();
            }
        } else {
            container.addContainer(player, 0, c);
            if (container.stacks.length > 1 && container.getContainer(1) instanceof RestorerContainer) {
                ((RestorerContainer)container.getContainer(1)).updateButtons();
            }
        }
        if (alreadyOpened && player.field_70170_p.field_72995_K) {
            Common.channel.sendToServer(new PacketHandler.CreateRestorerView(type, selectedId, playerInventorySlot, addRestorer, clearExistingViews, true));
        }
    }

    private void updateButtons() {
        if (this.acceptButton == null) {
            return;
        }
        boolean bl = this.navigating = this.container.chainOrder.size() > 0 && this.container.chainOrder.get(this.container.chainOrder.size() - 1) != null;
        if (!this.navigating) {
            this.acceptButton.field_146124_l = this.selectedStack >= 0 && this.selectedStack < this.stacks.size();
            this.acceptButton.field_146126_j = new Translatable("button.accept", new Object[0]).translate();
        } else {
            this.acceptButton.field_146124_l = true;
            this.acceptButton.field_146126_j = new Translatable("button.back", new Object[0]).translate();
        }
        this.leftButton.field_146124_l = this.scrollPos > 0;
        this.rightButton.field_146124_l = this.scrollPos + 6 < this.stacks.size();
    }

    @SideOnly(value=Side.CLIENT)
    private class ScrollButton
    extends StackableContainer.ContainerButton {
        private final int offsetX;
        private final int offsetY;

        public ScrollButton(int id, int x, int y, int w, int h, int offsetX, int offsetY) {
            super(RestorerContainer.this, id, x, y, w, h, "");
            this.offsetX = offsetX;
            this.offsetY = offsetY;
        }

        public void func_146112_a(Minecraft par1Minecraft, int par2, int par3) {
            if (this.field_146125_m) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                par1Minecraft.field_71446_o.func_110577_a(texture);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, this.offsetX + this.func_146114_a(this.func_146116_c(par1Minecraft, par2, par3)) * this.field_146120_f, this.offsetY, this.field_146120_f, this.field_146121_g);
            }
        }
    }

    private class RestoreSlot
    extends StackableContainer.ContainerSlot {
        public RestoreSlot(EntityPlayer player, IInventory inventory, int par2, int par3, int par4) {
            super(RestorerContainer.this, player, inventory, par2, par3, par4);
        }

        @Override
        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        @Override
        public boolean func_82869_a(EntityPlayer player) {
            return false;
        }
    }
}

