/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common;

import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class UniqueItemInventory
implements IInventory {
    protected String uuid;
    public World world;
    public int width;
    public int height;
    public ItemStack[] items;
    public int transactionId;
    public UniqueItem.ContainerItem itemType;
    public static HashMap<String, WeakReference<UniqueItemInventory>> openServerInventories = new HashMap();
    public static HashMap<String, WeakReference<UniqueItemInventory>> openClientInventories = new HashMap();

    public static UniqueItemInventory retrieveInventory(String uuid, boolean onServer) {
        HashMap<String, WeakReference<UniqueItemInventory>> openInventories;
        HashMap<String, WeakReference<UniqueItemInventory>> hashMap = openInventories = onServer ? openServerInventories : openClientInventories;
        if (openInventories.containsKey(uuid)) {
            WeakReference<UniqueItemInventory> ref = openInventories.get(uuid);
            if (ref == null || ref.get() == null) {
                openInventories.remove(uuid);
            } else {
                return (UniqueItemInventory)ref.get();
            }
        }
        return null;
    }

    private static boolean canPlayerUseInventory(EntityPlayer player, String uuid) {
        if (player == null) {
            return true;
        }
        return UniqueItemData.get(player.field_70170_p).hasRequiredPermission(player, uuid, 1);
    }

    public static UniqueItemInventory getInventory(EntityPlayer player, String uuid) {
        return UniqueItemInventory.getInventory(player, player.field_70170_p, uuid);
    }

    public static UniqueItemInventory getInventory(EntityPlayer player, World world, String uuid) {
        UniqueItemData data;
        NBTTagCompound tag;
        HashMap<String, WeakReference<UniqueItemInventory>> openInventories;
        if (!UniqueItemInventory.canPlayerUseInventory(player, uuid)) {
            return null;
        }
        HashMap<String, WeakReference<UniqueItemInventory>> hashMap = openInventories = !world.field_72995_K ? openServerInventories : openClientInventories;
        if (openInventories.containsKey(uuid)) {
            WeakReference<UniqueItemInventory> ref = openInventories.get(uuid);
            if (ref == null || ref.get() == null) {
                openInventories.remove(uuid);
            } else {
                UniqueItemInventory inventory = (UniqueItemInventory)ref.get();
                if (inventory != null) {
                    NBTTagCompound tag2;
                    if (inventory.world != world) {
                        inventory.world = world;
                    }
                    if ((tag2 = inventory.getCompoundTag(world, "inventory")) != null) {
                        if (inventory.transactionId < tag2.func_74762_e("save-count") && (inventory.transactionId >= 10 || tag2.func_74762_e("save-count") <= 2000000)) {
                            inventory.refreshInventory();
                        }
                        return inventory;
                    }
                }
            }
        }
        if ((tag = (data = UniqueItemData.get(world)).getItemData(uuid, false)) == null || !tag.func_74764_b("inventory") || !tag.func_74775_l("inventory").func_74764_b("container-type")) {
            return null;
        }
        UniqueItem.ContainerItem itemType = UniqueItem.getContainerType(tag.func_74775_l("inventory").func_74779_i("container-type"));
        if (itemType == null) {
            return null;
        }
        UniqueItemInventory inventory = null;
        try {
            inventory = new UniqueItemInventory(itemType, world, uuid);
        }
        catch (RuntimeException e) {
            inventory = null;
        }
        if (inventory != null) {
            openInventories.put(uuid, new WeakReference<UniqueItemInventory>(inventory));
        }
        return inventory;
    }

    public static UniqueItemInventory createInventory(Item itemType, EntityPlayer player, String uuid) {
        HashMap<String, WeakReference<UniqueItemInventory>> openInventories;
        if (!UniqueItemInventory.canPlayerUseInventory(player, uuid)) {
            return null;
        }
        HashMap<String, WeakReference<UniqueItemInventory>> hashMap = openInventories = !player.field_70170_p.field_72995_K ? openServerInventories : openClientInventories;
        if (openInventories.containsKey(uuid)) {
            WeakReference<UniqueItemInventory> ref = openInventories.get(uuid);
            if (ref == null || ref.get() == null) {
                openInventories.remove(uuid);
            } else {
                UniqueItemInventory inventory = (UniqueItemInventory)ref.get();
                NBTTagCompound tag = inventory.getCompoundTag(player.field_70170_p, "inventory");
                if (tag != null) {
                    if (inventory.transactionId < tag.func_74762_e("save-count") && (inventory.transactionId >= 10 || tag.func_74762_e("save-count") <= 2000000)) {
                        inventory.refreshInventory();
                    }
                    return inventory;
                }
            }
        }
        if (!(itemType instanceof UniqueItem.ContainerItem)) {
            return null;
        }
        UniqueItemInventory inventory = null;
        try {
            inventory = new UniqueItemInventory((UniqueItem.ContainerItem)itemType, player.field_70170_p, uuid);
        }
        catch (RuntimeException e) {
            inventory = null;
        }
        if (inventory != null) {
            openInventories.put(uuid, new WeakReference<UniqueItemInventory>(inventory));
        }
        return inventory;
    }

    protected UniqueItemInventory(UniqueItem.ContainerItem type, World world, String uuid) {
        this.itemType = type;
        this.uuid = uuid;
        this.world = world;
        if (uuid.equals("none") || type == null) {
            throw new RuntimeException("Attempted to open the inventory of a non-unique item");
        }
        UniqueItemData data = UniqueItemData.get(world);
        NBTTagCompound tag = data.getItemData(uuid, false);
        if (tag == null) {
            throw new RuntimeException("You don't have permission to open that item's inventory");
        }
        if (!tag.func_74764_b("inventory")) {
            tag.func_74782_a("inventory", (NBTBase)new NBTTagCompound());
            UniqueItemData.get(world).markItemDirty(uuid);
        }
        if ((tag = this.getCompoundTag(world, "inventory")) == null) {
            throw new RuntimeException("You don't have permission to open that item's inventory");
        }
        this.width = type.getSlotWidth(world, tag, uuid);
        this.height = type.getSlotHeight(world, tag, uuid);
        this.items = new ItemStack[this.width * this.height];
        this.transactionId = -1;
        this.refreshInventory();
    }

    public NBTTagCompound getCompoundTag(World world, String key) {
        UniqueItemData data = UniqueItemData.get(world);
        NBTTagCompound tag = data.getItemData(this.uuid, false);
        if (tag == null) {
            return null;
        }
        if (key == null) {
            return tag;
        }
        if (!tag.func_74764_b(key)) {
            tag.func_74782_a(key, (NBTBase)new NBTTagCompound());
            UniqueItemData.get(world).markItemDirty(this.uuid);
        }
        return tag.func_74775_l(key);
    }

    public boolean refreshInventory() {
        NBTTagCompound tag = this.getCompoundTag(this.world, "inventory");
        if (tag == null) {
            return false;
        }
        if (this.transactionId >= tag.func_74762_e("save-count") || this.transactionId > 0 && this.transactionId < 10 && tag.func_74762_e("save-count") > 2000000) {
            return true;
        }
        if (this.width != this.itemType.getSlotWidth(this.world, tag, this.uuid) || this.height != this.itemType.getSlotHeight(this.world, tag, this.uuid)) {
            this.width = this.itemType.getSlotWidth(this.world, tag, this.uuid);
            this.height = this.itemType.getSlotHeight(this.world, tag, this.uuid);
            this.items = new ItemStack[this.width * this.height];
        }
        this.transactionId = tag.func_74762_e("save-count");
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                int i = y * this.width + x;
                this.items[i] = tag.func_74764_b("x" + x + "y" + y) ? UniqueItem.loadItemStackFromNBT(tag.func_74775_l("x" + x + "y" + y)) : null;
            }
        }
        return true;
    }

    public boolean saveInventory() {
        NBTTagCompound tag = this.getCompoundTag(this.world, "inventory");
        if (tag == null) {
            return false;
        }
        if (this.transactionId < 0 && tag.func_74762_e("save-count") > 0) {
            this.refreshInventory();
        }
        ++this.transactionId;
        if (this.transactionId > 2000010) {
            this.transactionId = 1;
        }
        tag.func_74768_a("save-count", this.transactionId);
        tag.func_74778_a("container-type", this.itemType.getContainerItemType());
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                int i = y * this.width + x;
                if (this.items[i] != null) {
                    if (this.items[i].func_77973_b() instanceof UniqueItem.UpdatableItem) {
                        ((UniqueItem.UpdatableItem)this.items[i].func_77973_b()).updateItemStack(null, this.items[i]);
                    }
                    tag.func_74782_a("x" + x + "y" + y, (NBTBase)UniqueItem.writeItemStackToNBT(this.items[i], null));
                    continue;
                }
                tag.func_82580_o("x" + x + "y" + y);
            }
        }
        UniqueItemData.get(this.world).markItemDirty(this.uuid);
        return true;
    }

    public int func_70302_i_() {
        return this.width * this.height;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot < 0 || slot >= this.width * this.height) {
            return null;
        }
        return this.items[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amount);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot < 0 || slot >= this.width * this.height) {
            return;
        }
        this.items[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "UniqueItem-Inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return !UniqueItem.getIdentifier(stack).equals(this.uuid);
    }

    public String getIdentifier() {
        return this.uuid;
    }
}

