/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common;

import brad16840.common.Common;
import brad16840.common.ContainerStack;
import brad16840.common.PacketHandler;
import brad16840.common.StackableContainer;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UnknownItem;
import brad16840.common.gui.NBTEditor;
import brad16840.common.gui.PlayerContainer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ContainerStackGui
extends GuiContainer
implements ContainerStack.ContainerStackListener,
GuiYesNoCallback {
    public ContainerStack stack;
    private int draggingStack = 0;
    private int scrollX = 0;
    private int scrollY = 0;
    private ArrayList<StackableContainer.ContainerTextField> textFields = new ArrayList();
    private ScrollButton[] scrollButtons;
    public static boolean tmiInstalled = false;
    public static String ellipsis = new Translatable("gui.ellipsis", new Object[0]).translate();
    public static int scrollSize = 20;
    public ItemStack customTooltipItem = null;
    private long lastCloseTime = 0L;
    public boolean overrideFailed = false;
    public boolean unoverrideFailed = false;
    private boolean fromInit = false;
    private boolean beenInitialized = false;
    private boolean worldAndResolutionSet = false;
    public boolean needsConfirming = false;
    public ArrayList<String> tooltips = new ArrayList();
    protected GuiButton field_146290_a = null;
    public static ArrayList<CustomMouseClickHandler> customMouseClickHandlers = new ArrayList();

    public static ContainerStackGui create(EntityPlayer player, StackableContainer[] initialContainers) {
        ContainerStackGui gui = new ContainerStackGui(player, initialContainers, false);
        if (gui.stack.hasClosed) {
            return null;
        }
        return gui;
    }

    public static ContainerStackGui create(EntityPlayer player, StackableContainer[] initialContainers, boolean fromChest) {
        ContainerStackGui gui = new ContainerStackGui(player, initialContainers, fromChest);
        if (gui.stack.hasClosed) {
            return null;
        }
        return gui;
    }

    private ContainerStackGui(EntityPlayer player, StackableContainer[] initialContainers, boolean fromChest) {
        super((Container)new ContainerStack(player, initialContainers, fromChest));
        this.stack = (ContainerStack)this.field_147002_h;
        this.scrollButtons = new ScrollButton[4];
        this.scrollButtons[0] = new ScrollButton(0, 0, 0, 21, 21, 193, 172);
        this.scrollButtons[1] = new ScrollButton(1, 0, 0, 21, 21, 193, 193);
        this.scrollButtons[2] = new ScrollButton(2, 0, 0, 21, 21, 193, 214);
        this.scrollButtons[3] = new ScrollButton(3, 0, 0, 21, 21, 193, 235);
        this.stack.listener = this;
        this.worldAndResolutionSet = false;
        if (this.stack.hasClosed) {
            this.stack.func_75134_a(player);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (!this.stack.hasContainers((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            return;
        }
        this.fromInit = true;
        this.updateContainers();
    }

    public Text text(StackableContainer container, String text) {
        return new Text(container, text, this.field_146289_q);
    }

    public void drawSlotInventory(StackableContainer container, Slot slot) {
        slot.field_75223_e += this.stack.getOffsetX(container) - this.scrollX;
        slot.field_75221_f += this.stack.getOffsetY(container) - this.scrollY;
        if (slot != null && slot.func_75216_d()) {
            this.drawItemStack(slot.func_75211_c(), slot.field_75223_e, slot.field_75221_f, 100.0f, null);
        }
        slot.field_75223_e -= this.stack.getOffsetX(container) - this.scrollX;
        slot.field_75221_f -= this.stack.getOffsetY(container) - this.scrollY;
    }

    public void drawItemStack(ItemStack stack, int x, int y) {
        this.drawItemStack(stack, x, y, 100.0f, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawItemStack(ItemStack stack, int x, int y, float zLevel, String overrideCount) {
        float oldLevel = this.field_73735_i;
        this.field_73735_i = zLevel;
        ContainerStackGui.field_146296_j.field_77023_b = zLevel;
        FontRenderer font = null;
        try {
            if (stack != null) {
                if (stack.func_77973_b() == null) {
                    stack = new ItemStack((Item)Common.unknownItem);
                }
                font = stack.func_77973_b().getFontRenderer(stack);
            }
            if (font == null) {
                font = this.field_146289_q;
            }
        }
        catch (Throwable e) {
            this.field_73735_i = oldLevel;
            ContainerStackGui.field_146296_j.field_77023_b = 0.0f;
            return;
        }
        try {
            List ores;
            GL11.glPushMatrix();
            GL11.glEnable((int)2929);
            String id = UnknownItem.getItemDescriptor(stack);
            if (id.toLowerCase().startsWith("oredict:") && (ores = OreDictionary.getOres((String)id.substring(8), (boolean)false)).size() > 0) {
                int i = (int)(System.currentTimeMillis() / 1000L % (long)ores.size());
                stack = (ItemStack)ores.get(i);
            }
            field_146296_j.func_82406_b(font, this.field_146297_k.func_110434_K(), stack, x, y);
            field_146296_j.func_94148_a(font, this.field_146297_k.func_110434_K(), stack, x, y, overrideCount);
        }
        catch (Throwable throwable) {
        }
        finally {
            GL11.glPopMatrix();
            this.field_73735_i = oldLevel;
            ContainerStackGui.field_146296_j.field_77023_b = 0.0f;
        }
    }

    @Override
    public void updateContainers() {
        int i;
        this.field_146292_n.clear();
        this.textFields.clear();
        for (i = 0; i < 4; ++i) {
            this.field_146292_n.add(this.scrollButtons[i]);
        }
        for (i = 0; i < this.stack.stacks.length; ++i) {
            this.stack.getContainer(i).initGui(this);
        }
        this.field_146999_f = this.stack.layout.getTotalWidth();
        this.field_147000_g = this.stack.layout.getTotalHeight();
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        if (this.field_147003_i < 0) {
            this.field_147003_i = 0;
        }
        if (this.field_147009_r < 0) {
            this.field_147009_r = 0;
        }
        this.scrollButtons[0].field_146128_h = this.scrollButtons[1].field_146128_h = Math.min(this.field_147003_i + this.field_146999_f + 2, this.field_146294_l - 22);
        this.scrollButtons[2].field_146129_i = this.scrollButtons[3].field_146129_i = this.field_146295_m / 2 - 10;
        this.scrollButtons[0].field_146129_i = 0;
        this.scrollButtons[2].field_146128_h = 0;
        this.scrollButtons[1].field_146129_i = this.field_146295_m - 21;
        this.scrollButtons[3].field_146128_h = this.field_146294_l - 21;
        for (i = 0; i < this.stack.stacks.length; ++i) {
            this.stack.getContainer(i).initButtons();
        }
        if (this.fromInit && this.beenInitialized) {
            this.setScrollPos(this.scrollX, this.scrollY);
        } else {
            this.setScrollPos((this.field_146999_f - this.field_146294_l) / 2, (this.field_147000_g - this.field_146295_m) / 2);
        }
        this.fromInit = false;
        this.beenInitialized = true;
        if (this.worldAndResolutionSet) {
            this.func_73876_c();
        }
    }

    public void func_146280_a(Minecraft mc, int i, int j) {
        super.func_146280_a(mc, i, j);
        this.worldAndResolutionSet = true;
    }

    public void func_73876_c() {
        if (!this.worldAndResolutionSet) {
            return;
        }
        super.func_73876_c();
    }

    public void addButton(StackableContainer.ContainerButton button) {
        button.field_146128_h += this.getOffsetX(button.getOwner());
        button.field_146129_i += this.getOffsetY(button.getOwner());
        this.field_146292_n.add(button);
    }

    public StackableContainer.ContainerTextField addTextField(StackableContainer c, int x, int y, int w, int h) {
        StackableContainer stackableContainer = c;
        stackableContainer.getClass();
        StackableContainer.ContainerTextField textField = new StackableContainer.ContainerTextField(stackableContainer, this.field_146289_q, this.getOffsetX(c) + x, this.getOffsetY(c) + y, w, h);
        this.textFields.add(textField);
        return textField;
    }

    public void func_146281_b() {
        if (this.needsConfirming) {
            return;
        }
        super.func_146281_b();
    }

    public void func_73878_a(boolean par1, int par2) {
        if (par2 >= 0 && par2 < this.stack.stacks.length) {
            this.stack.getContainer(par2).confirmClicked(par1);
        }
        this.func_146281_b();
        this.needsConfirming = false;
        this.field_146297_k.func_147108_a((GuiScreen)this);
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof ScrollButton) {
            if (button.field_146127_k == 0) {
                this.setScrollPos(this.scrollX, this.scrollY - scrollSize);
            } else if (button.field_146127_k == 1) {
                this.setScrollPos(this.scrollX, this.scrollY + scrollSize);
            } else if (button.field_146127_k == 2) {
                this.setScrollPos(this.scrollX - scrollSize, this.scrollY);
            } else if (button.field_146127_k == 3) {
                this.setScrollPos(this.scrollX + scrollSize, this.scrollY);
            }
            return;
        }
        if (!this.stack.hasContainers((EntityPlayer)Minecraft.func_71410_x().field_71439_g) || !(button instanceof StackableContainer.ContainerButton)) {
            return;
        }
        StackableContainer.ContainerButton cbutton = (StackableContainer.ContainerButton)button;
        this.stack.getContainer(cbutton.stackId).actionPerformed(cbutton);
    }

    public void bindTexture(ResourceLocation texture) {
        this.field_146297_k.field_71446_o.func_110577_a(texture);
    }

    public void drawTexture(StackableContainer c, int x, int y, int w, int h, int offsetX, int offsetY) {
        try {
            this.func_73729_b(x + this.getOffsetX(c), y + this.getOffsetY(c), offsetX, offsetY, w, h);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawTexture(StackableContainer c, int x, int y, int w, int h, int offsetX, int offsetY, float zLevel) {
        try {
            float old = this.field_73735_i;
            this.field_73735_i = zLevel;
            this.func_73729_b(x + this.getOffsetX(c), y + this.getOffsetY(c), offsetX, offsetY, w, h);
            this.field_73735_i = old;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawRectangle(StackableContainer c, int x1, int y1, int x2, int y2, int color) {
        ContainerStackGui.func_73734_a((int)(x1 + this.getOffsetX(c)), (int)(y1 + this.getOffsetY(c)), (int)(x2 + this.getOffsetX(c)), (int)(y2 + this.getOffsetY(c)), (int)color);
    }

    public void drawRectangleBorder(StackableContainer c, int x1, int y1, int x2, int y2, int color) {
        this.drawHorizontalLine(c, x1, x2, y1, color);
        this.drawHorizontalLine(c, x1, x2, y2, color);
        this.drawVerticalLine(c, x1, y1, y2, color);
        this.drawVerticalLine(c, x2, y1, y2, color);
    }

    public void drawHorizontalLine(StackableContainer c, int x1, int x2, int y, int color) {
        super.func_73730_a(x1 + this.getOffsetX(c), x2 + this.getOffsetX(c), y + this.getOffsetY(c), color);
    }

    public void drawVerticalLine(StackableContainer c, int x, int y1, int y2, int color) {
        super.func_73728_b(x + this.getOffsetX(c), y1 + this.getOffsetY(c), y2 + this.getOffsetY(c), color);
    }

    public void setMousePosition(StackableContainer c, int x, int y) {
        Mouse.setCursorPosition((int)((x + this.getOffsetX(c)) * this.field_146297_k.field_71443_c / this.field_146294_l), (int)((this.field_146295_m - (y + this.getOffsetY(c))) * this.field_146297_k.field_71440_d / this.field_146295_m));
    }

    public boolean func_73868_f() {
        return false;
    }

    public void onMouseWheel(int x, int y, int wheel) {
        if (wheel == 0) {
            return;
        }
        for (int i = 0; i < this.stack.stacks.length; ++i) {
            StackableContainer c = this.stack.getContainer(i);
            if (!c.mouseWheel(x - this.getOffsetX(c), y - this.getOffsetY(c), wheel)) continue;
            return;
        }
        if (wheel > 0) {
            this.setScrollPos(this.scrollX, this.scrollY - scrollSize);
        } else {
            this.setScrollPos(this.scrollX, this.scrollY + scrollSize);
        }
    }

    protected void func_146976_a(float f, int x, int y) {
        if (!this.stack.hasContainers((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            return;
        }
        this.onMouseWheel(x, y, Mouse.getDWheel());
        for (int i = 0; i < this.stack.stacks.length; ++i) {
            StackableContainer c = this.stack.getContainer(i);
            c.drawBackground(x - this.getOffsetX(c), y - this.getOffsetY(c));
        }
    }

    protected void func_146979_b(int x, int y) {
        if (!this.stack.hasContainers((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            return;
        }
        for (int i = 0; i < this.stack.stacks.length; ++i) {
            StackableContainer c = this.stack.getContainer(i);
            c.drawForeground(x - this.getOffsetX(c), y - this.getOffsetY(c));
        }
    }

    public void func_73863_a(int x, int y, float par3) {
        int i;
        boolean isOverButton = false;
        for (i = 0; i < 4; ++i) {
            if (!this.scrollButtons[i].func_146116_c(this.field_146297_k, x, y)) continue;
            isOverButton = true;
            break;
        }
        if (isOverButton) {
            super.func_73863_a(-100, -100, par3);
        } else {
            super.func_73863_a(x, y, par3);
            this.drawHoveringText(this.tooltips, x, y, this.field_146289_q);
        }
        this.tooltips.clear();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        for (i = 0; i < 4; ++i) {
            this.scrollButtons[i].func_146112_a(Minecraft.func_71410_x(), x, y);
        }
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o() == null && this.customTooltipItem != null) {
            this.func_146285_a(this.customTooltipItem, x, y);
            this.customTooltipItem = null;
        }
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
    }

    protected void func_73869_a(char key, int keyCode) {
        boolean ctrlDown;
        boolean shiftDown = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
        boolean bl = ctrlDown = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
        if (ctrlDown && keyCode == 19 && this.stack.stacks.length > 0 && !(this.stack.getContainer(0) instanceof NBTEditor)) {
            Common.channel.sendToServer(new PacketHandler.OpenEditorWindow("recipe", 1, false));
            return;
        }
        if (this.stack.hasContainers((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            for (int i = 0; i < this.stack.stacks.length; ++i) {
                if (!this.stack.getContainer(i).keyPressed(key, keyCode)) continue;
                return;
            }
        }
        if (keyCode == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i() || keyCode == 1 && !ctrlDown && !shiftDown) {
            long time = Minecraft.func_71386_F();
            if (time - this.lastCloseTime < 200L) {
                return;
            }
            this.lastCloseTime = time;
            this.closeContainer(-1);
            return;
        }
        if (keyCode == 1) {
            this.field_146297_k.field_71439_g.func_71053_j();
            return;
        }
        if (keyCode == 203) {
            keyCode = this.field_146297_k.field_71474_y.field_74370_x.func_151463_i();
        } else if (keyCode == 205) {
            keyCode = this.field_146297_k.field_71474_y.field_74366_z.func_151463_i();
        } else if (keyCode == 200) {
            keyCode = this.field_146297_k.field_71474_y.field_74351_w.func_151463_i();
        } else if (keyCode == 208) {
            keyCode = this.field_146297_k.field_71474_y.field_74368_y.func_151463_i();
        }
        if (keyCode == this.field_146297_k.field_71474_y.field_74370_x.func_151463_i()) {
            this.setScrollPos(this.scrollX - scrollSize, this.scrollY);
        } else if (keyCode == this.field_146297_k.field_71474_y.field_74351_w.func_151463_i()) {
            this.setScrollPos(this.scrollX, this.scrollY - scrollSize);
        } else if (keyCode == this.field_146297_k.field_71474_y.field_74366_z.func_151463_i()) {
            this.setScrollPos(this.scrollX + scrollSize, this.scrollY);
        } else if (keyCode == this.field_146297_k.field_71474_y.field_74368_y.func_151463_i()) {
            this.setScrollPos(this.scrollX, this.scrollY + scrollSize);
        } else {
            super.func_73869_a(key, keyCode);
            return;
        }
    }

    public void closeContainer(int stackId) {
        this.tellServerToCloseContainer(stackId);
        this.stack.closeContainer((EntityPlayer)this.field_146297_k.field_71439_g, stackId);
    }

    public List<String> handleItemTooltip(ItemStack itemstack, int mousex, int mousey, List<String> currenttip) {
        try {
            if (this.stack.hasContainers((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                this.stack.addItemStackTooltips(currenttip, itemstack);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return currenttip;
    }

    public void func_146285_a(ItemStack itemStack, int x, int y) {
        try {
            FontRenderer font;
            String id = UnknownItem.getItemDescriptor(itemStack);
            if (id.toLowerCase().startsWith("oredict:")) {
                itemStack = itemStack.func_77946_l();
                itemStack.func_151001_c("Ore: " + id.substring(8));
            }
            List list = itemStack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x);
            for (int k = 0; k < list.size(); ++k) {
                if (k == 0) {
                    list.set(k, itemStack.func_77953_t().field_77937_e + (String)list.get(k));
                    continue;
                }
                list.set(k, EnumChatFormatting.GRAY + (String)list.get(k));
            }
            if (this.stack.hasContainers((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                this.stack.addItemStackTooltips(list, itemStack);
            }
            this.drawHoveringText(list, x, y, (font = itemStack.func_77973_b().getFontRenderer(itemStack)) == null ? this.field_146289_q : font);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void drawHoveringText(List par1List, int par2, int par3, FontRenderer font) {
        if (tmiInstalled) {
            return;
        }
        try {
            super.drawHoveringText(par1List, par2, par3, font);
        }
        catch (NoSuchMethodError e) {
            tmiInstalled = true;
        }
    }

    protected void func_73864_a(int x, int y, int button) {
        for (int i = 0; i < 4; ++i) {
            if (!this.scrollButtons[i].func_146116_c(this.field_146297_k, x, y)) continue;
            this.draggingStack = 0;
            this.field_146290_a = this.scrollButtons[i];
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            this.func_146284_a(this.scrollButtons[i]);
            return;
        }
        if (button == 0) {
            for (int l = 0; l < this.field_146292_n.size(); ++l) {
                GuiButton guibutton = (GuiButton)this.field_146292_n.get(l);
                if (!guibutton.func_146116_c(this.field_146297_k, x, y)) continue;
                this.field_146290_a = guibutton;
            }
        }
        if (this.stack.hasContainers((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            int i;
            boolean clicked = false;
            for (i = 0; i < this.textFields.size(); ++i) {
                if (this.textFields.get(i).isMouseOver(x, y)) {
                    this.textFields.get(i).mouseClicked(x, y, button);
                    clicked = true;
                    continue;
                }
                if (!this.textFields.get((int)i).canLoseFocus) continue;
                this.textFields.get(i).setFocused(false);
            }
            if (clicked) {
                return;
            }
            for (i = 0; i < this.stack.stacks.length; ++i) {
                StackableContainer c = this.stack.getContainer(i);
                int dx = x - this.getOffsetX(c);
                int dy = y - this.getOffsetY(c);
                if (dx <= 0 || dx >= c.guiWidth || dy <= 0 || dy >= c.guiHeight) continue;
                this.draggingStack = i;
                if (!c.mouseDown(dx, dy, button)) continue;
                return;
            }
        }
        super.func_73864_a(x, y, button);
    }

    protected void func_146273_a(int x, int y, int button, long time) {
        if (this.stack.hasContainers((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            int dy;
            int dx;
            if (this.draggingStack < 0) {
                return;
            }
            StackableContainer c = this.stack.getContainer(this.draggingStack);
            if (c.mouseDragged(dx = x - this.getOffsetX(c), dy = y - this.getOffsetY(c), button)) {
                return;
            }
        }
        super.func_146273_a(x, y, button, time);
    }

    protected void func_146286_b(int x, int y, int button) {
        for (int i = 0; i < 4; ++i) {
            if (!this.scrollButtons[i].func_146116_c(this.field_146297_k, x, y)) continue;
            return;
        }
        if (this.stack.hasContainers((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            int dy;
            int dx;
            if (this.draggingStack < 0) {
                return;
            }
            StackableContainer c = this.stack.getContainer(this.draggingStack);
            if (c.mouseUp(dx = x - this.getOffsetX(c), dy = y - this.getOffsetY(c), button)) {
                return;
            }
        }
        if (button == 0) {
            for (int l = 0; l < this.field_146292_n.size(); ++l) {
                GuiButton guibutton = (GuiButton)this.field_146292_n.get(l);
                if (!guibutton.func_146116_c(this.field_146297_k, x, y) || !(guibutton instanceof StackableContainer.ContainerButton) || guibutton != this.field_146290_a) continue;
                ((StackableContainer.ContainerButton)guibutton).clicked();
                return;
            }
        }
        super.func_146286_b(x, y, button);
    }

    public static boolean tryHandleMouseClick(Slot slot, int inventorySlot, int mouseClick, int holdingShift, GuiContainer container) {
        if (slot == null || container == null || container.field_146297_k == null || container.field_146297_k.field_71439_g == null) {
            return false;
        }
        EntityClientPlayerMP player = container.field_146297_k.field_71439_g;
        inventorySlot = slot.field_75222_d;
        if (slot.field_75224_c != player.field_71071_by) {
            return false;
        }
        if (mouseClick != 1 || inventorySlot < 0 || inventorySlot >= container.field_147002_h.field_75151_b.size()) {
            return false;
        }
        ItemStack stack = slot.func_75211_c();
        if (stack != null && stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150462_ai) && !Common.disableCraftingGui) {
            Common.channel.sendToServer(new PacketHandler.OpenItemOnServer("workbench"));
            return true;
        }
        if (stack == null || !(stack.func_77973_b() instanceof UniqueItem.OpenableItem)) {
            return false;
        }
        for (CustomMouseClickHandler h : customMouseClickHandlers) {
            if (!h.handle((EntityPlayer)player, stack, holdingShift == 1)) continue;
            return true;
        }
        if (!((UniqueItem.OpenableItem)stack.func_77973_b()).ensureInventoryIdentifiers((EntityPlayer)player, stack)) {
            return true;
        }
        Common.channel.sendToServer(new PacketHandler.OpenItemOnServer(UniqueItem.getIdentifier(stack)));
        return true;
    }

    protected void func_146984_a(Slot slot, int inventorySlot, int mouseClick, int holdingShift) {
        if (!(this instanceof ContainerStackGui) && ContainerStackGui.tryHandleMouseClick(slot, inventorySlot, mouseClick, holdingShift, this)) {
            return;
        }
        if (slot != null) {
            inventorySlot = slot.field_75222_d;
        }
        EntityClientPlayerMP player = this.field_146297_k.field_71439_g;
        this.overrideFailed = false;
        this.unoverrideFailed = false;
        if (holdingShift != 0 && holdingShift != 1) {
            try {
                super.func_146984_a(slot, inventorySlot, mouseClick, holdingShift);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        if (this.stack.hasContainers((EntityPlayer)Minecraft.func_71410_x().field_71439_g) && this.stack.overrideRightClick(inventorySlot, mouseClick, holdingShift == 1 != Common.shiftOpensInSameStack, (EntityPlayer)player)) {
            if (!this.overrideFailed || this.unoverrideFailed) {
                this.tellServerToRightClick(inventorySlot, mouseClick, holdingShift == 1 != Common.shiftOpensInSameStack);
            }
            return;
        }
        super.func_146984_a(slot, inventorySlot, mouseClick, holdingShift);
    }

    public void tellServerToCloseContainer(int stackId) {
        Common.channel.sendToServer(new PacketHandler.CloseContainer(stackId));
    }

    public void tellServerToRightClick(int slot, int button, boolean shift) {
        Common.channel.sendToServer(new PacketHandler.CustomRightClick(slot, button, shift));
    }

    public void setScrollPos(int x, int y) {
        int i;
        ScaledResolution res = new ScaledResolution(this.field_146297_k, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
        if (x + res.func_78326_a() >= this.field_146999_f + 20) {
            x = this.field_146999_f + 20 - res.func_78326_a();
        }
        if (y + res.func_78328_b() >= this.field_147000_g + 20) {
            y = this.field_147000_g + 20 - res.func_78328_b();
        }
        if (x <= -20) {
            x = -20;
        }
        if (y <= -20) {
            y = -20;
        }
        if (this.field_146999_f <= res.func_78326_a()) {
            x = 0;
        }
        if (this.field_147000_g <= res.func_78328_b()) {
            y = 0;
        }
        this.scrollButtons[0].field_146124_l = y > -20;
        this.scrollButtons[1].field_146124_l = y + res.func_78328_b() < this.field_147000_g + 20;
        this.scrollButtons[2].field_146124_l = x > -20;
        this.scrollButtons[3].field_146124_l = x + res.func_78326_a() < this.field_146999_f + 20;
        this.scrollButtons[1].field_146125_m = this.field_147000_g > res.func_78328_b();
        this.scrollButtons[0].field_146125_m = this.scrollButtons[1].field_146125_m;
        this.scrollButtons[3].field_146125_m = this.field_146999_f > res.func_78326_a();
        this.scrollButtons[2].field_146125_m = this.scrollButtons[3].field_146125_m;
        for (i = 4; i < this.field_146292_n.size(); ++i) {
            ((GuiButton)this.field_146292_n.get((int)i)).field_146128_h += this.scrollX;
            ((GuiButton)this.field_146292_n.get((int)i)).field_146129_i += this.scrollY;
        }
        for (i = 0; i < this.textFields.size(); ++i) {
            this.textFields.get((int)i).xPos += this.scrollX;
            this.textFields.get((int)i).yPos += this.scrollY;
        }
        for (i = 0; i < this.stack.field_75151_b.size(); ++i) {
            ((Slot)this.stack.field_75151_b.get((int)i)).field_75223_e += this.scrollX;
            ((Slot)this.stack.field_75151_b.get((int)i)).field_75221_f += this.scrollY;
        }
        this.scrollX = x;
        this.scrollY = y;
        for (i = 4; i < this.field_146292_n.size(); ++i) {
            ((GuiButton)this.field_146292_n.get((int)i)).field_146128_h -= this.scrollX;
            ((GuiButton)this.field_146292_n.get((int)i)).field_146129_i -= this.scrollY;
        }
        for (i = 0; i < this.textFields.size(); ++i) {
            this.textFields.get((int)i).xPos -= this.scrollX;
            this.textFields.get((int)i).yPos -= this.scrollY;
            this.textFields.get(i).updateTextBox();
        }
        for (i = 0; i < this.stack.field_75151_b.size(); ++i) {
            ((Slot)this.stack.field_75151_b.get((int)i)).field_75223_e -= this.scrollX;
            ((Slot)this.stack.field_75151_b.get((int)i)).field_75221_f -= this.scrollY;
        }
        if (this.worldAndResolutionSet) {
            this.func_73876_c();
        }
    }

    public int getOffsetX(StackableContainer container) {
        if (container == null) {
            return this.field_147003_i - this.scrollX;
        }
        return this.field_147003_i + this.stack.getOffsetX(container) - this.scrollX;
    }

    public int getOffsetY(StackableContainer container) {
        if (container == null) {
            return this.field_147009_r - this.scrollY;
        }
        return this.field_147009_r + this.stack.getOffsetY(container) - this.scrollY;
    }

    @Override
    public int getScrollX() {
        return this.scrollX;
    }

    @Override
    public int getScrollY() {
        return this.scrollY;
    }

    public void clipScreen(StackableContainer container, int x, int y, int width, int height, ScaledResolution scale) {
        if (scale == null) {
            scale = new ScaledResolution(this.field_146297_k, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
        }
        int factor = scale.func_78325_e();
        GL11.glScissor((int)((x += this.getOffsetX(container)) * factor), (int)((int)((scale.func_78324_d() - (double)(y += this.getOffsetY(container)) - (double)height) * (double)factor)), (int)(width * factor), (int)(height * factor));
        GL11.glEnable((int)3089);
    }

    public void unclipScreen() {
        GL11.glDisable((int)3089);
    }

    public String getBackButtonText(StackableContainer c) {
        if (this.stack.stacks[c.stackId].size() < 2) {
            return new Translatable("button.close", new Object[0]).translate();
        }
        return new Translatable("button.backn", this.stack.stacks[c.stackId].size()).translate();
    }

    private class ScrollButton
    extends GuiButton {
        private final int offsetX;
        private final int offsetY;

        public ScrollButton(int id, int x, int y, int w, int h, int offsetX, int offsetY) {
            super(id, x, y, w, h, "");
            this.offsetX = offsetX;
            this.offsetY = offsetY;
        }

        public void func_146112_a(Minecraft par1Minecraft, int par2, int par3) {
            if (this.field_146125_m) {
                try {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    par1Minecraft.field_71446_o.func_110577_a(PlayerContainer.texture);
                    this.func_73729_b(this.field_146128_h, this.field_146129_i, this.offsetX + this.func_146114_a(this.func_146116_c(par1Minecraft, par2, par3)) * this.field_146120_f, this.offsetY, this.field_146120_f, this.field_146121_g);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void drawButtonInForeground(Minecraft par1Minecraft, int par2, int par3) {
            if (this.field_146125_m) {
                try {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    par1Minecraft.field_71446_o.func_110577_a(PlayerContainer.texture);
                    this.func_73729_b(this.field_146128_h - ContainerStackGui.this.field_147003_i, this.field_146129_i - ContainerStackGui.this.field_147009_r, this.offsetX + this.func_146114_a(this.func_146116_c(par1Minecraft, par2, par3)) * this.field_146120_f, this.offsetY, this.field_146120_f, this.field_146121_g);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public class Text {
        public int width;
        public String text;
        private FontRenderer fontRenderer;
        private StackableContainer container;
        private boolean shadow = false;

        public Text(StackableContainer container, String text, FontRenderer fontRenderer) {
            this.container = container;
            this.text = text;
            this.width = 0;
            this.fontRenderer = fontRenderer;
        }

        public Text setShadow(boolean shadow) {
            this.shadow = shadow;
            return this;
        }

        public Text truncateString(int width) {
            this.width = width;
            int length = this.fontRenderer.func_78256_a(this.text);
            if (length > width) {
                this.text = this.fontRenderer.func_78269_a(this.text, width - this.fontRenderer.func_78256_a(ellipsis)) + ellipsis;
            }
            return this;
        }

        public Text drawString(int x, int y, int color) {
            x += ContainerStackGui.this.stack.getOffsetX(this.container) - ContainerStackGui.this.scrollX;
            y += ContainerStackGui.this.stack.getOffsetY(this.container) - ContainerStackGui.this.scrollY;
            if (this.shadow) {
                this.fontRenderer.func_78261_a(this.text, x, y, color);
            } else {
                this.fontRenderer.func_78276_b(this.text, x, y, color);
            }
            return this;
        }

        public Text drawString(int x, int y, int color, boolean rightAlign) {
            if (rightAlign) {
                int length = this.fontRenderer.func_78256_a(this.text);
                x = x + this.width - length;
            }
            return this.drawString(x, y, color);
        }

        public Text drawCenteredString(int x, int y, int color) {
            int length = this.fontRenderer.func_78256_a(this.text);
            return this.drawString(x - length / 2, y, color);
        }

        public int getWidth() {
            return this.fontRenderer.func_78256_a(this.text);
        }
    }

    public static interface CustomMouseClickHandler {
        public boolean handle(EntityPlayer var1, ItemStack var2, boolean var3);
    }
}

