/*
 * Decompiled with CFR 0.152.
 */
package brad16840.backpacks.items;

import brad16840.backpacks.blocks.QuantumChest;
import brad16840.backpacks.blocks.QuantumChestTileEntity;
import brad16840.backpacks.gui.StandaloneBackpackGui;
import brad16840.backpacks.items.Backpack;
import brad16840.common.BlockPos;
import brad16840.common.Common;
import brad16840.common.ContainerStack;
import brad16840.common.PacketHandler;
import brad16840.common.StackableContainer;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class QuantumBackpack
extends UniqueItem
implements UniqueItem.OpenableItem {
    public static Translatable error_chestNotFound = new Translatable("problem.openquantum404", new Object[0]);
    public static Translatable error_chestEmpty = new Translatable("problem.openquantumempty", new Object[0]);
    public String field_77774_bZ;

    public QuantumBackpack(String unlocalizedName) {
        this.field_77774_bZ = unlocalizedName;
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.func_77655_b(unlocalizedName);
    }

    public String func_77667_c(ItemStack itemstack) {
        int metadata = itemstack.func_77960_j();
        if (metadata < 1 || metadata > 32) {
            return "item." + this.field_77774_bZ;
        }
        String end = "";
        if (--metadata > 15) {
            metadata -= 16;
        }
        return "item." + Common.backpack.field_77774_bZ + "." + Backpack.colors[metadata] + end;
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("backpacks16840:" + this.field_77774_bZ);
    }

    public IIcon func_77617_a(int damage) {
        if (damage < 1 || damage > 16) {
            return this.field_77791_bV;
        }
        return Common.backpack.itemIcons[damage - 1];
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af() && !Common.disableBackpackBlocks) {
            Common.backpackBlock.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
            return true;
        }
        return false;
    }

    @Override
    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af() && !Common.disableBackpackBlocks) {
            return false;
        }
        return super.onItemUseFirst(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K && QuantumBackpack.ensureInventoryAndQuantumChestIdentifiers(player, (IInventory)player.field_71071_by, stack, -1, QuantumBackpack.getInfo(stack))) {
            Common.channel.sendToServer(new PacketHandler.OpenItemOnServer(UniqueItem.getIdentifier(stack)));
        }
        return super.func_77659_a(stack, world, player);
    }

    public static String getInfo(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b("Lore")) {
            return "@Pos: 0, 0, 0; Dim: 0";
        }
        NBTTagList lore = tag.func_150295_c("Lore", 8);
        for (int i = 0; i < lore.func_74745_c(); ++i) {
            String s = lore.func_150307_f(i);
            if (!s.startsWith("@Pos:")) continue;
            return s;
        }
        return "@Pos: 0, 0, 0; Dim: 0";
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (Common.hideUniqueItemIds) {
            return;
        }
        String uuid = UniqueItem.getIdentifier(stack);
        if (uuid.equals("none")) {
            new Translatable("tooltip.unidentified", new Object[0]).addTo(list);
            return;
        }
        new Translatable("tooltip.id", uuid.substring(0, 13).toUpperCase()).addTo(list);
    }

    public static BlockPos getChestPosition(ItemStack stack) {
        String s = QuantumBackpack.getInfo(stack);
        try {
            String[] parts = s.split("[;:]")[1].split(",");
            return new BlockPos(Integer.parseInt(parts[0].trim()), Integer.parseInt(parts[1].trim()), Integer.parseInt(parts[2].trim()));
        }
        catch (Exception e) {
            return new BlockPos(0, 0, 0);
        }
    }

    public static int getChestDimension(ItemStack stack) {
        String s = QuantumBackpack.getInfo(stack);
        try {
            return Integer.parseInt(s.split("[;:]")[3].trim());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static void setChest(ItemStack stack, BlockPos pos, int dimension) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        NBTTagList nlore = new NBTTagList();
        NBTTagList lore = tag.func_150295_c("Lore", 8);
        for (int i = 0; i < lore.func_74745_c(); ++i) {
            String entry = lore.func_150307_f(i);
            if (entry.startsWith("@Pos:")) continue;
            nlore.func_74742_a((NBTBase)new NBTTagString(entry));
        }
        nlore.func_74742_a((NBTBase)new NBTTagString("@Pos: " + pos.x + ", " + pos.y + ", " + pos.z + "; Dim: " + dimension));
        tag.func_74782_a("Lore", (NBTBase)nlore);
    }

    public static void ensureQuantumChestBackpackIdentifier(EntityPlayer player, String chestId, ArrayList<String> dataNeeded, HashSet<String> visited) {
        visited.add(chestId);
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        NBTTagCompound tag = data.getBlockData(chestId, false);
        if (tag == null) {
            return;
        }
        if (tag.func_74764_b("backpack")) {
            String backpackId;
            ItemStack stack = UniqueItem.loadItemStackFromNBT(tag.func_74775_l("backpack"));
            if (stack != null && stack.func_77973_b() instanceof QuantumBackpack) {
                String otherChest = QuantumBackpack.getInfo(stack);
                if (!data.isSubscribed(otherChest)) {
                    dataNeeded.add(otherChest);
                } else if (!visited.contains(otherChest)) {
                    QuantumBackpack.ensureQuantumChestBackpackIdentifier(player, otherChest, dataNeeded, visited);
                }
            } else if (stack != null && !data.isSubscribed(backpackId = UniqueItem.getIdentifier(stack))) {
                dataNeeded.add(backpackId);
            }
        }
    }

    public static boolean ensureInventoryAndQuantumChestIdentifiers(EntityPlayer player, IInventory inventory, ItemStack stackToOpen, int stackToOpenIn, String chestId) {
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        ArrayList<String> dataNeeded = new ArrayList<String>();
        if (!data.isSubscribed(chestId)) {
            dataNeeded.add(chestId);
        } else {
            QuantumBackpack.ensureQuantumChestBackpackIdentifier(player, chestId, dataNeeded, new HashSet<String>());
        }
        return Common.ensureInventoryIdentifiers(player, (IInventory)player.field_71071_by, stackToOpen, stackToOpenIn, dataNeeded);
    }

    @Override
    public boolean open(EntityPlayer player, ItemStack stack, World world) {
        if (!QuantumBackpack.ensureInventoryAndQuantumChestIdentifiers(player, (IInventory)player.field_71071_by, stack, -1, QuantumBackpack.getInfo(stack))) {
            Minecraft mc;
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && Backpack.openingStandalone && (mc = Minecraft.func_71410_x()) != null && mc.field_71462_r instanceof StandaloneBackpackGui) {
                ((StandaloneBackpackGui)mc.field_71462_r).triggerReopen = true;
            }
            return false;
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && Backpack.openingStandalone) {
            Backpack.openingStandalone = false;
            StandaloneBackpackGui.open(player, stack);
            return false;
        }
        BlockPos pos = QuantumBackpack.getChestPosition(stack);
        int dimension = QuantumBackpack.getChestDimension(stack);
        if (world.field_72995_K) {
            return true;
        }
        ItemStack s = player.field_71071_by.func_70445_o();
        player.field_71071_by.func_70437_b(null);
        player.openGui((Object)"backpacks16840", 10067 + dimension, player.field_70170_p, pos.x, pos.y, pos.z);
        if (player.field_71070_bA instanceof ContainerStack) {
            player.field_71071_by.func_70437_b(s);
            Common.channel.sendToPlayer(player, new PacketHandler.TellTheClientTheHeldItemStackHasChanged(s));
        } else if (s != null) {
            player.func_71019_a(s, false);
        }
        return true;
    }

    @Override
    public StackableContainer openContainer(EntityPlayer player, IInventory parentInventory, int inventoryIndex, ItemStack stack, int stackId) {
        String info = QuantumBackpack.getInfo(stack);
        if (!QuantumBackpack.ensureInventoryAndQuantumChestIdentifiers(player, parentInventory, stack, stackId, info)) {
            return null;
        }
        QuantumChestTileEntity.VirtualQuantumChest chest = QuantumChestTileEntity.VirtualQuantumChest.getChest(player.field_70170_p, info);
        if (chest != null) {
            if (!chest.canPlayerUse(player)) {
                UniqueItemData.permissionError("use", QuantumChest.name).log(player);
                return null;
            }
            if (chest.backpackId == null || UniqueItemData.get(player.field_70170_p).isPermissionDeleted(player, chest.backpackId)) {
                error_chestEmpty.log(player);
                return null;
            }
            return chest.openPreparedContainer(player, null);
        }
        if (UniqueItemData.get(player.field_70170_p).getBlockData(info, false) == null) {
            UniqueItemData.permissionError("use", QuantumChest.name).log(player);
        }
        return null;
    }

    @Override
    public Integer getPreferreredStack(ContainerStack container, int stackId) {
        return stackId;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        if (location instanceof EntityItem) {
            BlockPos pos = QuantumBackpack.getChestPosition(itemstack);
            double px = (double)pos.x - location.field_70165_t;
            double py = (double)pos.y - location.field_70163_u;
            double pz = (double)pos.z - location.field_70161_v;
            double scale = Math.sqrt(px * px + py * py + pz * pz) * 2.0;
            if (scale < 8.0) {
                ((EntityItem)location).lifespan = 50;
            }
        } else {
            EntityItem item = new EntityItem(world, location.field_70165_t, location.field_70163_u, location.field_70161_v, itemstack);
            BlockPos pos = QuantumBackpack.getChestPosition(itemstack);
            pos.x = (int)((double)pos.x - location.field_70165_t);
            pos.y = (int)((double)pos.y - location.field_70163_u);
            pos.z = (int)((double)pos.z - location.field_70161_v);
            double scale = Math.sqrt(pos.x * pos.x + pos.y * pos.y + pos.z * pos.z) * 2.0;
            if (scale == Double.NaN || scale < 1.0) {
                scale = 1.0;
            }
            item.field_70159_w = (double)pos.x / scale;
            item.field_70181_x = (double)pos.y / scale;
            item.field_70179_y = (double)pos.z / scale;
            item.field_70177_z = location.field_70177_z;
            item.field_145804_b = 10;
            item.lifespan = 600;
            if (scale < 8.0) {
                ((EntityItem)location).lifespan = 50;
            }
            return item;
        }
        return null;
    }

    @Override
    public boolean hasUniqueData() {
        return false;
    }

    @Override
    public boolean ensureInventoryIdentifiers(EntityPlayer player, ItemStack stack) {
        return QuantumBackpack.ensureInventoryAndQuantumChestIdentifiers(player, (IInventory)player.field_71071_by, stack, -1, QuantumBackpack.getInfo(stack));
    }
}

