/*
 * Decompiled with CFR 0.152.
 */
package brad16840.backpacks.items;

import brad16840.backpacks.gui.BackpackContainer;
import brad16840.backpacks.gui.BackpackView;
import brad16840.backpacks.gui.StandaloneBackpackGui;
import brad16840.common.Common;
import brad16840.common.ContainerStack;
import brad16840.common.PacketHandler;
import brad16840.common.StackableContainer;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import brad16840.common.UniqueItemInventory;
import brad16840.common.gui.EmptyRestorerView;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class Backpack
extends UniqueItem
implements UniqueItem.UpdatableItem,
UniqueItem.OpenableItem,
UniqueItem.ContainerItem,
UniqueItem.ViewableItem {
    public static int[] _widths = new int[]{9, 9, 9, 9, 9, 9};
    public static int[] _heights = new int[]{3, 4, 5, 6, 7, 8};
    public static String[] _upgrades = new String[]{"backpacks16840:backpack_pouch", "backpacks16840:backpack_pouch", "backpacks16840:backpack_pouch", "backpacks16840:backpack_pouch", "backpacks16840:backpack_pouch"};
    public static boolean _forceDefaults = false;
    public static boolean _allowBetterUpgrades = true;
    public static int[] widths;
    public static int[] heights;
    public static String[] upgrades;
    public static boolean forceDefaults;
    public static boolean allowBetterUpgrades;
    public static boolean openingStandalone;
    public String field_77774_bZ;
    public static Translatable name;
    public static final String[] colors;
    public IIcon[] openIcons;
    public IIcon[] itemIcons;

    public Backpack(String unlocalizedName) {
        this.field_77774_bZ = unlocalizedName;
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.func_77655_b(unlocalizedName);
        name = new Translatable("item." + unlocalizedName + ".name", new Object[0]);
        Backpack.name.toLowerCase = true;
        this.field_77787_bX = true;
    }

    public String func_77667_c(ItemStack itemstack) {
        int metadata = itemstack.func_77960_j();
        if (metadata < 0 || metadata > 31) {
            return "item." + this.field_77774_bZ;
        }
        String end = "";
        if (metadata > 15) {
            metadata -= 16;
        }
        return "item." + this.field_77774_bZ + "." + colors[metadata] + end;
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.openIcons = new IIcon[16];
        this.itemIcons = new IIcon[16];
        for (int i = 0; i < 16; ++i) {
            this.itemIcons[i] = iconRegister.func_94245_a("backpacks16840:" + this.field_77774_bZ + "." + colors[i]);
            this.openIcons[i] = iconRegister.func_94245_a("backpacks16840:" + this.field_77774_bZ + "." + colors[i] + ".open");
        }
        this.field_77791_bV = this.itemIcons[12];
    }

    public IIcon func_77617_a(int damage) {
        if (damage < 0 || damage > 31) {
            return this.itemIcons[0];
        }
        if (damage >= 16) {
            return this.openIcons[damage - 16];
        }
        return this.itemIcons[damage];
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af() && !Common.disableBackpackBlocks) {
            Common.backpackBlock.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
            return true;
        }
        return false;
    }

    @Override
    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af() && !Common.disableBackpackBlocks) {
            return false;
        }
        return super.onItemUseFirst(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K && Common.ensureInventoryIdentifiers(player, (IInventory)player.field_71071_by, stack, -1, new ArrayList<String>())) {
            Common.channel.sendToServer(new PacketHandler.OpenItemOnServer(UniqueItem.getIdentifier(stack)));
        }
        return super.func_77659_a(stack, world, player);
    }

    @Override
    public boolean open(EntityPlayer player, ItemStack stack, World world) {
        if (!Common.ensureInventoryIdentifiers(player, (IInventory)player.field_71071_by, stack, -1, new ArrayList<String>())) {
            Minecraft mc;
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && openingStandalone && (mc = Minecraft.func_71410_x()) != null && mc.field_71462_r instanceof StandaloneBackpackGui) {
                ((StandaloneBackpackGui)mc.field_71462_r).triggerReopen = true;
            }
            return false;
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && openingStandalone) {
            openingStandalone = false;
            StandaloneBackpackGui.open(player, stack);
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        Common.proxy.guiItem = stack;
        ItemStack s = player.field_71071_by.func_70445_o();
        player.field_71071_by.func_70437_b(null);
        player.openGui((Object)"backpacks16840", 4, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        if (player.field_71070_bA instanceof ContainerStack) {
            player.field_71071_by.func_70437_b(s);
            Common.channel.sendToPlayer(player, new PacketHandler.TellTheClientTheHeldItemStackHasChanged(s));
        } else if (s != null) {
            player.func_71019_a(s, false);
        }
        return true;
    }

    @Override
    public StackableContainer openContainer(EntityPlayer player, IInventory parentInventory, int inventoryIndex, ItemStack stack, int stackId) {
        if (!Common.ensureInventoryIdentifiers(player, parentInventory, stack, stackId, new ArrayList<String>())) {
            return null;
        }
        boolean fromChest = false;
        if (player.field_71070_bA instanceof ContainerStack) {
            fromChest = ((ContainerStack)player.field_71070_bA).fromChest;
        }
        return BackpackContainer.openContainer(player, UniqueItem.getIdentifier(stack), fromChest);
    }

    @Override
    public void updateItemStack(StackableContainer.ContainerSlotInterface slot, ItemStack stack) {
        String uuid = UniqueItem.getIdentifier(stack);
        if (uuid.equals("none")) {
            return;
        }
        if (slot != null && slot.chainContains(uuid, true)) {
            if (stack.func_77960_j() < 16) {
                stack.func_77964_b(stack.func_77960_j() + 16);
            }
        } else if (stack.func_77960_j() >= 16) {
            stack.func_77964_b(stack.func_77960_j() - 16);
        }
    }

    @Override
    public Integer getPreferreredStack(ContainerStack container, int stackId) {
        return stackId;
    }

    public static int getBackpackSize(World world, NBTTagCompound tag, String uuid, boolean getWidth) {
        boolean dirty = false;
        if (!tag.func_74764_b("width")) {
            tag.func_74768_a("width", widths[0]);
            dirty = true;
        }
        if (!tag.func_74764_b("height")) {
            tag.func_74768_a("height", heights[0]);
            dirty = true;
        }
        if (dirty) {
            UniqueItemData.get(world).markItemDirty(uuid);
        }
        int width = tag.func_74762_e("width");
        int height = tag.func_74762_e("height");
        for (int upgrade = 0; upgrade < widths.length; ++upgrade) {
            int result;
            if (forceDefaults && (widths[upgrade] != width || heights[upgrade] != height)) continue;
            int n = result = getWidth ? width : height;
            if (result < 1) {
                result = 1;
            }
            return result;
        }
        return getWidth ? widths[0] : heights[0];
    }

    public static boolean setBackpackSize(EntityPlayer player, String uuid, int width, int height) {
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        if (!data.hasRequiredPermission(player, uuid, 2)) {
            UniqueItemData.permissionError("resize", name).send(player);
            return false;
        }
        NBTTagCompound tag = data.getItemData(player, uuid);
        if (tag == null) {
            return false;
        }
        tag.func_74768_a("width", width);
        tag.func_74768_a("height", height);
        tag = tag.func_74775_l("inventory");
        int transactionId = tag.func_74762_e("save-count") + 1;
        tag.func_74768_a("save-count", transactionId);
        tag.func_74768_a("width", width);
        tag.func_74768_a("height", height);
        data.markItemDirty(uuid);
        return true;
    }

    public static boolean setBackpackColor(EntityPlayer player, String uuid, int color) {
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        if (!data.hasRequiredPermission(player, uuid, 2)) {
            UniqueItemData.permissionError("dye", name).send(player);
            return false;
        }
        NBTTagCompound tag = data.getItemData(player, uuid);
        if (tag == null) {
            return false;
        }
        if (color > 15) {
            color -= 16;
        }
        tag.func_74768_a("color", color);
        data.markItemDirty(uuid);
        return true;
    }

    @Override
    public int getSlotWidth(World world, NBTTagCompound tag, String uuid) {
        return Backpack.getBackpackSize(world, tag, uuid, true);
    }

    @Override
    public int getSlotHeight(World world, NBTTagCompound tag, String uuid) {
        return Backpack.getBackpackSize(world, tag, uuid, false);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        NBTTagCompound collect;
        if (player == null || player.field_70170_p == null) {
            return;
        }
        String uuid = UniqueItem.getIdentifier(stack);
        if (uuid.equals("none")) {
            if (Common.hideUniqueItemIds) {
                return;
            }
            new Translatable("tooltip.unidentified", new Object[0]).addTo(list);
            return;
        }
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        if (!data.isSubscribed(uuid)) {
            if (Common.hideUniqueItemIds) {
                return;
            }
            new Translatable("tooltip.id", uuid.substring(0, 13).toUpperCase()).addTo(list);
            return;
        }
        if (data.isPermissionDeleted(player, uuid)) {
            new Translatable("tooltip.deleted", new Object[0]).addTo(list);
            return;
        }
        if (!data.hasRequiredPermission(player, uuid, 1)) {
            new Translatable("tooltip.unopenable", new Object[0]).addTo(list);
            return;
        }
        if (!data.hasRequiredPermission(player, uuid, 2)) {
            new Translatable("tooltip.uneditable", new Object[0]).addTo(list);
            return;
        }
        NBTTagCompound tag = data.getItemData(player, uuid);
        if (tag != null && tag.func_150297_b("collect", 10) && (collect = tag.func_74775_l("collect")).func_74767_n("collect-paused")) {
            new Translatable("tooltip.collect.paused", new Object[0]).addTo(list);
        }
        if (Common.hideUniqueItemIds) {
            return;
        }
        new Translatable("tooltip.id", uuid.substring(0, 13).toUpperCase()).addTo(list);
    }

    @Override
    public String getContainerItemType() {
        return "backpack";
    }

    @Override
    public void onIdentification(EntityPlayer player, ItemStack stack, String uuid) {
        super.onIdentification(player, stack, uuid);
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        NBTTagCompound tag = data.getItemData(uuid, false);
        if (tag == null) {
            return;
        }
        if (!tag.func_74764_b("inventory")) {
            tag.func_74782_a("inventory", (NBTBase)new NBTTagCompound());
        }
        if (!tag.func_74764_b("custom-name") && tag.func_74764_b("display") && tag.func_74775_l("display").func_74764_b("Name")) {
            tag.func_74778_a("custom-name", tag.func_74775_l("display").func_74779_i("Name"));
        }
        if (tag.func_74764_b("custom-name")) {
            stack.func_151001_c(tag.func_74779_i("custom-name"));
        }
        if (!tag.func_74764_b("color")) {
            tag.func_74768_a("color", Math.max(0, Math.min(stack.func_77960_j(), 15)));
        }
        stack.func_77964_b(tag.func_74762_e("color"));
        if (!tag.func_150297_b("replenish", 10)) {
            NBTTagCompound t = new NBTTagCompound();
            t.func_74757_a("exclude", true);
            tag.func_74782_a("replenish", (NBTBase)t);
        }
        if (!tag.func_74764_b("width")) {
            tag.func_74768_a("width", widths[0]);
        }
        if (!tag.func_74764_b("height")) {
            tag.func_74768_a("height", heights[0]);
        }
        int width = tag.func_74762_e("width");
        int height = tag.func_74762_e("height");
        if (!(tag = tag.func_74775_l("inventory")).func_74764_b("container-type")) {
            tag.func_74778_a("container-type", ((UniqueItem.ContainerItem)stack.func_77973_b()).getContainerItemType());
        }
        int transactionId = tag.func_74762_e("save-count") + 1;
        tag.func_74768_a("save-count", transactionId);
        tag.func_74768_a("width", width);
        tag.func_74768_a("height", height);
        data.markItemDirty(uuid);
    }

    @Override
    public boolean subscribeToContents() {
        return false;
    }

    @Override
    public StackableContainer viewItem(EntityPlayer player, String id, int playerInventorySlot) {
        if (id == null) {
            return new EmptyRestorerView();
        }
        if (id.equals("none")) {
            return null;
        }
        NBTTagCompound tag = UniqueItemData.get(player.field_70170_p).getItemData(player, id);
        if (tag == null) {
            UniqueItemData.permissionError("view", name).log(player);
            return null;
        }
        UniqueItemInventory inventory = UniqueItemInventory.createInventory(Common.backpack, player, id);
        if (inventory == null) {
            new Translatable("problem.invalidbackpackinventory", new Object[0]).log(player);
            return null;
        }
        return new BackpackView(Backpack.getBackpackSize(player.field_70170_p, tag, id, true), Backpack.getBackpackSize(player.field_70170_p, tag, id, false), inventory, playerInventorySlot);
    }

    @Override
    public boolean ensureInventoryIdentifiers(EntityPlayer player, ItemStack stack) {
        return Common.ensureInventoryIdentifiers(player, (IInventory)player.field_71071_by, stack, -1, new ArrayList<String>());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        for (int i = 0; i < 16; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    static {
        openingStandalone = false;
        colors = new String[]{"black", "red", "green", "brown", "blue", "purple", "cyan", "silver", "gray", "pink", "lime", "yellow", "light_blue", "magenta", "orange", "white"};
    }

    public static class BackpackResizer
    extends Item {
        public String field_77774_bZ;

        public BackpackResizer(String unlocalizedName) {
            this.field_77774_bZ = unlocalizedName;
            this.func_77625_d(1);
            this.func_77637_a(CreativeTabs.field_78026_f);
            this.func_77655_b(unlocalizedName);
        }

        public void func_94581_a(IIconRegister iconRegister) {
            this.field_77791_bV = iconRegister.func_94245_a("backpacks16840:" + this.field_77774_bZ);
        }

        public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
            new Translatable("tooltip.backpackresizer", new Object[0]).addTo(list);
        }

        public boolean hasCustomEntity(ItemStack stack) {
            return true;
        }

        public Entity createEntity(World world, Entity location, ItemStack itemstack) {
            if (!(location instanceof EntityItem)) {
                EntityItem item = new EntityItem(world, location.field_70165_t, location.field_70163_u, location.field_70161_v, itemstack);
                item.field_70159_w = location.field_70159_w;
                item.field_70181_x = location.field_70181_x;
                item.field_70179_y = location.field_70179_y;
                item.field_70177_z = location.field_70177_z;
                item.field_145804_b = 10;
                item.lifespan = 1;
                return item;
            }
            ((EntityItem)location).lifespan = 1;
            return null;
        }

        public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer player) {
            new Translatable("message.resizerinstructions", new Object[0]).log(player);
            return par1ItemStack;
        }
    }
}

