/*
 * Decompiled with CFR 0.152.
 */
package brad16840.backpacks.gui;

import brad16840.backpacks.BackpackChecker;
import brad16840.backpacks.gui.ModelTrapezoid;
import brad16840.backpacks.items.Backpack;
import brad16840.common.Common;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ModelBackpack
extends ModelBase {
    public ModelRenderer backpackBody;
    public ModelRenderer backpackPouch1;
    public ModelRenderer backpackPouch2;
    public ModelRenderer backpackClasp;
    public ModelRenderer backpackHood;
    public ModelBiped biped;
    public static ResourceLocation[] textures;
    public static ResourceLocation[] animatedTextures;
    public static WeakHashMap<ModelBiped, ModelBackpack> instances;

    public static void renderBackpack(ModelBiped biped, Entity entity, float par7) {
        if (!(entity instanceof EntityPlayer) || !Common.backpackRendererEnabled) {
            return;
        }
        if (!instances.containsKey(biped)) {
            instances.put(biped, new ModelBackpack(biped));
        }
        instances.get(biped).render((EntityPlayer)entity, par7);
    }

    private void setRotation(ModelRenderer model, float x, float y, float z) {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
    }

    public ModelBackpack(ModelBiped biped) {
        this.biped = biped;
        this.field_78090_t = 64;
        this.field_78089_u = 32;
        this.backpackBody = new ModelRenderer((ModelBase)this, 18, 0);
        this.backpackBody.func_78789_a(-3.0f, -5.0f, 4.0f, 6, 9, 2);
        this.backpackBody.func_78793_a(0.0f, 6.0f, -2.0f);
        this.setRotation(this.backpackBody, 0.0f, 0.0f, 0.0f);
        this.backpackPouch1 = new ModelRenderer((ModelBase)this, 0, 12);
        this.backpackPouch1.func_78789_a(-2.5f, -0.25f, 4.75f, 5, 4, 2);
        this.backpackPouch2 = new ModelRenderer((ModelBase)this, 0, 21);
        this.backpackPouch2.func_78789_a(-2.0f, 0.5f, 5.5f, 4, 3, 2);
        this.backpackClasp = new ModelRenderer((ModelBase)this, 0, 0);
        this.backpackClasp.func_78789_a(-0.5f, -2.75f, 6.0f, 1, 1, 1);
        this.backpackHood = new ModelRenderer((ModelBase)this, 0, 5);
        this.backpackHood.func_78789_a(-2.5f, -4.25f, 5.75f, 5, 3, 1);
        this.backpackBody.func_78792_a(this.backpackClasp);
        this.backpackBody.func_78792_a(this.backpackHood);
        this.backpackBody.func_78792_a(this.backpackPouch1);
        this.backpackBody.func_78792_a(this.backpackPouch2);
        this.recreate();
    }

    public void addTrapezoidBox(ModelRenderer model, int textureOffsetX, int textureOffsetY, float x, float y, float z, float w, float h, float d, float sides, float top, float bottom, int wi, int hi, int di) {
        model.field_78804_l.add(new ModelTrapezoid(model, textureOffsetX, textureOffsetY, x, y, z, w, h, d, 0.0f, sides, top, bottom, wi, hi, di));
    }

    public void recreate() {
        this.field_78090_t = 64;
        this.field_78089_u = 64;
        this.backpackBody = new ModelRenderer((ModelBase)this, 32, 0);
        this.backpackBody.func_78789_a(-6.0f, -10.0f, 8.0f, 12, 18, 4);
        this.backpackBody.func_78793_a(0.0f, 12.0f, -4.0f);
        this.setRotation(this.backpackBody, 0.0f, 0.0f, 0.0f);
        this.backpackPouch1 = new ModelRenderer((ModelBase)this, 0, 24);
        this.addTrapezoidBox(this.backpackPouch1, 0, 24, -5.5f, -1.5f, 12.0f, 11.0f, 9.2f, 1.5f, 0.5f, 1.5f, 0.2f, 10, 8, 4);
        this.backpackPouch2 = new ModelRenderer((ModelBase)this, 0, 42);
        this.addTrapezoidBox(this.backpackPouch2, 0, 42, -4.0f, 1.0f, 13.5f, 8.0f, 6.3f, 1.5f, 1.5f, 2.5f, 0.5f, 8, 6, 4);
        this.backpackClasp = new ModelRenderer((ModelBase)this, 0, 0);
        this.backpackClasp.func_78789_a(-1.0f, -5.5f, 12.0f, 2, 2, 2);
        this.backpackHood = new ModelRenderer((ModelBase)this, 0, 10);
        this.addTrapezoidBox(this.backpackHood, 0, 10, -5.0f, -8.5f, 12.0f, 10.0f, 6.0f, 1.5f, 1.0f, 1.5f, 4.5f, 10, 6, 2);
        this.backpackBody.func_78792_a(this.backpackClasp);
        this.backpackBody.func_78792_a(this.backpackHood);
        this.backpackBody.func_78792_a(this.backpackPouch1);
        this.backpackBody.func_78792_a(this.backpackPouch2);
    }

    public void render(EntityPlayer player, float par7) {
        int type = BackpackChecker.getBackpackType(player);
        if (type == -1 || this.biped == null) {
            return;
        }
        if (type >= textures.length) {
            type = 0;
        }
        if (type == 16 && Common.animatedQuantumBackpacks) {
            int time = (int)(Minecraft.func_71386_F() % 3400L);
            int t = time < 1700 ? (time < 1000 ? time % 500 / 100 : 5 + (time - 1000) / 100) : (time < 2700 ? 12 + (time - 1700) % 500 / 100 : 11 - (time - 2700) / 100);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(animatedTextures[t]);
        } else {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(textures[type]);
        }
        this.setRotationAngles();
        GL11.glPushMatrix();
        if (this.biped.field_78117_n) {
            if (player.func_82169_q(2) != null) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.274f);
            } else {
                GL11.glTranslatef((float)0.0f, (float)0.04f, (float)0.2f);
            }
        } else if (player.func_82169_q(2) != null) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.074f);
        }
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        this.backpackBody.func_78785_a(par7);
        GL11.glPopMatrix();
    }

    public void render(int type, float par7) {
        if (type == -1) {
            return;
        }
        if (type >= textures.length) {
            type = 0;
        }
        if (type == 16 && Common.animatedQuantumBackpacks) {
            int time = (int)(Minecraft.func_71386_F() % 3400L);
            int t = time < 1700 ? (time < 1000 ? time % 500 / 100 : 5 + (time - 1000) / 100) : (time < 2700 ? 12 + (time - 1700) % 500 / 100 : 11 - (time - 2700) / 100);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(animatedTextures[t]);
        } else {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(textures[type]);
        }
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        this.backpackBody.func_78785_a(par7);
        GL11.glPopMatrix();
    }

    public void setRotationAngles() {
        if (this.biped == null) {
            return;
        }
        this.backpackBody.field_78795_f = this.biped.field_78115_e.field_78795_f;
        this.backpackBody.field_78796_g = this.biped.field_78115_e.field_78796_g;
        this.backpackBody.field_78808_h = this.biped.field_78115_e.field_78808_h;
    }

    static {
        int i;
        textures = new ResourceLocation[17];
        for (i = 0; i < 16; ++i) {
            ModelBackpack.textures[i] = new ResourceLocation("backpacks16840", "textures/models/backpack." + Backpack.colors[i] + ".png");
        }
        ModelBackpack.textures[16] = new ResourceLocation("backpacks16840", "textures/models/quantum_backpack.png");
        animatedTextures = new ResourceLocation[17];
        for (i = 0; i < 17; ++i) {
            ModelBackpack.animatedTextures[i] = new ResourceLocation("backpacks16840", "textures/models/quantum_backpack.animated." + (i + 1) + ".png");
        }
        instances = new WeakHashMap();
    }
}

