/*
 * Decompiled with CFR 0.152.
 */
package brad16840.backpacks.gui;

import brad16840.backpacks.gui.BackpackContainer;
import brad16840.backpacks.items.Backpack;
import brad16840.common.Common;
import brad16840.common.ContainerStack;
import brad16840.common.StackableContainer;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import brad16840.common.UniqueItemInventory;
import brad16840.common.gui.EmptyRestorerView;
import brad16840.common.gui.RestorerContainer;
import brad16840.common.permissions.PacketHandler;
import brad16840.common.permissions.gui.ClientState;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.opengl.GL11;

public class BackpackView
extends StackableContainer.SimpleContainer {
    private UniqueItemInventory inventory;
    private String id;
    private String name = "???";
    private int width;
    private int height;
    private int playerInventorySlot;
    private boolean standalone;

    public int getOffset() {
        int i = this.guiHeight - (24 + this.height * 18) - (this.standalone ? 22 : 0);
        return i > 0 ? i : 0;
    }

    public BackpackView(int width, int height, UniqueItemInventory inventory, int playerInventorySlot) {
        super(14 + width * 18, 127);
        this.inventory = inventory;
        this.id = inventory.getIdentifier();
        this.idChain = new ArrayList();
        this.width = width;
        this.height = height;
        this.playerInventorySlot = playerInventorySlot;
    }

    private boolean closeContainer(EntityPlayer player) {
        if (this.container.stacks.length > 1 && this.container.getContainer(1) instanceof RestorerContainer) {
            boolean navigating;
            boolean bl = navigating = this.container.chainOrder.size() > 0 && this.container.chainOrder.get(this.container.chainOrder.size() - 1) != null;
            if (!navigating) {
                ((RestorerContainer)this.container.getContainer((int)1)).selectedStack = -1;
                this.container.replaceContainer(player, this.stackId, new EmptyRestorerView());
                this.container.reupdateContainers = true;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean initContainer(EntityPlayer player) {
        int cachedStackId = this.stackId;
        UniqueItemData data = UniqueItemData.get(player.field_70170_p);
        NBTTagCompound tag = data.getItemData(player, this.id);
        if (tag == null) {
            UniqueItemData.permissionError("view", Backpack.name).log(player);
            return this.closeContainer(player);
        }
        if (this.inventory == null) {
            this.inventory = UniqueItemInventory.createInventory(Common.backpack, player, this.id);
        }
        if (this.inventory == null) {
            new Translatable("problem.backpack404", new Object[0]).log(player);
            return this.closeContainer(player);
        }
        this.inventory.refreshInventory();
        if (tag.func_74764_b("custom-name")) {
            this.name = tag.func_74779_i("custom-name");
        } else {
            int color = tag.func_74762_e("color");
            if (!tag.func_74764_b("color")) {
                color = 3;
            }
            this.name = new ItemStack((Item)Common.backpack, 1, color).func_82833_r();
        }
        this.width = Backpack.getBackpackSize(player.field_70170_p, tag, this.id, true);
        this.height = Backpack.getBackpackSize(player.field_70170_p, tag, this.id, false);
        this.standalone = this.container.stacks.length < 2 || !(this.container.getContainer(1) instanceof RestorerContainer);
        int h = Math.max(24 + this.height * 18 + 22 + (this.standalone ? 22 : 0), 149 - (this.standalone ? 0 : 22));
        if (this.guiWidth != 14 + this.width * 18 || this.guiHeight != h) {
            this.guiWidth = 14 + this.width * 18;
            this.guiHeight = h;
            this.container.reupdateContainers = true;
            return true;
        }
        this.stackId = cachedStackId;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.addSlotToContainer(ContainerStack.ContainerSection.CHEST, new UpgradeSlot(player, (IInventory)this.inventory, x + y * this.width, 8 + x * 18, 18 + y * 18 + this.getOffset()));
            }
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initButtons() {
        final int cachedStackId = this.stackId;
        if (this.standalone) {
            this.gui.addButton(new StackableContainer.ContainerButton(0, 0, this.guiHeight - 20, this.guiWidth, 20, this.gui.getBackButtonText(this), new ContainerStack.Callback(){

                @Override
                public void call() {
                    BackpackView.this.gui.closeContainer(cachedStackId);
                }
            }, 68));
        }
    }

    @Override
    public boolean static_refreshInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
        for (StackableContainer container1 : containers) {
            if (((BackpackView)container1).inventory == null) {
                return false;
            }
            ((BackpackView)container1).inventory.refreshInventory();
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForeground(int mouseX, int mouseY) {
        this.gui.text(this, this.name).truncateString(this.guiWidth - 16).drawString(8, 6 + this.getOffset(), -12566464);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.bindTexture(BackpackContainer.texture);
        int xCovered = 0;
        for (int x = 0; x < this.width; ++x) {
            int offsetX = x == 0 ? 0 : (x == this.width - 1 ? 43 : 25);
            int w = x == 0 || x == this.width - 1 ? 25 : 18;
            int yCovered = 0;
            for (int y = 0; y < this.height; ++y) {
                int offsetY;
                int n = y == 0 ? 0 : (offsetY = y == this.height - 1 ? 53 : 35);
                int h = y == 0 ? 35 : (y == this.height - 1 ? 25 : 18);
                this.gui.drawTexture(this, xCovered, yCovered + this.getOffset(), w, h, offsetX, offsetY);
                yCovered += h;
            }
            xCovered += w;
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseDown(int x, int y, int button) {
        ItemStack stack;
        boolean clicked = button == 0 || button == 1 || button == Minecraft.func_71410_x().field_71474_y.field_74322_I.func_151463_i() + 100;
        if (clicked && (y -= this.getOffset()) >= 18 && y < 18 + 18 * this.height && x >= 8 && x < 8 + 18 * this.width && (stack = this.inventory.func_70301_a((y - 18) / 18 * this.width + (x - 8) / 18)) != null && stack.func_77973_b() instanceof UniqueItem.ViewableItem) {
            String uuid = UniqueItem.getIdentifier(stack);
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            UniqueItemData data = UniqueItemData.get(player.field_70170_p);
            if (!data.isSubscribed(uuid) || data.getItemData((EntityPlayer)player, uuid) == null) {
                UniqueItemData.permissionError("view", UniqueItemData.genericItem).log((EntityPlayer)player);
                return true;
            }
            RestorerContainer.createView((EntityPlayer)player, ((UniqueItem.ContainerItem)stack.func_77973_b()).getContainerItemType(), uuid, false, false, true, this.playerInventorySlot);
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(char key, int keyCode) {
        if (keyCode == Common.permissionKey.func_151463_i()) {
            String id = this.getId();
            Common.channel.sendToServer(new PacketHandler.OpenGroup(0, new ClientState.PermissionGroupState(id, "I_" + id, 0, true), true));
            return true;
        }
        return false;
    }

    @Override
    public boolean customRightClick(EntityPlayer player, int slot, boolean holdingShift) {
        return false;
    }

    @Override
    public int getSlotCount() {
        return this.width * this.height;
    }

    @Override
    public int getRowSize() {
        return this.width;
    }

    private class UpgradeSlot
    extends StackableContainer.ContainerSlot {
        public UpgradeSlot(EntityPlayer player, IInventory inventory, int par2, int par3, int par4) {
            super(player, inventory, par2, par3, par4);
        }

        @Override
        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        @Override
        public boolean func_82869_a(EntityPlayer player) {
            return false;
        }
    }
}

