/*
 * Decompiled with CFR 0.152.
 */
package travellersgear.common.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import travellersgear.TravellersGear;
import travellersgear.common.network.MessageNBTSync;

public class MessageRequestNBTSync
implements IMessage {
    int worldId;
    int playerId;
    int requestWorldId;
    int requestPlayerId;

    public MessageRequestNBTSync() {
    }

    public MessageRequestNBTSync(EntityPlayer player, EntityPlayer requester) {
        this.worldId = player.field_71093_bK;
        this.playerId = player.func_145782_y();
        this.requestWorldId = requester.field_71093_bK;
        this.requestPlayerId = requester.func_145782_y();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.worldId);
        buf.writeInt(this.playerId);
        buf.writeInt(this.requestWorldId);
        buf.writeInt(this.requestPlayerId);
    }

    public void fromBytes(ByteBuf buf) {
        this.worldId = buf.readInt();
        this.playerId = buf.readInt();
        this.requestWorldId = buf.readInt();
        this.requestPlayerId = buf.readInt();
    }

    public static class HandlerServer
    implements IMessageHandler<MessageRequestNBTSync, IMessage> {
        public IMessage onMessage(MessageRequestNBTSync message, MessageContext ctx) {
            WorldServer world = DimensionManager.getWorld((int)message.worldId);
            if (world == null) {
                return null;
            }
            Entity player = world.func_73045_a(message.playerId);
            if (player == null || !(player instanceof EntityPlayer)) {
                return null;
            }
            WorldServer worldR = DimensionManager.getWorld((int)message.requestWorldId);
            if (worldR == null) {
                return null;
            }
            Entity playerR = worldR.func_73045_a(message.requestPlayerId);
            if (playerR == null || !(playerR instanceof EntityPlayerMP)) {
                return null;
            }
            TravellersGear.packetHandler.sendTo((IMessage)new MessageNBTSync((EntityPlayer)player), (EntityPlayerMP)playerR);
            return null;
        }
    }
}

