/*
 * Decompiled with CFR 0.152.
 */
package tb.common.entity;

import DummyCore.Utils.Pair;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import tb.api.RevolverUpgrade;
import tb.common.item.ItemRevolver;
import thaumcraft.common.Thaumcraft;

public class EntityRevolverBullet
extends EntityThrowable {
    public Entity shooter;
    public ItemStack revolver;
    ArrayList<Pair<RevolverUpgrade, Integer>> upgrades;
    boolean isPrimal;

    public EntityRevolverBullet(World w) {
        super(w);
    }

    public EntityRevolverBullet(World w, EntityLivingBase shooter) {
        super(w, shooter);
        this.revolver = shooter.func_70694_bm();
        this.shooter = shooter;
        if (this.revolver != null && this.revolver.func_77973_b() instanceof ItemRevolver) {
            this.upgrades = ItemRevolver.getAllUpgradesFor(this.revolver);
            boolean allowNoclip = false;
            float speedIndex = 1.0f;
            for (Pair<RevolverUpgrade, Integer> p : this.upgrades) {
                if (!allowNoclip) {
                    allowNoclip = ((RevolverUpgrade)p.getFirst()).bulletNoclip((EntityPlayer)shooter, this.revolver, (Integer)p.getSecond());
                }
                speedIndex = (float)((RevolverUpgrade)p.getFirst()).modifySpeed((EntityPlayer)shooter, this.revolver, speedIndex, (Integer)p.getSecond());
                if (p.getFirst() != RevolverUpgrade.primal) continue;
                this.isPrimal = true;
            }
            if (allowNoclip) {
                this.field_70145_X = true;
            }
            this.field_70159_w *= 3.0;
            this.field_70181_x *= 3.0;
            this.field_70179_y *= 3.0;
            this.field_70159_w *= (double)speedIndex;
            this.field_70181_x *= (double)speedIndex;
            this.field_70179_y *= (double)speedIndex;
        }
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            Thaumcraft.proxy.sparkle((float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v, 4);
        }
        if (this.field_70170_p.field_72995_K) {
            Thaumcraft.proxy.sparkle((float)(this.field_70165_t - this.field_70159_w / 20.0), (float)(this.field_70163_u - this.field_70181_x / 20.0), (float)(this.field_70161_v - this.field_70179_y / 20.0), 4);
        }
        if (this.field_70173_aa >= 200) {
            this.func_70106_y();
        }
        super.func_70071_h_();
        if (this.isPrimal && !this.field_70128_L) {
            ++this.field_70173_aa;
            this.func_70071_h_();
        }
    }

    protected float func_70185_h() {
        return this.isPrimal ? 0.0f : 0.01f;
    }

    protected void func_70184_a(MovingObjectPosition object) {
        Entity e;
        if (this.field_70128_L) {
            return;
        }
        if (!this.field_70170_p.field_72995_K && object.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            if (this.field_70145_X) {
                return;
            }
            if (this.field_70170_p.func_147445_c(object.field_72311_b, object.field_72312_c, object.field_72309_d, true)) {
                this.func_70106_y();
            } else {
                Block b = this.field_70170_p.func_147439_a(object.field_72311_b, object.field_72312_c, object.field_72309_d);
                int meta = this.field_70170_p.func_72805_g(object.field_72311_b, object.field_72312_c, object.field_72309_d);
                for (int i = 0; i < 100; ++i) {
                    this.field_70170_p.func_72869_a("blockcrack_" + Block.func_149682_b((Block)b) + "_" + meta, (double)object.field_72311_b + this.field_70170_p.field_73012_v.nextDouble(), (double)object.field_72312_c + this.field_70170_p.field_73012_v.nextDouble(), (double)object.field_72309_d + this.field_70170_p.field_73012_v.nextDouble(), 0.0, 0.0, 0.0);
                }
                this.field_70170_p.func_72980_b((double)object.field_72311_b + 0.5, (double)object.field_72312_c + 0.5, (double)object.field_72309_d + 0.5, b.field_149762_H.func_150495_a(), 1.0f, 1.0f, false);
                this.field_70170_p.func_147468_f(object.field_72311_b, object.field_72312_c, object.field_72309_d);
            }
        }
        if (object.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && (e = object.field_72308_g) instanceof EntityLivingBase && e != this.shooter && !(e instanceof EntityRevolverBullet)) {
            EntityLivingBase elb = (EntityLivingBase)e;
            float initialDamage = 14.0f;
            for (Pair<RevolverUpgrade, Integer> p : this.upgrades) {
                initialDamage = ((RevolverUpgrade)p.getFirst()).modifyDamage_start(elb, this.revolver, initialDamage, (Integer)p.getSecond());
            }
            for (Pair<RevolverUpgrade, Integer> p : this.upgrades) {
                initialDamage = ((RevolverUpgrade)p.getFirst()).modifyDamage_end(elb, this.revolver, initialDamage, (Integer)p.getSecond());
            }
            elb.func_70097_a((DamageSource)new RevolverDamage("revolver"), initialDamage);
            boolean destroy = true;
            for (Pair<RevolverUpgrade, Integer> p : this.upgrades) {
                if (destroy) {
                    destroy = ((RevolverUpgrade)p.getFirst()).afterhit(elb, (EntityPlayer)this.shooter, this.revolver, initialDamage, (Integer)p.getSecond());
                    continue;
                }
                ((RevolverUpgrade)p.getFirst()).afterhit(elb, (EntityPlayer)this.shooter, this.revolver, initialDamage, (Integer)p.getSecond());
            }
            if (destroy) {
                this.func_70106_y();
            }
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        if (this.revolver != null) {
            NBTTagCompound revolverTag = new NBTTagCompound();
            this.revolver.func_77955_b(revolverTag);
            tag.func_74782_a("revolverTag", (NBTBase)revolverTag);
        }
        tag.func_74757_a("noclip", this.field_70145_X);
        tag.func_74757_a("primal", this.isPrimal);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("revolverTag")) {
            this.revolver = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("revolverTag"));
            this.upgrades = ItemRevolver.getAllUpgradesFor(this.revolver);
        }
        this.field_70145_X = tag.func_74767_n("noclip");
        this.isPrimal = tag.func_74767_n("primal");
    }

    public static class RevolverDamage
    extends DamageSource {
        public RevolverDamage(String damage) {
            super(damage);
        }
    }
}

