/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.crafting;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.InfusionEnchantmentRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;
import thaumcraft.common.config.Config;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.research.ResearchManager;
import thaumcraft.common.lib.utils.Utils;

public class ThaumcraftCraftingManager {
    private static final ThreadLocal<Integer> GENERATE_TAGS_CALLS_COUNTER = new ThreadLocal();

    public static ShapedRecipes createFakeRecipe(ItemStack par1ItemStack, Object ... par2ArrayOfObj) {
        StringBuilder var3 = new StringBuilder();
        int var4 = 0;
        int var5 = 0;
        int var6 = 0;
        if (par2ArrayOfObj[var4] instanceof String[]) {
            String[] var7;
            for (String var11 : var7 = (String[])par2ArrayOfObj[var4++]) {
                ++var6;
                var5 = var11.length();
                var3.append(var11);
            }
        } else {
            while (par2ArrayOfObj[var4] instanceof String) {
                String var13 = (String)par2ArrayOfObj[var4++];
                ++var6;
                var5 = var13.length();
                var3.append(var13);
            }
        }
        HashMap<Character, ItemStack> var14 = new HashMap<Character, ItemStack>();
        while (var4 < par2ArrayOfObj.length) {
            Character var16 = (Character)par2ArrayOfObj[var4];
            ItemStack var17 = null;
            if (par2ArrayOfObj[var4 + 1] instanceof Item) {
                var17 = new ItemStack((Item)par2ArrayOfObj[var4 + 1]);
            } else if (par2ArrayOfObj[var4 + 1] instanceof Block) {
                var17 = new ItemStack((Block)par2ArrayOfObj[var4 + 1]);
            } else if (par2ArrayOfObj[var4 + 1] instanceof ItemStack) {
                var17 = (ItemStack)par2ArrayOfObj[var4 + 1];
            }
            var14.put(var16, var17);
            var4 += 2;
        }
        ItemStack[] var15 = new ItemStack[var5 * var6];
        for (int var9 = 0; var9 < var5 * var6; ++var9) {
            char var18 = var3.charAt(var9);
            var15[var9] = var14.containsKey(Character.valueOf(var18)) ? ((ItemStack)var14.get(Character.valueOf(var18))).func_77946_l() : null;
        }
        return new ShapedRecipes(var5, var6, var15, par1ItemStack);
    }

    public static CrucibleRecipe findMatchingCrucibleRecipe(String username, AspectList aspects, ItemStack lastDrop) {
        int highest = 0;
        int index = -1;
        for (int a = 0; a < ThaumcraftApi.getCraftingRecipes().size(); ++a) {
            int result;
            if (!(ThaumcraftApi.getCraftingRecipes().get(a) instanceof CrucibleRecipe)) continue;
            CrucibleRecipe recipe = (CrucibleRecipe)ThaumcraftApi.getCraftingRecipes().get(a);
            ItemStack temp = lastDrop.func_77946_l();
            temp.field_77994_a = 1;
            if (!ResearchManager.isResearchComplete(username, recipe.key) || !recipe.matches(aspects, temp) || (result = recipe.aspects.size()) <= highest) continue;
            highest = result;
            index = a;
        }
        if (index < 0) {
            return null;
        }
        new AspectList();
        return (CrucibleRecipe)ThaumcraftApi.getCraftingRecipes().get(index);
    }

    public static ItemStack findMatchingArcaneRecipe(IInventory awb, EntityPlayer player) {
        int var2 = 0;
        Object var3 = null;
        Object var4 = null;
        for (int var5 = 0; var5 < 9; ++var5) {
            ItemStack var6 = awb.func_70301_a(var5);
            if (var6 == null) continue;
            if (var2 == 0) {
                // empty if block
            }
            if (var2 == 1) {
                // empty if block
            }
            ++var2;
        }
        IArcaneRecipe var13 = null;
        for (Object var11 : ThaumcraftApi.getCraftingRecipes()) {
            if (!(var11 instanceof IArcaneRecipe) || !((IArcaneRecipe)var11).matches(awb, player.field_70170_p, player)) continue;
            var13 = (IArcaneRecipe)var11;
            break;
        }
        return var13 == null ? null : var13.getCraftingResult(awb);
    }

    public static AspectList findMatchingArcaneRecipeAspects(IInventory awb, EntityPlayer player) {
        int var2 = 0;
        Object var3 = null;
        Object var4 = null;
        for (int var5 = 0; var5 < 9; ++var5) {
            ItemStack var6 = awb.func_70301_a(var5);
            if (var6 == null) continue;
            if (var2 == 0) {
                // empty if block
            }
            if (var2 == 1) {
                // empty if block
            }
            ++var2;
        }
        IArcaneRecipe var13 = null;
        for (Object var11 : ThaumcraftApi.getCraftingRecipes()) {
            if (!(var11 instanceof IArcaneRecipe) || !((IArcaneRecipe)var11).matches(awb, player.field_70170_p, player)) continue;
            var13 = (IArcaneRecipe)var11;
            break;
        }
        return var13 == null ? new AspectList() : (var13.getAspects() != null ? var13.getAspects() : var13.getAspects(awb));
    }

    public static InfusionRecipe findMatchingInfusionRecipe(ArrayList<ItemStack> items, ItemStack input, EntityPlayer player) {
        InfusionRecipe recipe = null;
        for (Object o : ThaumcraftApi.getCraftingRecipes()) {
            if (!(o instanceof InfusionRecipe) || !((InfusionRecipe)o).matches(items, input, player.field_70170_p, player)) continue;
            recipe = (InfusionRecipe)o;
            break;
        }
        return recipe;
    }

    public static InfusionEnchantmentRecipe findMatchingInfusionEnchantmentRecipe(ArrayList<ItemStack> items, ItemStack input, EntityPlayer player) {
        InfusionEnchantmentRecipe var13 = null;
        for (Object var11 : ThaumcraftApi.getCraftingRecipes()) {
            if (!(var11 instanceof InfusionEnchantmentRecipe) || !((InfusionEnchantmentRecipe)var11).matches(items, input, player.field_70170_p, player)) continue;
            var13 = (InfusionEnchantmentRecipe)var11;
            break;
        }
        return var13;
    }

    public static AspectList getObjectTags(ItemStack stack) {
        int meta;
        Item item;
        try {
            item = stack.func_77973_b();
            if (item == null) {
                return null;
            }
            meta = stack.func_77960_j();
        }
        catch (Exception e) {
            return null;
        }
        AspectList tmp = ThaumcraftApi.objectTags.get(Arrays.asList(item, meta));
        if (tmp == null) {
            for (List key : ThaumcraftApi.objectTags.keySet()) {
                if (key.get(0) != item || !(key.get(1) instanceof int[])) continue;
                int[] range = (int[])key.get(1);
                Arrays.sort(range);
                if (Arrays.binarySearch(range, meta) < 0) continue;
                return ThaumcraftApi.objectTags.get(key);
            }
            tmp = ThaumcraftApi.objectTags.get(Arrays.asList(item, Short.MAX_VALUE));
            if (tmp == null && tmp == null) {
                if (meta == Short.MAX_VALUE && tmp == null) {
                    int index = 0;
                    do {
                        tmp = ThaumcraftApi.objectTags.get(Arrays.asList(item, index));
                    } while (++index < 16 && tmp == null);
                }
                if (tmp == null) {
                    tmp = ThaumcraftCraftingManager.generateTags(item, meta);
                }
            }
        }
        if (item instanceof ItemWandCasting) {
            ItemWandCasting wand = (ItemWandCasting)item;
            if (tmp == null) {
                tmp = new AspectList();
            }
            tmp.merge(Aspect.MAGIC, (wand.getRod(stack).getCraftCost() + wand.getCap(stack).getCraftCost()) / 2);
            tmp.merge(Aspect.TOOL, (wand.getRod(stack).getCraftCost() + wand.getCap(stack).getCraftCost()) / 3);
        }
        if (item == Items.field_151068_bn && item instanceof ItemPotion) {
            if (tmp == null) {
                tmp = new AspectList();
            }
            tmp.merge(Aspect.WATER, 1);
            ItemPotion ip = (ItemPotion)item;
            List effects = ip.func_77834_f(stack.func_77960_j());
            if (effects != null) {
                if (ItemPotion.func_77831_g((int)stack.func_77960_j())) {
                    tmp.merge(Aspect.ENTROPY, 2);
                }
                for (PotionEffect var6 : effects) {
                    tmp.merge(Aspect.MAGIC, (var6.func_76458_c() + 1) * 2);
                    if (var6.func_76456_a() == Potion.field_76440_q.field_76415_H) {
                        tmp.merge(Aspect.DARKNESS, (var6.func_76458_c() + 1) * 3);
                        continue;
                    }
                    if (var6.func_76456_a() == Potion.field_76431_k.field_76415_H) {
                        tmp.merge(Aspect.ELDRITCH, (var6.func_76458_c() + 1) * 3);
                        continue;
                    }
                    if (var6.func_76456_a() == Potion.field_76420_g.field_76415_H) {
                        tmp.merge(Aspect.WEAPON, (var6.func_76458_c() + 1) * 3);
                        continue;
                    }
                    if (var6.func_76456_a() == Potion.field_76419_f.field_76415_H) {
                        tmp.merge(Aspect.TRAP, (var6.func_76458_c() + 1) * 3);
                        continue;
                    }
                    if (var6.func_76456_a() == Potion.field_76422_e.field_76415_H) {
                        tmp.merge(Aspect.TOOL, (var6.func_76458_c() + 1) * 3);
                        continue;
                    }
                    if (var6.func_76456_a() == Potion.field_76426_n.field_76415_H) {
                        tmp.merge(Aspect.ARMOR, var6.func_76458_c() + 1);
                        tmp.merge(Aspect.FIRE, (var6.func_76458_c() + 1) * 2);
                        continue;
                    }
                    if (var6.func_76456_a() == Potion.field_76433_i.field_76415_H) {
                        tmp.merge(Aspect.DEATH, (var6.func_76458_c() + 1) * 3);
                        continue;
                    }
                    if (var6.func_76456_a() == Potion.field_76432_h.field_76415_H) {
                        tmp.merge(Aspect.HEAL, (var6.func_76458_c() + 1) * 3);
                        continue;
                    }
                    if (var6.func_76456_a() == Potion.field_76438_s.field_76415_H) {
                        tmp.merge(Aspect.DEATH, (var6.func_76458_c() + 1) * 3);
                        continue;
                    }
                    if (var6.func_76456_a() == Potion.field_76441_p.field_76415_H) {
                        tmp.merge(Aspect.SENSES, (var6.func_76458_c() + 1) * 3);
                        continue;
                    }
                    if (var6.func_76456_a() == Potion.field_76430_j.field_76415_H) {
                        tmp.merge(Aspect.FLIGHT, (var6.func_76458_c() + 1) * 3);
                        continue;
                    }
                    if (var6.func_76456_a() == Potion.field_76421_d.field_76415_H) {
                        tmp.merge(Aspect.TRAP, (var6.func_76458_c() + 1) * 3);
                        continue;
                    }
                    if (var6.func_76456_a() == Potion.field_76424_c.field_76415_H) {
                        tmp.merge(Aspect.MOTION, (var6.func_76458_c() + 1) * 3);
                        continue;
                    }
                    if (var6.func_76456_a() == Potion.field_76439_r.field_76415_H) {
                        tmp.merge(Aspect.SENSES, (var6.func_76458_c() + 1) * 3);
                        continue;
                    }
                    if (var6.func_76456_a() == Potion.field_76436_u.field_76415_H) {
                        tmp.merge(Aspect.POISON, (var6.func_76458_c() + 1) * 3);
                        continue;
                    }
                    if (var6.func_76456_a() == Potion.field_76428_l.field_76415_H) {
                        tmp.merge(Aspect.HEAL, (var6.func_76458_c() + 1) * 3);
                        continue;
                    }
                    if (var6.func_76456_a() == Potion.field_76429_m.field_76415_H) {
                        tmp.merge(Aspect.ARMOR, (var6.func_76458_c() + 1) * 3);
                        continue;
                    }
                    if (var6.func_76456_a() == Potion.field_76427_o.field_76415_H) {
                        tmp.merge(Aspect.AIR, (var6.func_76458_c() + 1) * 3);
                        continue;
                    }
                    if (var6.func_76456_a() != Potion.field_76437_t.field_76415_H) continue;
                    tmp.merge(Aspect.DEATH, (var6.func_76458_c() + 1) * 3);
                }
            }
        }
        return ThaumcraftCraftingManager.capAspects(tmp, 64);
    }

    private static AspectList capAspects(AspectList sourcetags, int amount) {
        if (sourcetags == null) {
            return null;
        }
        AspectList out = new AspectList();
        for (Aspect aspect : sourcetags.getAspects()) {
            out.merge(aspect, Math.min(amount, sourcetags.getAmount(aspect)));
        }
        return out;
    }

    public static AspectList getBonusTags(ItemStack stack, AspectList sourcetags) {
        AspectList tmp = new AspectList();
        Item item = stack.func_77973_b();
        if (item == null) {
            return new AspectList();
        }
        if (item instanceof IEssentiaContainerItem && (tmp = ((IEssentiaContainerItem)item).getAspects(stack)) != null && tmp.size() > 0) {
            for (Aspect tag : tmp.copy().getAspects()) {
                if (tmp.getAmount(tag) > 0) continue;
                tmp.remove(tag);
            }
        }
        if (tmp == null) {
            tmp = new AspectList();
        }
        if (sourcetags != null) {
            for (Aspect tag : sourcetags.getAspects()) {
                if (tag == null) continue;
                tmp.add(tag, sourcetags.getAmount(tag));
            }
        }
        if (item != null && (tmp != null || item == Items.field_151068_bn)) {
            String mat;
            if (item instanceof ItemArmor) {
                tmp.merge(Aspect.ARMOR, ((ItemArmor)item).field_77879_b);
            } else if (item instanceof ItemSword && ((ItemSword)item).func_150931_i() + 1.0f > 0.0f) {
                tmp.merge(Aspect.WEAPON, (int)(((ItemSword)item).func_150931_i() + 1.0f));
            } else if (item instanceof ItemBow) {
                tmp.merge(Aspect.WEAPON, 3).merge(Aspect.FLIGHT, 1);
            } else if (item instanceof ItemPickaxe) {
                mat = ((ItemTool)item).func_77861_e();
                for (Item.ToolMaterial tm : Item.ToolMaterial.values()) {
                    if (!tm.toString().equals(mat)) continue;
                    tmp.merge(Aspect.MINE, tm.func_77996_d() + 1);
                }
            } else if (item instanceof ItemTool) {
                mat = ((ItemTool)item).func_77861_e();
                for (Item.ToolMaterial tm : Item.ToolMaterial.values()) {
                    if (!tm.toString().equals(mat)) continue;
                    tmp.merge(Aspect.TOOL, tm.func_77996_d() + 1);
                }
            } else if (item instanceof ItemShears || item instanceof ItemHoe) {
                if (item.func_77612_l() <= Item.ToolMaterial.WOOD.func_77997_a()) {
                    tmp.merge(Aspect.HARVEST, 1);
                } else if (item.func_77612_l() > Item.ToolMaterial.STONE.func_77997_a() && item.func_77612_l() > Item.ToolMaterial.GOLD.func_77997_a()) {
                    if (item.func_77612_l() <= Item.ToolMaterial.IRON.func_77997_a()) {
                        tmp.merge(Aspect.HARVEST, 3);
                    } else {
                        tmp.merge(Aspect.HARVEST, 4);
                    }
                } else {
                    tmp.merge(Aspect.HARVEST, 2);
                }
            }
            NBTTagList ench = stack.func_77986_q();
            if (item instanceof ItemEnchantedBook) {
                ench = ((ItemEnchantedBook)item).func_92110_g(stack);
            }
            if (ench != null) {
                int var5 = 0;
                for (int var3 = 0; var3 < ench.func_74745_c(); ++var3) {
                    short eid = ench.func_150305_b(var3).func_74765_d("id");
                    short lvl = ench.func_150305_b(var3).func_74765_d("lvl");
                    if (eid == Enchantment.field_77341_i.field_77352_x) {
                        tmp.merge(Aspect.WATER, lvl);
                    } else if (eid == Enchantment.field_77336_l.field_77352_x) {
                        tmp.merge(Aspect.BEAST, lvl);
                    } else if (eid == Enchantment.field_77327_f.field_77352_x) {
                        tmp.merge(Aspect.ARMOR, lvl);
                    } else if (eid == Enchantment.field_77349_p.field_77352_x) {
                        tmp.merge(Aspect.TOOL, lvl);
                    } else if (eid == Enchantment.field_77330_e.field_77352_x) {
                        tmp.merge(Aspect.FLIGHT, lvl);
                    } else if (eid == Enchantment.field_77334_n.field_77352_x) {
                        tmp.merge(Aspect.FIRE, lvl);
                    } else if (eid == Enchantment.field_77329_d.field_77352_x) {
                        tmp.merge(Aspect.ARMOR, lvl);
                    } else if (eid == Enchantment.field_77343_v.field_77352_x) {
                        tmp.merge(Aspect.FIRE, lvl);
                    } else if (eid == Enchantment.field_77346_s.field_77352_x) {
                        tmp.merge(Aspect.GREED, lvl);
                    } else if (eid == Enchantment.field_77342_w.field_77352_x) {
                        tmp.merge(Aspect.CRAFT, lvl);
                    } else if (eid == Enchantment.field_77337_m.field_77352_x) {
                        tmp.merge(Aspect.AIR, lvl);
                    } else if (eid == Enchantment.field_77335_o.field_77352_x) {
                        tmp.merge(Aspect.GREED, lvl);
                    } else if (eid == Enchantment.field_77345_t.field_77352_x) {
                        tmp.merge(Aspect.WEAPON, lvl);
                    } else if (eid == Enchantment.field_77328_g.field_77352_x) {
                        tmp.merge(Aspect.ARMOR, lvl);
                    } else if (eid == Enchantment.field_77332_c.field_77352_x) {
                        tmp.merge(Aspect.ARMOR, lvl);
                    } else if (eid == Enchantment.field_77344_u.field_77352_x) {
                        tmp.merge(Aspect.AIR, lvl);
                    } else if (eid == Enchantment.field_77340_h.field_77352_x) {
                        tmp.merge(Aspect.AIR, lvl);
                    } else if (eid == Enchantment.field_77338_j.field_77352_x) {
                        tmp.merge(Aspect.WEAPON, lvl);
                    } else if (eid == Enchantment.field_77348_q.field_77352_x) {
                        tmp.merge(Aspect.EXCHANGE, lvl);
                    } else if (eid == Enchantment.field_92091_k.field_77352_x) {
                        tmp.merge(Aspect.WEAPON, lvl);
                    } else if (eid == Enchantment.field_77339_k.field_77352_x) {
                        tmp.merge(Aspect.ENTROPY, lvl);
                    } else if (eid == Enchantment.field_77347_r.field_77352_x) {
                        tmp.merge(Aspect.EARTH, lvl);
                    } else if (eid == Enchantment.field_151370_z.field_77352_x) {
                        tmp.merge(Aspect.GREED, lvl);
                    } else if (eid == Enchantment.field_151369_A.field_77352_x) {
                        tmp.merge(Aspect.BEAST, lvl);
                    } else if (eid == Config.enchHaste.field_77352_x) {
                        tmp.merge(Aspect.MOTION, lvl);
                    } else if (eid == Config.enchRepair.field_77352_x) {
                        tmp.merge(Aspect.TOOL, lvl);
                    }
                    var5 += lvl;
                }
                if (var5 > 0) {
                    tmp.merge(Aspect.MAGIC, var5);
                }
            }
        }
        return ThaumcraftApiHelper.cullTags(tmp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AspectList generateTags(Item item, int meta) {
        Integer counter = (Integer)Objects.firstNonNull((Object)GENERATE_TAGS_CALLS_COUNTER.get(), (Object)0);
        if (counter > 100) {
            return null;
        }
        GENERATE_TAGS_CALLS_COUNTER.set(counter + 1);
        try {
            AspectList aspectList = ThaumcraftCraftingManager.generateTags(item, meta, new ArrayList<List>());
            return aspectList;
        }
        finally {
            GENERATE_TAGS_CALLS_COUNTER.set(counter);
        }
    }

    public static AspectList generateTags(Item item, int meta, ArrayList<List> history) {
        int tmeta = meta;
        try {
            ItemStack stack = new ItemStack(item, 1, meta);
            Item stackItem = stack.func_77973_b();
            tmeta = !stackItem.func_77645_m() && stackItem.func_77614_k() ? meta : Short.MAX_VALUE;
        }
        catch (Exception stack) {
            // empty catch block
        }
        if (ThaumcraftApi.exists(item, tmeta)) {
            return ThaumcraftCraftingManager.getObjectTags(new ItemStack(item, 1, tmeta));
        }
        List<Object> historyRecord = Arrays.asList(item, tmeta);
        if (history.contains(historyRecord)) {
            return null;
        }
        history.add(historyRecord);
        if (history.size() < 100) {
            AspectList ret = ThaumcraftCraftingManager.generateTagsFromRecipes(item, tmeta == Short.MAX_VALUE ? 0 : meta, history);
            ret = ThaumcraftCraftingManager.capAspects(ret, 64);
            ThaumcraftApi.registerObjectTag(new ItemStack(item, 1, tmeta), ret);
            return ret;
        }
        return null;
    }

    private static AspectList generateTagsFromCrucibleRecipes(Item item, int meta, ArrayList<List> history) {
        CrucibleRecipe cr = ThaumcraftApi.getCrucibleRecipe(new ItemStack(item, 1, meta));
        if (cr != null) {
            AspectList ot = cr.aspects.copy();
            int ss = cr.getRecipeOutput().field_77994_a;
            ItemStack cat = null;
            if (cr.catalyst instanceof ItemStack) {
                cat = (ItemStack)cr.catalyst;
            } else if (cr.catalyst instanceof ArrayList && ((ArrayList)cr.catalyst).size() > 0) {
                cat = (ItemStack)((ArrayList)cr.catalyst).get(0);
            }
            if (cat == null) {
                return null;
            }
            AspectList ot2 = ThaumcraftCraftingManager.generateTags(cat.func_77973_b(), cat.func_77960_j(), history);
            AspectList out = new AspectList();
            if (ot2 != null && ot2.size() > 0) {
                for (Aspect tt : ot2.getAspects()) {
                    out.add(tt, ot2.getAmount(tt));
                }
            }
            for (Aspect tt : ot.getAspects()) {
                int amt = (int)(Math.sqrt(ot.getAmount(tt)) / (double)ss);
                out.add(tt, amt);
            }
            for (Aspect as : out.getAspects()) {
                if (out.getAmount(as) > 0) continue;
                out.remove(as);
            }
            return out;
        }
        return null;
    }

    private static AspectList generateTagsFromArcaneRecipes(Item item, int meta, ArrayList<List> history) {
        AspectList ret = null;
        boolean value = false;
        List recipeList = ThaumcraftApi.getCraftingRecipes();
        block2: for (int q = 0; q < recipeList.size(); ++q) {
            int idS;
            IArcaneRecipe recipe;
            ItemStack recipeOutput;
            if (!(recipeList.get(q) instanceof IArcaneRecipe) || (recipeOutput = (recipe = (IArcaneRecipe)recipeList.get(q)).getRecipeOutput()) == null) continue;
            int recipeOutputItemDamage = recipeOutput.func_77960_j();
            int idR = recipeOutputItemDamage == Short.MAX_VALUE ? 0 : recipeOutputItemDamage;
            int n = idS = meta < 0 ? 0 : meta;
            if (recipeOutput.func_77973_b() != item || idR != idS) continue;
            ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
            new AspectList();
            boolean cval = false;
            try {
                int n2;
                if (recipeList.get(q) instanceof ShapedArcaneRecipe) {
                    int width = ((ShapedArcaneRecipe)recipeList.get((int)q)).width;
                    int height = ((ShapedArcaneRecipe)recipeList.get((int)q)).height;
                    Object[] items = ((ShapedArcaneRecipe)recipeList.get(q)).getInput();
                    for (int i = 0; i < width && i < 3; ++i) {
                        block4: for (int j = 0; j < height && j < 3; ++j) {
                            if (items[i + j * width] == null) continue;
                            if (items[i + j * width] instanceof ArrayList) {
                                for (ItemStack it : (ArrayList)items[i + j * width]) {
                                    if (Utils.isEETransmutionItem(it.func_77973_b())) continue block2;
                                    AspectList obj = ThaumcraftCraftingManager.generateTags(it.func_77973_b(), it.func_77960_j(), history);
                                    if (obj == null || obj.size() <= 0) continue;
                                    ItemStack is = it.func_77946_l();
                                    is.field_77994_a = 1;
                                    ingredients.add(is);
                                    continue block4;
                                }
                                continue;
                            }
                            ItemStack it = (ItemStack)items[i + j * width];
                            if (Utils.isEETransmutionItem(it.func_77973_b())) continue block2;
                            ItemStack is = it.func_77946_l();
                            is.field_77994_a = 1;
                            ingredients.add(is);
                        }
                    }
                } else if (recipeList.get(q) instanceof ShapelessArcaneRecipe) {
                    ArrayList items = ((ShapelessArcaneRecipe)recipeList.get(q)).getInput();
                    block6: for (int i = 0; i < items.size() && i < 9; ++i) {
                        if (items.get(i) == null) continue;
                        if (items.get(i) instanceof ArrayList) {
                            for (ItemStack it : (ArrayList)items.get(i)) {
                                if (Utils.isEETransmutionItem(it.func_77973_b())) continue block2;
                                AspectList obj = ThaumcraftCraftingManager.generateTags(it.func_77973_b(), it.func_77960_j(), history);
                                if (obj == null || obj.size() <= 0) continue;
                                ItemStack is = it.func_77946_l();
                                is.field_77994_a = 1;
                                ingredients.add(is);
                                continue block6;
                            }
                            continue;
                        }
                        ItemStack it = (ItemStack)items.get(i);
                        if (Utils.isEETransmutionItem(it.func_77973_b())) continue block2;
                        ItemStack is = it.func_77946_l();
                        is.field_77994_a = 1;
                        ingredients.add(is);
                    }
                }
                AspectList ph = ThaumcraftCraftingManager.getAspectsFromIngredients(ingredients, recipeOutput, history);
                if (recipe.getAspects() != null) {
                    Aspect[] aspectArray = recipe.getAspects().getAspects();
                    int n3 = aspectArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        Aspect a = aspectArray[n2];
                        ph.add(a, (int)(Math.sqrt(recipe.getAspects().getAmount(a)) / (double)recipeOutput.field_77994_a));
                    }
                }
                Aspect[] aspectArray = ph.copy().getAspects();
                int n4 = aspectArray.length;
                for (n2 = 0; n2 < n4; ++n2) {
                    Aspect as = aspectArray[n2];
                    if (ph.getAmount(as) > 0) continue;
                    ph.remove(as);
                }
                if (cval < value) continue;
                ret = ph;
                value = cval;
                continue;
            }
            catch (Exception var22) {
                var22.printStackTrace();
            }
        }
        return ret;
    }

    private static AspectList generateTagsFromInfusionRecipes(Item item, int meta, ArrayList<List> history) {
        InfusionRecipe cr = ThaumcraftApi.getInfusionRecipe(new ItemStack(item, 1, meta));
        if (cr == null) {
            return null;
        }
        AspectList ot = cr.getAspects().copy();
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        ItemStack is = cr.getRecipeInput().func_77946_l();
        is.field_77994_a = 1;
        ingredients.add(is);
        for (ItemStack cat : cr.getComponents()) {
            ItemStack is2 = cat.func_77946_l();
            is2.field_77994_a = 1;
            ingredients.add(is2);
        }
        AspectList out = new AspectList();
        AspectList ot2 = ThaumcraftCraftingManager.getAspectsFromIngredients(ingredients, (ItemStack)cr.getRecipeOutput(), history);
        for (Aspect tt : ot2.getAspects()) {
            out.add(tt, ot2.getAmount(tt));
        }
        for (Aspect tt : ot.getAspects()) {
            int amt = (int)(Math.sqrt(ot.getAmount(tt)) / (double)((ItemStack)cr.getRecipeOutput()).field_77994_a);
            out.add(tt, amt);
        }
        for (Aspect as : out.getAspects()) {
            if (out.getAmount(as) > 0) continue;
            out.remove(as);
        }
        return out;
    }

    private static AspectList generateTagsFromCraftingRecipes(Item item, int meta, ArrayList<List> history) {
        AspectList ret = null;
        int value = Integer.MAX_VALUE;
        List recipeList = CraftingManager.func_77594_a().func_77592_b();
        block2: for (int q = 0; q < recipeList.size(); ++q) {
            int idS;
            Item recipeOutputItem;
            ItemStack recipeOutput;
            IRecipe recipe = (IRecipe)recipeList.get(q);
            if (recipe == null || (recipeOutput = recipe.func_77571_b()) == null || (recipeOutputItem = recipeOutput.func_77973_b()) == null || Item.func_150891_b((Item)recipeOutputItem) <= 0) continue;
            int recipeOutputItemDamage = recipeOutput.func_77960_j();
            int idR = recipeOutputItemDamage == Short.MAX_VALUE ? 0 : recipeOutputItemDamage;
            int n = idS = meta == Short.MAX_VALUE ? 0 : meta;
            if (recipeOutputItem != item || idR != idS) continue;
            ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
            try {
                if (recipeList.get(q) instanceof ShapedRecipes) {
                    int width = ((ShapedRecipes)recipeList.get((int)q)).field_77576_b;
                    int height = ((ShapedRecipes)recipeList.get((int)q)).field_77577_c;
                    ItemStack[] items = ((ShapedRecipes)recipeList.get((int)q)).field_77574_d;
                    for (int i = 0; i < width && i < 3; ++i) {
                        for (int j = 0; j < height && j < 3; ++j) {
                            if (items[i + j * width] == null) continue;
                            if (Utils.isEETransmutionItem(items[i + j * width].func_77973_b())) continue block2;
                            ItemStack is = items[i + j * width].func_77946_l();
                            is.field_77994_a = 1;
                            ingredients.add(is);
                        }
                    }
                } else if (recipeList.get(q) instanceof ShapelessRecipes) {
                    List items = ((ShapelessRecipes)recipeList.get((int)q)).field_77579_b;
                    for (int i = 0; i < items.size() && i < 9; ++i) {
                        ItemStack it = (ItemStack)items.get(i);
                        if (it == null) continue;
                        if (Utils.isEETransmutionItem(it.func_77973_b())) continue block2;
                        ItemStack is = it.func_77946_l();
                        is.field_77994_a = 1;
                        ingredients.add(is);
                    }
                } else if (recipeList.get(q) instanceof ShapedOreRecipe) {
                    int size = ((IRecipe)recipeList.get(q)).func_77570_a();
                    Object[] items = ((ShapedOreRecipe)recipeList.get(q)).getInput();
                    block6: for (int i = 0; i < size && i < 9; ++i) {
                        if (items[i] == null) continue;
                        if (items[i] instanceof ArrayList) {
                            for (ItemStack it : (ArrayList)items[i]) {
                                Item itItem = it.func_77973_b();
                                if (Utils.isEETransmutionItem(itItem)) continue block2;
                                AspectList obj = ThaumcraftCraftingManager.generateTags(itItem, it.func_77960_j(), history);
                                if (obj == null || obj.size() <= 0) continue;
                                ItemStack is = it.func_77946_l();
                                is.field_77994_a = 1;
                                ingredients.add(is);
                                continue block6;
                            }
                            continue;
                        }
                        ItemStack it = (ItemStack)items[i];
                        if (Utils.isEETransmutionItem(it.func_77973_b())) continue block2;
                        ItemStack is = it.func_77946_l();
                        is.field_77994_a = 1;
                        ingredients.add(is);
                    }
                } else if (recipeList.get(q) instanceof ShapelessOreRecipe) {
                    ArrayList items = ((ShapelessOreRecipe)recipeList.get(q)).getInput();
                    block8: for (int i = 0; i < items.size() && i < 9; ++i) {
                        if (items.get(i) == null) continue;
                        if (items.get(i) instanceof ArrayList) {
                            for (ItemStack it : (ArrayList)items.get(i)) {
                                Item itItem = it.func_77973_b();
                                if (Utils.isEETransmutionItem(itItem)) continue block2;
                                AspectList obj = ThaumcraftCraftingManager.generateTags(itItem, it.func_77960_j(), history);
                                if (obj == null || obj.size() <= 0) continue;
                                ItemStack is = it.func_77946_l();
                                is.field_77994_a = 1;
                                ingredients.add(is);
                                continue block8;
                            }
                            continue;
                        }
                        ItemStack it = (ItemStack)items.get(i);
                        if (Utils.isEETransmutionItem(it.func_77973_b())) continue block2;
                        ItemStack is = it.func_77946_l();
                        is.field_77994_a = 1;
                        ingredients.add(is);
                    }
                }
                AspectList ph = ThaumcraftCraftingManager.getAspectsFromIngredients(ingredients, recipeOutput, history);
                for (Aspect as : ph.copy().getAspects()) {
                    if (ph.getAmount(as) > 0) continue;
                    ph.remove(as);
                }
                if (ph.visSize() >= value || ph.visSize() <= 0) continue;
                ret = ph;
                value = ph.visSize();
                continue;
            }
            catch (Exception var20) {
                var20.printStackTrace();
            }
        }
        return ret;
    }

    private static AspectList getAspectsFromIngredients(ArrayList<ItemStack> ingredients, ItemStack recipeOut, ArrayList<List> history) {
        AspectList out = new AspectList();
        AspectList mid = new AspectList();
        for (ItemStack stack : ingredients) {
            AspectList aspectList;
            Item item = stack.func_77973_b();
            if (item == null) continue;
            Item containerItem = item.func_77668_q();
            if (containerItem != null) {
                if (containerItem == item || (aspectList = ThaumcraftCraftingManager.generateTags(containerItem, Short.MAX_VALUE, history)) == null) continue;
                for (Aspect aspect : aspectList.getAspects()) {
                    out.reduce(aspect, aspectList.getAmount(aspect));
                }
                continue;
            }
            aspectList = ThaumcraftCraftingManager.generateTags(item, stack.func_77960_j(), history);
            if (aspectList == null) continue;
            for (Aspect aspect : aspectList.getAspects()) {
                if (aspect == null) continue;
                mid.add(aspect, aspectList.getAmount(aspect));
            }
        }
        for (Aspect aspect : mid.getAspects()) {
            if (aspect == null) continue;
            out.add(aspect, (int)((float)mid.getAmount(aspect) * 0.75f / (float)recipeOut.field_77994_a));
        }
        for (Aspect aspect : out.getAspects()) {
            if (out.getAmount(aspect) > 0) continue;
            out.remove(aspect);
        }
        return out;
    }

    private static AspectList generateTagsFromRecipes(Item item, int meta, ArrayList<List> history) {
        AspectList ret = null;
        boolean value = false;
        ret = ThaumcraftCraftingManager.generateTagsFromCrucibleRecipes(item, meta, history);
        if (ret != null) {
            return ret;
        }
        ret = ThaumcraftCraftingManager.generateTagsFromArcaneRecipes(item, meta, history);
        if (ret != null) {
            return ret;
        }
        ret = ThaumcraftCraftingManager.generateTagsFromInfusionRecipes(item, meta, history);
        if (ret != null) {
            return ret;
        }
        ret = ThaumcraftCraftingManager.generateTagsFromCraftingRecipes(item, meta, history);
        return ret;
    }
}

