/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.commands;

import java.util.Map;

public final class Parameter {
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String IDENTIFIER = "identifier";
    private static final String OPTIONAL = "optional";
    private static final String EXAMPLE = "exampleValue";
    private final String m_type;
    private final Map<String, String> m_properties;

    Parameter(String type, Map<String, String> properties) {
        this.m_type = type;
        this.m_properties = properties;
    }

    public String getName() {
        return this.m_properties.get(NAME);
    }

    public String getDescription() {
        return this.m_properties.get(DESCRIPTION);
    }

    public boolean isOptional() {
        return Boolean.parseBoolean(this.m_properties.get(OPTIONAL));
    }

    public String getIdentifier() {
        return this.m_properties.get(IDENTIFIER);
    }

    public String getExampleValue() {
        return this.m_properties.get(EXAMPLE);
    }

    public String getType() {
        return this.m_type;
    }

    public Map<String, String> getProperties() {
        return this.m_properties;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getType());
        result.append(this.getProperties());
        return result.toString();
    }
}

