/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.notification.widget;

import com.jrockit.mc.common.unit.IQuantity;
import com.jrockit.mc.common.unit.IUnit;
import com.jrockit.mc.common.unit.KindOfQuantity;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.console.ui.notification.NotificationPlugin;
import com.jrockit.mc.console.ui.notification.uicomponents.FieldRenderer;
import com.jrockit.mc.console.ui.notification.widget.Messages;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.IMRIService;
import com.jrockit.mc.rjmx.subscription.IMRIValueListener;
import com.jrockit.mc.rjmx.subscription.ISubscriptionService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.subscription.MRIValueEvent;
import com.jrockit.mc.rjmx.triggers.ITrigger;
import com.jrockit.mc.rjmx.triggers.IValueEvaluator;
import com.jrockit.mc.rjmx.triggers.TriggerRule;
import com.jrockit.mc.rjmx.triggers.condition.internal.TriggerCondition;
import com.jrockit.mc.rjmx.triggers.fields.internal.Field;
import com.jrockit.mc.rjmx.triggers.fields.internal.FieldHolder;
import com.jrockit.mc.rjmx.triggers.fields.internal.QuantityField;
import com.jrockit.mc.rjmx.triggers.internal.ValueEvaluatorNumberMax;
import com.jrockit.mc.rjmx.triggers.internal.ValueEvaluatorNumberMin;
import com.jrockit.mc.rjmx.triggers.internal.ValueEvaluatorStringMatch;
import com.jrockit.mc.rjmx.ui.internal.AttributeSelectionViewModel;
import com.jrockit.mc.rjmx.ui.internal.AttributeSelectorWizardDialog;
import com.jrockit.mc.rjmx.ui.internal.MBeanPropertiesOrderer;
import com.jrockit.mc.ui.uibuilder.IUIBuilder;
import java.util.HashMap;
import javax.management.ObjectName;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ConditionChooser {
    private final StackLayout m_stackLayout;
    private Composite m_conditionContainer;
    private final IUIBuilder m_builder;
    private final HashMap<Class<?>, Composite> m_controlEvaluatorMapping = new HashMap();
    private Text m_text;
    private final IConnectionHandle m_connectionHandle;
    private final boolean m_showAttributeSelector;
    private final TriggerRule m_notificationRule;
    private CurrentValueUpdater m_currentValueUpdater;
    private Text m_pathText;
    private final Composite m_parent;
    private KindOfQuantity<?> m_currentKind;

    public ConditionChooser(boolean showAttributeSelector, IUIBuilder builder, TriggerRule rule, IConnectionHandle connectionHandle, Composite parent) {
        this.m_showAttributeSelector = showAttributeSelector;
        this.m_builder = builder;
        this.m_connectionHandle = connectionHandle;
        this.m_stackLayout = new StackLayout();
        this.m_notificationRule = rule;
        this.m_parent = parent;
        this.create(parent);
        this.initializeUnit();
        this.select(this.m_notificationRule.getTrigger());
    }

    public void select(ITrigger trigger) {
        Control c;
        this.getStackLayout().topControl = c = (Control)this.m_controlEvaluatorMapping.get(trigger.getValueEvaluator().getClass());
        this.m_conditionContainer.layout();
    }

    private void create(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        parent.setLayout((Layout)layout);
        if (this.m_showAttributeSelector) {
            GridData gdAttribute = new GridData(4, 4, true, false);
            Composite pathName = this.createAttributeSelector(parent);
            pathName.setLayoutData((Object)gdAttribute);
        }
        GridData gd2 = new GridData(4, 4, true, false);
        this.m_conditionContainer = this.getUIBuilder().createComposite(parent);
        this.getUIBuilder().setContainer(this.m_conditionContainer);
        this.createStacks(this.m_conditionContainer);
        this.m_conditionContainer.setLayoutData((Object)gd2);
        this.updateSubscription();
    }

    private void updateSubscription() {
        MRI descriptor = this.m_notificationRule.getTrigger().getAttributeDescriptor();
        ISubscriptionService attributeSubscriptionService = (ISubscriptionService)this.m_connectionHandle.getServiceOrDummy(ISubscriptionService.class);
        attributeSubscriptionService.removeMRIValueListener((IMRIValueListener)this.m_currentValueUpdater);
        if (this.m_showAttributeSelector && descriptor != null) {
            attributeSubscriptionService.addMRIValueListener(descriptor, (IMRIValueListener)this.m_currentValueUpdater);
        }
    }

    private Composite createCurrentValue(Composite container) {
        this.getUIBuilder().createLabel(Messages.ConditionChooser_CURRENT_TRIGGER_VALUE_TEXT, null);
        Text text = this.getUIBuilder().createText(Messages.ConditionChooser_TRIGGER_VALUE_NOT_UPDATED, "", 0);
        text.setEditable(false);
        this.m_currentValueUpdater = new CurrentValueUpdater(text);
        this.getUIBuilder().layout();
        return container;
    }

    String getPath(Composite tempComposite, MRI selectedAttribute) {
        String path = MBeanPropertiesOrderer.getMBeanPath((ObjectName)selectedAttribute.getObjectName());
        return path == null ? "" : path;
    }

    private Composite createAttributeSelector(Composite parent) {
        Composite attributeSelectorContainer = this.getUIBuilder().createComposite(parent);
        this.getUIBuilder().setContainer(attributeSelectorContainer);
        String name = Messages.AttributeSelectionSectionPart_UNKNOWN_NAME_TEXT;
        String description = null;
        String path = "";
        IMRIMetaDataService manager = (IMRIMetaDataService)this.m_connectionHandle.getServiceOrDummy(IMRIMetaDataService.class);
        IMRIMetaData info = manager.getMetaData(this.m_notificationRule.getTrigger().getAttributeDescriptor());
        if (info != null) {
            name = info.getMRI().getDataPath();
            description = info.getDescription();
            path = this.getPath(parent, info.getMRI());
        }
        this.getUIBuilder().createLabel(Messages.ConditionChooser_MBEAN_PATH_LABEL_TEXT, null);
        this.m_pathText = this.getUIBuilder().createText(path, "", 0);
        this.m_pathText.setEditable(false);
        this.getUIBuilder().layout();
        this.getUIBuilder().createLabel(Messages.ConditionChooser_LABEL_ATTRIBUTE, null);
        this.m_text = this.getUIBuilder().createText(name, description, 0);
        this.m_text.setEditable(false);
        Button button = this.getUIBuilder().createButton(Messages.ConditionChooser_BUTTON_BROWSE_TEXT, Messages.ConditionChooser_BUTTON_BROWSE_TOOLTIP);
        this.getUIBuilder().layout();
        button.addSelectionListener((SelectionListener)new AttributeSelectionListener());
        this.createCurrentValue(attributeSelectorContainer);
        return attributeSelectorContainer;
    }

    private StackLayout getStackLayout() {
        return this.m_stackLayout;
    }

    private IUIBuilder getUIBuilder() {
        return this.m_builder;
    }

    private void createStacks(Composite container) {
        Field[] tempFields;
        container.setLayout((Layout)this.m_stackLayout);
        FieldHolder stringMatch = new FieldHolder();
        FieldHolder numberMax = new FieldHolder();
        FieldHolder numberMin = new FieldHolder();
        Field[] fieldArray = tempFields = ((TriggerCondition)this.m_notificationRule.getTrigger()).getFieldHolder().getFields();
        int n = tempFields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getId().equals("EVAL_NUM_MAX")) {
                numberMax.addField(field);
            } else if (field.getId().equals("EVAL_NUM_MIN")) {
                numberMin.addField(field);
            } else if (field.getId().equals("EVAL_STRING")) {
                stringMatch.addField(field);
            } else {
                numberMax.addField(field);
                numberMin.addField(field);
                stringMatch.addField(field);
            }
            ++n2;
        }
        this.createStack(ValueEvaluatorNumberMax.class, container, numberMax);
        this.createStack(ValueEvaluatorNumberMin.class, container, numberMin);
        this.createStack(ValueEvaluatorStringMatch.class, container, stringMatch);
    }

    private Composite createStack(Class<?> clazz, Composite container, FieldHolder fieldHolder) {
        Composite stackContainer = this.getUIBuilder().createComposite(container);
        this.getUIBuilder().setContainer(stackContainer);
        FieldRenderer tcr = new FieldRenderer(fieldHolder, this.getUIBuilder());
        tcr.render();
        this.m_controlEvaluatorMapping.put(clazz, stackContainer);
        return stackContainer;
    }

    private void initializeUnit() {
        TriggerCondition trigger = (TriggerCondition)this.m_notificationRule.getTrigger();
        if (trigger.getAttributeDescriptor() != null) {
            Field field = null;
            if (trigger.getValueEvaluator() instanceof ValueEvaluatorNumberMin) {
                field = trigger.getFieldHolder().getField("EVAL_NUM_MIN");
            } else if (trigger.getValueEvaluator() instanceof ValueEvaluatorNumberMax) {
                field = trigger.getFieldHolder().getField("EVAL_NUM_MAX");
            }
            if (field instanceof QuantityField) {
                QuantityField qField = (QuantityField)field;
                this.m_currentKind = qField.getKind();
            } else {
                this.m_currentKind = null;
            }
            this.updateUnit();
        }
    }

    public void updateUnit() {
        TriggerCondition trigger = (TriggerCondition)this.m_notificationRule.getTrigger();
        IMRIMetaDataService metadataService = (IMRIMetaDataService)this.m_connectionHandle.getServiceOrDummy(IMRIMetaDataService.class);
        IMRIMetaData attribute = metadataService.getMetaData(trigger.getAttributeDescriptor());
        IUnit unit = null;
        if (MRIMetaDataToolkit.isNumerical((IMRIMetaData)attribute)) {
            unit = UnitLookup.getUnitOrDefault((String)attribute.getUnitString());
        }
        if (unit != null) {
            if (!unit.getContentType().equals(this.m_currentKind)) {
                IQuantity zeroQuantity = unit.quantity(0L);
                if (trigger.getValueEvaluator() instanceof ValueEvaluatorNumberMin) {
                    QuantityField field = (QuantityField)trigger.getFieldHolder().getField("EVAL_NUM_MIN");
                    field.setKind(unit.getContentType());
                } else if (trigger.getValueEvaluator() instanceof ValueEvaluatorNumberMax) {
                    QuantityField field = (QuantityField)trigger.getFieldHolder().getField("EVAL_NUM_MAX");
                    field.setKind(unit.getContentType());
                } else {
                    String currentValue = this.getCurrentField(trigger).getValue();
                    QuantityField field = (QuantityField)trigger.getFieldHolder().getField("EVAL_NUM_MAX");
                    trigger.setValueEvaluator((IValueEvaluator)new ValueEvaluatorNumberMax(zeroQuantity));
                    field.setKind(unit.getContentType());
                    field.setUncheckedValue(currentValue);
                }
            }
        } else if (this.m_currentKind != null) {
            String currentValue = this.getCurrentField(trigger).getValue();
            trigger.setValueEvaluator((IValueEvaluator)new ValueEvaluatorStringMatch("*"));
            Field field = trigger.getFieldHolder().getField("EVAL_STRING");
            field.setValue(currentValue);
        }
        this.getCurrentField(trigger).updateListener();
        if (this.m_currentValueUpdater != null) {
            this.m_currentValueUpdater.setUnit(unit);
        }
        this.m_currentKind = unit != null ? unit.getContentType() : null;
        this.select((ITrigger)trigger);
    }

    private Field getCurrentField(TriggerCondition trigger) {
        if (trigger.getValueEvaluator() instanceof ValueEvaluatorNumberMin) {
            return trigger.getFieldHolder().getField("EVAL_NUM_MIN");
        }
        if (trigger.getValueEvaluator() instanceof ValueEvaluatorNumberMax) {
            return trigger.getFieldHolder().getField("EVAL_NUM_MAX");
        }
        return trigger.getFieldHolder().getField("EVAL_STRING");
    }

    public class AttributeSelectionListener
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            IMRIService mriService = (IMRIService)ConditionChooser.this.m_connectionHandle.getServiceOrDummy(IMRIService.class);
            IMRIMetaDataService metadataService = (IMRIMetaDataService)ConditionChooser.this.m_connectionHandle.getServiceOrDummy(IMRIMetaDataService.class);
            MRI[] attributes = new MRI[]{ConditionChooser.this.m_notificationRule.getTrigger().getAttributeDescriptor()};
            AttributeSelectionViewModel viewModel = new AttributeSelectionViewModel(null, false, false, Messages.ConditionChooser_SELECTION_DIALOG_TITLE, Messages.ConditionChooser_ATTRIBUTE_SELECTION_TITLE, Messages.ConditionChooser_ATTRIBUTE_SELECTION_DESCRIPTION, Messages.ConditionChooser_ATTRIBUTE_CONFIGURATION_TITLE, Messages.ConditionChooser_ATTRIBUTE_CONFIGURATION_DESCRIPTION);
            AttributeSelectorWizardDialog dialog = new AttributeSelectorWizardDialog(Display.getCurrent().getActiveShell(), viewModel);
            if (dialog.open(mriService, metadataService, attributes, attributes) != 0) {
                return;
            }
            MRI[] selectedAttributes = dialog.getSelectedAttributes();
            if (selectedAttributes.length == 1) {
                final MRI selectedAttribute = selectedAttributes[0];
                final TriggerCondition trigger = (TriggerCondition)ConditionChooser.this.m_notificationRule.getTrigger();
                NotificationPlugin.getDefault().getNotificationRepository().performCriticalRuleChange(ConditionChooser.this.m_notificationRule, new Runnable(){

                    @Override
                    public void run() {
                        trigger.setAttributeDescriptor(selectedAttribute);
                    }
                });
                ConditionChooser.this.updateUnit();
                String s = selectedAttribute.getDataPath();
                ConditionChooser.this.m_text.setText(s);
                ConditionChooser.this.m_pathText.setText(ConditionChooser.this.getPath(ConditionChooser.this.m_parent, selectedAttribute));
                ConditionChooser.this.updateSubscription();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    static class CurrentValueUpdater
    implements IMRIValueListener {
        private final Text m_valueText;
        private IUnit<?> unit;

        public CurrentValueUpdater(Text text) {
            this.m_valueText = text;
        }

        public void setUnit(IUnit<?> unit) {
            this.unit = unit;
        }

        public void valueChanged(final MRIValueEvent event) {
            if (!this.m_valueText.isDisposed()) {
                this.m_valueText.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!CurrentValueUpdater.this.m_valueText.isDisposed()) {
                            if (CurrentValueUpdater.this.unit != null && event.getValue() instanceof Number) {
                                CurrentValueUpdater.this.m_valueText.setText(KindOfQuantity.format((Number)((Number)event.getValue()), (IUnit)CurrentValueUpdater.this.unit));
                            } else {
                                CurrentValueUpdater.this.m_valueText.setText(String.valueOf(event.getValue()));
                            }
                        }
                    }
                });
            }
        }
    }
}

