/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.implementaion;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.common.blocks.BlockJarItem;
import thaumcraft.common.blocks.ItemJarFilled;
import thaumicenergistics.api.IThEEssentiaContainerPermission;
import thaumicenergistics.api.IThETransportPermissions;
import thaumicenergistics.common.utils.ThELog;

class ThETransportPermissions
implements IThETransportPermissions {
    private final HashMap<Class<? extends IEssentiaContainerItem>, ContainerCollection> itemWhitelist = new HashMap();
    private final Set<Class<? extends IAspectContainer>> tileExtractWhiteList = new HashSet<Class<? extends IAspectContainer>>();
    private final Set<Class<? extends IAspectContainer>> tileInjectWhiteList = new HashSet<Class<? extends IAspectContainer>>();
    private final HashMap<Class<? extends IAspectContainer>, Integer> tileCapacities = new HashMap();

    ThETransportPermissions() {
    }

    @Override
    public <T extends TileEntity> boolean addAspectContainerTileToBothPermissions(Class<T> tileClass, int capacity) {
        return this.addAspectContainerTileToInjectPermissions(tileClass, capacity) | this.addAspectContainerTileToExtractPermissions(tileClass, capacity);
    }

    @Override
    public <T extends TileEntity> boolean addAspectContainerTileToExtractPermissions(Class<T> tileClass, int capacity) {
        if (tileClass != null) {
            this.tileCapacities.put(tileClass, capacity);
            if (this.tileExtractWhiteList.add(tileClass)) {
                ThELog.info("Added \"%s\" with capacity (%d) to extraction whitelist.", tileClass.toString(), capacity);
            }
            return true;
        }
        return false;
    }

    @Override
    public <T extends TileEntity> boolean addAspectContainerTileToInjectPermissions(Class<T> tileClass, int capacity) {
        if (tileClass != null) {
            this.tileCapacities.put(tileClass, capacity);
            if (this.tileInjectWhiteList.add(tileClass)) {
                ThELog.info("Added \"%s\" with capacity (%d) to injection whitelist.", tileClass.toString(), capacity);
            }
            return true;
        }
        return false;
    }

    @Override
    public void addEssentiaContainerItemToTransportPermissions(Class<? extends IEssentiaContainerItem> itemClass, int capacity, int damageValue, boolean canHoldPartialAmount) {
        if (itemClass != null) {
            if (this.itemWhitelist.containsKey(itemClass)) {
                this.itemWhitelist.get(itemClass).addContainer(capacity, canHoldPartialAmount, damageValue);
            } else {
                this.itemWhitelist.put(itemClass, new ContainerCollection(capacity, canHoldPartialAmount, damageValue));
            }
            ThELog.info("Added \"%s\"[%d] to item whitelist.", itemClass.toString(), damageValue);
        }
    }

    @Override
    public void addEssentiaContainerItemToTransportPermissions(ItemStack containerItem, int capacity, boolean canHoldPartialAmount) {
        if (containerItem == null || !(containerItem.func_77973_b() instanceof IEssentiaContainerItem)) {
            return;
        }
        try {
            this.addEssentiaContainerItemToTransportPermissions(containerItem.func_77973_b().getClass(), capacity, containerItem.func_77960_j(), canHoldPartialAmount);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean canExtractFromAspectContainerTile(IAspectContainer container) {
        return this.tileExtractWhiteList.contains(container.getClass());
    }

    @Override
    public boolean canInjectToAspectContainerTile(IAspectContainer container) {
        return this.tileInjectWhiteList.contains(container.getClass());
    }

    @Override
    public int getAspectContainerTileCapacity(IAspectContainer container) {
        if (this.tileCapacities.containsKey(container.getClass())) {
            return this.tileCapacities.get(container.getClass());
        }
        return -1;
    }

    @Override
    public IThEEssentiaContainerPermission getEssentiaContainerInfo(Class<? extends Item> itemClass, int damageValue) {
        if (this.itemWhitelist.containsKey(itemClass)) {
            return this.itemWhitelist.get(itemClass).getInfo(damageValue);
        }
        if (itemClass == BlockJarItem.class) {
            return this.itemWhitelist.get(ItemJarFilled.class).getInfo(damageValue);
        }
        return null;
    }

    private class ContainerInfo
    implements IThEEssentiaContainerPermission {
        private int capacity;
        private boolean canHoldPartialAmount;

        public ContainerInfo(int capacity, boolean canHoldPartialAmount) {
            this.capacity = capacity;
            this.canHoldPartialAmount = canHoldPartialAmount;
        }

        @Override
        public boolean canHoldPartialAmount() {
            return this.canHoldPartialAmount;
        }

        @Override
        public int maximumCapacity() {
            return this.capacity;
        }
    }

    private class ContainerCollection {
        private HashMap<Integer, ContainerInfo> containers = new HashMap();

        public ContainerCollection(int capacity, boolean canHoldPartialAmount, int damageValue) {
            this.addContainer(capacity, canHoldPartialAmount, damageValue);
        }

        public ContainerCollection addContainer(int capacity, boolean canHoldPartialAmount, int damageValue) {
            ContainerInfo info = new ContainerInfo(capacity, canHoldPartialAmount);
            this.containers.put(damageValue, info);
            return this;
        }

        public ContainerInfo getInfo(int damageValue) {
            return this.containers.get(damageValue);
        }
    }
}

