/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.integration.tc;

import appeng.api.AEApi;
import appeng.api.storage.data.IAEFluidStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.common.ThaumicEnergistics;
import thaumicenergistics.common.fluids.GaseousEssentia;
import thaumicenergistics.common.storage.AspectStack;

public final class EssentiaConversionHelper {
    public static final EssentiaConversionHelper INSTANCE = new EssentiaConversionHelper();

    private EssentiaConversionHelper() {
    }

    public AspectStack convertAEFluidStackToAspectStack(IAEFluidStack fluidStack) {
        if (fluidStack.getFluid() instanceof GaseousEssentia) {
            return new AspectStack(((GaseousEssentia)fluidStack.getFluid()).getAspect(), this.convertFluidAmountToEssentiaAmount(fluidStack.getStackSize()));
        }
        return null;
    }

    public long convertEssentiaAmountToFluidAmount(long essentiaAmount) {
        return essentiaAmount * (long)ThaumicEnergistics.config.conversionMultiplier();
    }

    public long convertFluidAmountToEssentiaAmount(long fluidAmount) {
        return fluidAmount / (long)ThaumicEnergistics.config.conversionMultiplier();
    }

    public IAEFluidStack createAEFluidStackInEssentiaUnits(Aspect aspect, long essentiaAmount) {
        GaseousEssentia essentiaGas = GaseousEssentia.getGasFromAspect(aspect);
        if (essentiaGas == null) {
            return null;
        }
        return this.createAEFluidStackInFluidUnits(essentiaGas, this.convertEssentiaAmountToFluidAmount(essentiaAmount));
    }

    public IAEFluidStack createAEFluidStackInEssentiaUnits(GaseousEssentia essentiaGas, long essentiaAmount) {
        return this.createAEFluidStackInFluidUnits(essentiaGas, this.convertEssentiaAmountToFluidAmount(essentiaAmount));
    }

    public IAEFluidStack createAEFluidStackInFluidUnits(GaseousEssentia essentiaGas, long fluidAmount) {
        IAEFluidStack ret = null;
        try {
            ret = AEApi.instance().storage().createFluidStack(new FluidStack((Fluid)essentiaGas, 1));
            ret.setStackSize(fluidAmount);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }
}

