/*
 * Decompiled with CFR 0.152.
 */
package neresources.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import neresources.config.Settings;
import neresources.entries.DungeonEntry;
import neresources.reference.Resources;
import neresources.registry.DungeonRegistry;
import neresources.utils.Font;
import neresources.utils.RenderHelper;
import neresources.utils.TranslationHelper;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class NEIDungeonHandler
extends TemplateRecipeHandler {
    private static final int X_FIRST_ITEM = 5;
    private static final int Y_FIRST_ITEM = 48;
    private static int ITEMS_PER_PAGE;
    private static int SPACING_X;
    private static int SPACING_Y;
    private static int CYCLE_TIME;
    private static int lidStart;
    private static int lastRecipe;
    private static boolean done;

    public static void reloadSettings() {
        ITEMS_PER_PAGE = Settings.ITEMS_PER_COLUMN * Settings.ITEMS_PER_ROW;
        SPACING_X = 166 / Settings.ITEMS_PER_ROW;
        SPACING_Y = 80 / Settings.ITEMS_PER_COLUMN;
        CYCLE_TIME = (int)(20.0f * Settings.CYCLE_TIME);
    }

    public String getGuiTexture() {
        return Resources.Gui.Nei.DUNGEON.toString();
    }

    public String getRecipeName() {
        return TranslationHelper.translateToLocal("ner.dungeon.title");
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(5, 5, 40, 40), "neresources.dungeon", new Object[]{new Object()}));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("neresources.dungeon")) {
            for (DungeonEntry entry : DungeonRegistry.getInstance().getDungeons()) {
                this.arecipes.add(new CachedDungeonChest(entry));
            }
            lastRecipe = -1;
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (DungeonEntry entry : DungeonRegistry.getInstance().getDungeons(result)) {
            this.arecipes.add(new CachedDungeonChest(entry, result));
        }
        lastRecipe = -1;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)130);
        CachedDungeonChest cachedChest = (CachedDungeonChest)((Object)this.arecipes.get(recipe));
        int x = 5;
        int y = 48;
        for (int i = ITEMS_PER_PAGE * cachedChest.set; i < ITEMS_PER_PAGE * cachedChest.set + ITEMS_PER_PAGE && i < cachedChest.getContents().length; ++i) {
            if (cachedChest.resultIndex == i) {
                GuiDraw.drawTexturedModalRect((int)(x - 1), (int)(y - 1), (int)18, (int)238, (int)18, (int)18);
            } else {
                GuiDraw.drawTexturedModalRect((int)(x - 1), (int)(y - 1), (int)0, (int)238, (int)18, (int)18);
            }
            if ((y += SPACING_Y) < 48 + SPACING_Y * Settings.ITEMS_PER_COLUMN) continue;
            y = 48;
            x += SPACING_X;
        }
        RenderHelper.renderChest(15.0f, 20.0f, -40.0f, 20.0f, this.getLidAngle(recipe));
    }

    private float getLidAngle(int recipe) {
        float angle;
        if (recipe != lastRecipe) {
            done = false;
            lastRecipe = -1;
            lidStart = -1;
        }
        if (lidStart == -1) {
            lidStart = this.cycleticks;
        }
        if ((angle = (float)((this.cycleticks - lidStart) % 80)) > 50.0f || done) {
            done = true;
            angle = 50.0f;
        }
        return angle;
    }

    public void drawExtras(int recipe) {
        CachedDungeonChest cachedChest = (CachedDungeonChest)((Object)this.arecipes.get(recipe));
        Font.normal.print(TranslationHelper.translateToLocal(cachedChest.chest.getName()), 60, 7);
        Font.small.print(DungeonRegistry.getInstance().getNumStacks(cachedChest.chest), 60, 20);
        if (cachedChest.lastSet > 0) {
            Font.small.print(TranslationHelper.getLocalPageInfo(cachedChest.set, cachedChest.lastSet), 60, 36);
        }
        int x = 23;
        int y = 48 + (8 - Settings.ITEMS_PER_COLUMN);
        for (int i = ITEMS_PER_PAGE * cachedChest.set; i < ITEMS_PER_PAGE * cachedChest.set + ITEMS_PER_PAGE && i < cachedChest.getContents().length; ++i) {
            double chance = cachedChest.getChances()[i].floatValue() * 100.0f;
            String format = chance < 100.0 ? "%2.1f" : "%2.0f";
            String toPrint = String.format(format, chance).replace(',', '.') + "%";
            Font.small.print(toPrint, x, y);
            if ((y += SPACING_Y) < 48 + SPACING_Y * Settings.ITEMS_PER_COLUMN) continue;
            y = 48 + (8 - Settings.ITEMS_PER_COLUMN);
            x += SPACING_X;
        }
        cachedChest.cycleOutputs(this.cycleticks, recipe);
    }

    static {
        lidStart = -1;
        lastRecipe = -1;
    }

    public class CachedDungeonChest
    extends TemplateRecipeHandler.CachedRecipe {
        public int resultIndex;
        public DungeonEntry chest;
        public int set;
        public int lastSet;
        private long cycleAt;

        public CachedDungeonChest(DungeonEntry chest) {
            super((TemplateRecipeHandler)NEIDungeonHandler.this);
            this.resultIndex = -1;
            this.chest = chest;
            this.set = 0;
            this.cycleAt = -1L;
            this.lastSet = this.getContents().length / (ITEMS_PER_PAGE + 1);
        }

        public CachedDungeonChest(DungeonEntry chest, ItemStack result) {
            this(chest);
            ItemStack[] content = chest.getItemStacks();
            for (int i = 0; i < content.length; ++i) {
                if (!content[i].func_77969_a(result)) continue;
                this.resultIndex = i;
                this.set = this.resultIndex / ITEMS_PER_PAGE;
            }
        }

        public ItemStack[] getContents() {
            return this.chest.getItemStacks();
        }

        public Float[] getChances() {
            return this.chest.getChances();
        }

        public PositionedStack getResult() {
            return new PositionedStack((Object)this.getContents()[this.set * ITEMS_PER_PAGE], 5, 48);
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> list = new ArrayList<PositionedStack>();
            int x = 5;
            int y = 48;
            for (int i = ITEMS_PER_PAGE * this.set; i < ITEMS_PER_PAGE * this.set + ITEMS_PER_PAGE && i < this.getContents().length; ++i) {
                list.add(new PositionedStack((Object)this.getContents()[i], x, y));
                if ((y += SPACING_Y) < 48 + SPACING_Y * Settings.ITEMS_PER_COLUMN) continue;
                y = 48;
                x += SPACING_X;
            }
            if (list.size() > 0) {
                list.remove(0);
            }
            return list;
        }

        public void cycleOutputs(long tick, int recipe) {
            if (this.cycleAt == -1L || recipe != lastRecipe) {
                lastRecipe = recipe;
                this.cycleAt = tick + (long)CYCLE_TIME;
                return;
            }
            if (tick >= this.cycleAt) {
                this.cycle();
                this.cycleAt += (long)CYCLE_TIME;
            }
        }

        public void cycle() {
            if (++this.set > this.lastSet) {
                this.set = 0;
            }
        }

        public void cycleBack() {
            if (--this.set < 0) {
                this.set = this.lastSet;
            }
        }
    }
}

