/*
 * Decompiled with CFR 0.152.
 */
package neresources.api.utils.restrictions;

import java.util.ArrayList;
import java.util.List;
import neresources.api.utils.restrictions.BiomeRestriction;
import neresources.api.utils.restrictions.BlockRestriction;
import neresources.api.utils.restrictions.DimensionRestriction;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public class Restriction {
    public static final Restriction OVERWORLD_LIKE = new Restriction();
    public static final Restriction NETHER_LIKE = new Restriction(BlockRestriction.NETHER);
    public static final Restriction END_LIKE = new Restriction(BlockRestriction.END);
    public static final Restriction OVERWORLD = new Restriction(DimensionRestriction.OVERWORLD);
    public static final Restriction NETHER = new Restriction(BlockRestriction.NETHER, DimensionRestriction.NETHER);
    public static final Restriction END = new Restriction(BlockRestriction.END, DimensionRestriction.END);
    private BlockRestriction blockRestriction;
    private BiomeRestriction biomeRestriction;
    private DimensionRestriction dimensionRestriction;

    public Restriction() {
        this(BiomeRestriction.NONE);
    }

    public Restriction(BlockRestriction blockRestriction) {
        this(blockRestriction, BiomeRestriction.NONE, DimensionRestriction.NONE);
    }

    public Restriction(BiomeRestriction biomeRestriction) {
        this(BlockRestriction.STONE, biomeRestriction, DimensionRestriction.NONE);
    }

    public Restriction(DimensionRestriction dimensionRestriction) {
        this(BlockRestriction.STONE, BiomeRestriction.NONE, dimensionRestriction);
    }

    public Restriction(BlockRestriction blockRestriction, BiomeRestriction biomeRestriction) {
        this(blockRestriction, biomeRestriction, DimensionRestriction.NONE);
    }

    public Restriction(BlockRestriction blockRestriction, DimensionRestriction dimensionRestriction) {
        this(blockRestriction, BiomeRestriction.NONE, dimensionRestriction);
    }

    public Restriction(BiomeRestriction biomeRestriction, DimensionRestriction dimensionRestriction) {
        this(BlockRestriction.STONE, biomeRestriction, dimensionRestriction);
    }

    public Restriction(BlockRestriction blockRestriction, BiomeRestriction biomeRestriction, DimensionRestriction dimensionRestriction) {
        this.blockRestriction = blockRestriction;
        this.biomeRestriction = biomeRestriction;
        this.dimensionRestriction = dimensionRestriction;
    }

    public Restriction(NBTTagCompound tagCompound) {
        this.blockRestriction = new BlockRestriction(tagCompound.func_74775_l("block"));
        this.biomeRestriction = new BiomeRestriction(tagCompound.func_74775_l("biome"));
        this.dimensionRestriction = new DimensionRestriction(tagCompound.func_74775_l("dimension"));
    }

    public List<String> getStringList(boolean getNames) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(StatCollector.func_74838_a((String)"ner.ore.dimensions") + ":");
        result.addAll(this.dimensionRestriction.getValidDimensions(this.blockRestriction, getNames));
        ArrayList<String> biomes = new ArrayList<String>();
        biomes.add(StatCollector.func_74838_a((String)"ner.ore.biomes") + ":");
        biomes.addAll(this.biomeRestriction.toStringList());
        if (biomes.size() > 1) {
            result.addAll(biomes);
        }
        return result;
    }

    public NBTTagCompound writeToNBT() {
        return this.writeToNBT(new NBTTagCompound());
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74782_a("block", (NBTBase)this.blockRestriction.writeToNBT());
        tagCompound.func_74782_a("dimension", (NBTBase)this.dimensionRestriction.writeToNBT());
        tagCompound.func_74782_a("biome", (NBTBase)this.biomeRestriction.writeToNBT());
        return tagCompound;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Restriction)) {
            return false;
        }
        Restriction other = (Restriction)obj;
        if (!other.biomeRestriction.equals(this.biomeRestriction)) {
            return false;
        }
        if (!other.blockRestriction.equals(this.blockRestriction)) {
            return false;
        }
        return other.dimensionRestriction.equals(this.dimensionRestriction);
    }

    public boolean isMergeable(Restriction restriction) {
        if (!this.biomeRestriction.isMergeable(restriction.biomeRestriction)) {
            return false;
        }
        if (!this.blockRestriction.equals(restriction.blockRestriction)) {
            return false;
        }
        return this.dimensionRestriction.isMergeable(restriction.dimensionRestriction);
    }

    public String toString() {
        return this.blockRestriction.toString() + ", " + this.dimensionRestriction.toString() + ", " + this.biomeRestriction.toString();
    }
}

