/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region.texture;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.shader.Framebuffer;
import org.lwjgl.opengl.GL11;
import xaero.map.exception.OpenGLException;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.misc.Misc;

public class BranchTextureRenderer {
    private ImprovedFramebuffer renderFBO = new ImprovedFramebuffer(64, 64, false);
    private int glEmptyTexture;

    public BranchTextureRenderer(Framebuffer defaultFramebuffer) {
        this.glEmptyTexture = this.renderFBO.field_147617_g;
        this.renderFBO.func_147610_a(true);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)3042);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClear((int)16384);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3042);
        this.renderFBO.func_147609_e();
        defaultFramebuffer.func_147610_a(true);
    }

    public void render(int destTexture, Integer srcTextureTopLeft, Integer srcTextureTopRight, Integer srcTextureBottomLeft, Integer srcTextureBottomRight, Framebuffer defaultFramebuffer, boolean justAllocated, ScaledResolution scaledRes) {
        GL11.glBindTexture((int)3553, (int)0);
        this.renderFBO.func_147610_a(true);
        this.renderFBO.setFramebufferTexture(destTexture);
        OpenGLException.checkGLError();
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)64.0, (double)64.0, (double)0.0, (double)-1.0, (double)1.0);
        GL11.glMatrixMode((int)5888);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)3042);
        if (justAllocated) {
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glClear((int)16384);
        }
        if (srcTextureTopLeft != null) {
            this.renderCorner(srcTextureTopLeft, 0, 0);
        }
        if (srcTextureTopRight != null) {
            this.renderCorner(srcTextureTopRight, 1, 0);
        }
        if (srcTextureBottomLeft != null) {
            this.renderCorner(srcTextureBottomLeft, 0, 1);
        }
        if (srcTextureBottomRight != null) {
            this.renderCorner(srcTextureBottomRight, 1, 1);
        }
        OpenGLException.checkGLError(false, "updating a map branch texture");
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBindTexture((int)3553, (int)0);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        Minecraft mc = Minecraft.func_71410_x();
        Misc.minecraftOrtho(scaledRes);
        GL11.glMatrixMode((int)5888);
        this.renderFBO.func_147609_e();
        mc.func_147110_a().func_147610_a(false);
        GL11.glViewport((int)0, (int)0, (int)mc.field_71443_c, (int)mc.field_71440_d);
        OpenGLException.checkGLError();
    }

    private void renderCorner(Integer srcTexture, int cornerX, int cornerY) {
        int xOffset = cornerX * 32;
        int yOffset = (1 - cornerY) * 32;
        GL11.glBindTexture((int)3553, (int)(srcTexture != -1 ? srcTexture : this.glEmptyTexture));
        MapRenderHelper.renderTexturedModalRect(xOffset, yOffset, 32.0f, 32.0f, 0, 64, 64.0f, -64.0f, 64.0f, 64.0f);
    }
}

