/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.graphics;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.ScaledResolution;
import org.lwjgl.opengl.GL11;
import xaero.map.graphics.TextureUpload;
import xaero.map.graphics.TextureUploadBenchmark;
import xaero.map.pool.TextureUploadPool;
import xaero.map.region.texture.BranchTextureRenderer;

public class TextureUploader {
    public static final int NORMAL = 0;
    public static final int NORMALDOWNLOAD = 1;
    public static final int COMPRESSED = 2;
    public static final int BRANCHUPDATE = 3;
    public static final int BRANCHUPDATE_ALLOCATE = 4;
    public static final int BRANCHDOWNLOAD = 5;
    private static final int DEFAULT_NORMALDOWNLOAD_TIME = 3000000;
    private static final int DEFAULT_NORMAL_TIME = 1000000;
    private static final int DEFAULT_COMPRESSED_TIME = 1000000;
    private static final int DEFAULT_BRANCHUPDATED_TIME = 3000000;
    private static final int DEFAULT_BRANCHUPDATE_ALLOCATE_TIME = 4000000;
    private static final int DEFAULT_BRANCHDOWNLOAD_TIME = 1000000;
    private List<TextureUpload> textureUploadRequests = new ArrayList<TextureUpload>();
    private TextureUploadBenchmark textureUploadBenchmark;
    private TextureUploadPool.Normal normalTextureUploadPool;
    private TextureUploadPool.NormalWithDownload normalWithDownloadTextureUploadPool;
    private TextureUploadPool.Compressed compressedTextureUploadPool;
    private TextureUploadPool.BranchUpdate branchUpdatePool;
    private TextureUploadPool.BranchUpdate branchUpdateAllocatePool;
    private TextureUploadPool.BranchDownload branchDownloadPool;

    public TextureUploader(TextureUploadPool.Normal normalTextureUploadPool, TextureUploadPool.NormalWithDownload normalWithDownloadTextureUploadPool, TextureUploadPool.Compressed compressedTextureUploadPool, TextureUploadPool.BranchUpdate branchUpdatePool, TextureUploadPool.BranchUpdate branchUpdateAllocatePool, TextureUploadPool.BranchDownload branchDownloadPool, TextureUploadBenchmark textureUploadBenchmark) {
        this.normalTextureUploadPool = normalTextureUploadPool;
        this.normalWithDownloadTextureUploadPool = normalWithDownloadTextureUploadPool;
        this.compressedTextureUploadPool = compressedTextureUploadPool;
        this.textureUploadBenchmark = textureUploadBenchmark;
        this.branchUpdatePool = branchUpdatePool;
        this.branchUpdateAllocatePool = branchUpdateAllocatePool;
        this.branchDownloadPool = branchDownloadPool;
    }

    public long requestUpload(TextureUpload upload) {
        this.textureUploadRequests.add(upload);
        if (upload.getUploadType() == 1) {
            return this.textureUploadBenchmark.isFinished(1) ? Math.min(this.textureUploadBenchmark.getAverage(1), 3000000L) : 3000000L;
        }
        if (upload.getUploadType() == 0) {
            return this.textureUploadBenchmark.isFinished(0) ? Math.min(this.textureUploadBenchmark.getAverage(0), 1000000L) : 1000000L;
        }
        if (upload.getUploadType() == 2) {
            return this.textureUploadBenchmark.isFinished(2) ? Math.min(this.textureUploadBenchmark.getAverage(2), 1000000L) : 1000000L;
        }
        if (upload.getUploadType() == 3) {
            return this.textureUploadBenchmark.isFinished(3) ? Math.min(this.textureUploadBenchmark.getAverage(3), 3000000L) : 3000000L;
        }
        if (upload.getUploadType() == 4) {
            return this.textureUploadBenchmark.isFinished(4) ? Math.min(this.textureUploadBenchmark.getAverage(4), 4000000L) : 4000000L;
        }
        if (upload.getUploadType() == 5) {
            return this.textureUploadBenchmark.isFinished(5) ? Math.min(this.textureUploadBenchmark.getAverage(5), 1000000L) : 1000000L;
        }
        return 0L;
    }

    public long requestNormal(int glTexture, int glPbo, int target, int level, int internalFormat, int width, int height, int border, long pixels_buffer_offset, int format, int type) {
        TextureUpload.Normal upload = this.normalTextureUploadPool.get(glTexture, glPbo, target, level, internalFormat, width, height, border, pixels_buffer_offset, format, type);
        return this.requestUpload(upload);
    }

    public long requestNormalWithDownload(int glTexture, int glPbo, int target, int level, int internalFormat, int width, int height, int border, long pixels_buffer_offset, int format, int type, int glPackPbo) {
        TextureUpload.NormalWithDownload upload = this.normalWithDownloadTextureUploadPool.get(glTexture, glPbo, target, level, internalFormat, width, height, border, pixels_buffer_offset, format, type, glPackPbo);
        return this.requestUpload(upload);
    }

    public long requestCompressed(int glTexture, int glPbo, int target, int level, int internalFormat, int width, int height, int border, long pixels_buffer_offset, int dataSize) {
        TextureUpload.Compressed upload = this.compressedTextureUploadPool.get(glTexture, glPbo, target, level, internalFormat, width, height, border, pixels_buffer_offset, dataSize);
        return this.requestUpload(upload);
    }

    public long requestBranchUpdate(boolean allocate, int glTexture, int glPbo, int target, int level, int internalFormat, int width, int height, int border, long pixels_buffer_offset, int format, int type, Integer srcTextureTopLeft, Integer srcTextureTopRight, Integer srcTextureBottomLeft, Integer srcTextureBottomRight, BranchTextureRenderer renderer, int glPackPbo, int pboOffset, ScaledResolution scaledRes) {
        TextureUpload.BranchUpdate upload = !allocate ? this.branchUpdatePool.get(glTexture, glPbo, target, level, internalFormat, width, height, border, pixels_buffer_offset, format, type, srcTextureTopLeft, srcTextureTopRight, srcTextureBottomLeft, srcTextureBottomRight, renderer, glPackPbo, pboOffset, scaledRes) : this.branchUpdateAllocatePool.get(glTexture, glPbo, target, level, internalFormat, width, height, border, pixels_buffer_offset, format, type, srcTextureTopLeft, srcTextureTopRight, srcTextureBottomLeft, srcTextureBottomRight, renderer, glPackPbo, pboOffset, scaledRes);
        return this.requestUpload(upload);
    }

    public long requestBranchDownload(int glTexture, int target, int glPackPbo, int pboOffset) {
        TextureUpload.BranchDownload upload = this.branchDownloadPool.get(glTexture, target, glPackPbo, pboOffset);
        return this.requestUpload(upload);
    }

    public void finishNewestRequestImmediately() {
        TextureUpload newestRequest = this.textureUploadRequests.remove(this.textureUploadRequests.size() - 1);
        newestRequest.run();
        this.addToPool(newestRequest);
    }

    public void uploadTextures() {
        if (!this.textureUploadRequests.isEmpty()) {
            boolean prepared = false;
            for (int i = 0; i < this.textureUploadRequests.size(); ++i) {
                TextureUpload tu = this.textureUploadRequests.get(i);
                int type = tu.getUploadType();
                if (!this.textureUploadBenchmark.isFinished(type)) {
                    if (!prepared) {
                        GL11.glFinish();
                        prepared = true;
                    }
                    this.textureUploadBenchmark.pre();
                }
                tu.run();
                if (!this.textureUploadBenchmark.isFinished(type)) {
                    this.textureUploadBenchmark.post(type);
                    prepared = true;
                }
                this.addToPool(tu);
            }
            this.textureUploadRequests.clear();
        }
    }

    private void addToPool(TextureUpload tu) {
        switch (tu.getUploadType()) {
            case 0: {
                this.normalTextureUploadPool.addToPool((TextureUpload.Normal)tu);
                break;
            }
            case 1: {
                this.normalWithDownloadTextureUploadPool.addToPool((TextureUpload.NormalWithDownload)tu);
                break;
            }
            case 2: {
                this.compressedTextureUploadPool.addToPool((TextureUpload.Compressed)tu);
            }
        }
    }
}

