/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.creeper;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs.DataWatcherHelper;
import toast.specialMobs.Properties;
import toast.specialMobs.entity.ISpecialMob;
import toast.specialMobs.entity.SpecialMobData;

public class Entity_SpecialCreeper
extends EntityCreeper
implements ISpecialMob {
    private static final double CHARGED_CHANCE = Properties.getDouble("_mob_stats", "creeper_charge_chance");
    public static final byte DW_EXPLODE_STATS = DataWatcherHelper.instance.CREEPER.nextKey();
    public static final byte DW_CAN_EXPLODE_IN_WATER = 0;
    public static final byte DW_EXPLODE_ON_FIRE = 1;
    public static final byte DW_EXPLODE_WHEN_SHOT = 2;
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("textures/entity/creeper/creeper.png")};
    public int field_70833_d;
    public int field_70834_e;
    public int field_82225_f = 30;
    public int field_82226_g = 3;
    private boolean playingDead = false;
    private SpecialMobData specialData;

    public Entity_SpecialCreeper(World world) {
        super(world);
    }

    protected void func_70088_a() {
        this.specialData = new SpecialMobData((EntityLiving)this, TEXTURES);
        super.func_70088_a();
        this.field_70180_af.func_75682_a((int)DW_EXPLODE_STATS, (Object)0);
    }

    @Override
    public SpecialMobData getSpecialData() {
        return this.specialData;
    }

    public boolean canNotExplodeWhenWet() {
        return (this.field_70180_af.func_75683_a((int)DW_EXPLODE_STATS) & 1) != 0;
    }

    public void setCanNotExplodeWhenWet(boolean value) {
        if (value != this.canNotExplodeWhenWet()) {
            this.field_70180_af.func_75692_b((int)DW_EXPLODE_STATS, (Object)((byte)(this.field_70180_af.func_75683_a((int)DW_EXPLODE_STATS) ^ 1)));
        }
    }

    public boolean explodesWhenBurning() {
        return (this.field_70180_af.func_75683_a((int)DW_EXPLODE_STATS) & 2) != 0;
    }

    public void setExplodesWhenBurning(boolean value) {
        if (value != this.explodesWhenBurning()) {
            this.field_70180_af.func_75692_b((int)DW_EXPLODE_STATS, (Object)((byte)(this.field_70180_af.func_75683_a((int)DW_EXPLODE_STATS) ^ 2)));
        }
    }

    public boolean explodesWhenShot() {
        return (this.field_70180_af.func_75683_a((int)DW_EXPLODE_STATS) & 4) != 0;
    }

    public void setExplodesWhenShot(boolean value) {
        if (value != this.explodesWhenShot()) {
            this.field_70180_af.func_75692_b((int)DW_EXPLODE_STATS, (Object)((byte)(this.field_70180_af.func_75683_a((int)DW_EXPLODE_STATS) ^ 4)));
        }
    }

    @Override
    public void adjustEntityAttributes() {
        if (this.field_70170_p.func_72911_I() && this.field_70146_Z.nextDouble() < CHARGED_CHANCE) {
            this.field_70180_af.func_75692_b(17, (Object)1);
        }
        float prevMax = this.func_110138_aP();
        this.adjustTypeAttributes();
        this.func_70606_j(this.func_110138_aP() + this.func_110143_aJ() - prevMax);
    }

    protected void adjustTypeAttributes() {
    }

    public boolean func_70089_S() {
        if (this.playingDead) {
            this.playingDead = false;
            return false;
        }
        return super.func_70089_S();
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            if (this.func_70026_G() && this.canNotExplodeWhenWet()) {
                this.func_70829_a(-1);
            } else if (this.func_146078_ca() || this.func_70027_ad() && this.explodesWhenBurning()) {
                this.func_70829_a(1);
            }
            this.field_70834_e = this.field_70833_d;
            int creeperState = this.func_70832_p();
            if (creeperState > 0) {
                if (this.field_70833_d == 0) {
                    this.func_85030_a("creeper.primed", 1.0f, 0.5f);
                }
                this.onExplodingUpdate();
            }
            this.field_70833_d += creeperState;
            if (this.field_70833_d < 0) {
                this.field_70833_d = 0;
            }
            if (this.field_70833_d >= this.field_82225_f) {
                this.field_70833_d = this.field_82225_f;
                if (!this.field_70170_p.field_72995_K) {
                    this.explodeByType(this.func_70830_n(), this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                    this.func_70106_y();
                }
            }
        }
        this.playingDead = true;
        super.func_70071_h_();
    }

    public void onExplodingUpdate() {
    }

    public void explodeByType(boolean powered, boolean griefing) {
        float power = powered ? (float)this.field_82226_g * 2.0f : (float)this.field_82226_g;
        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, power, griefing);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.getSpecialData().onUpdate();
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        return this.getSpecialData().onSpawnWithEgg(data, (EntityLiving)new EntityCreeper(this.field_70170_p));
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (damageSource != null && damageSource.func_76364_f() != damageSource.func_76346_g() && this.explodesWhenShot()) {
            this.func_146079_cb();
        }
        return super.func_70097_a(damageSource, damage);
    }

    public boolean func_70652_k(Entity target) {
        if (super.func_70652_k(target)) {
            this.onTypeAttack(target);
            return true;
        }
        return false;
    }

    protected void onTypeAttack(Entity target) {
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        saveTag.func_74757_a("DryExplode", this.canNotExplodeWhenWet());
        saveTag.func_74757_a("BurningExplode", this.explodesWhenBurning());
        saveTag.func_74757_a("ShotExplode", this.explodesWhenShot());
        this.getSpecialData().isImmuneToFire = this.field_70178_ae;
        this.getSpecialData().writeToNBT(saveTag);
        tag.func_74777_a("Fuse", (short)this.field_82225_f);
        tag.func_74774_a("ExplosionRadius", (byte)this.field_82226_g);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        if (saveTag.func_74764_b("DryExplode")) {
            this.setCanNotExplodeWhenWet(saveTag.func_74767_n("DryExplode"));
        } else if (tag.func_74764_b("DryExplode")) {
            this.setCanNotExplodeWhenWet(tag.func_74767_n("DryExplode"));
        }
        if (saveTag.func_74764_b("BurningExplode")) {
            this.setExplodesWhenBurning(saveTag.func_74767_n("BurningExplode"));
        } else if (tag.func_74764_b("BurningExplode")) {
            this.setExplodesWhenBurning(tag.func_74767_n("BurningExplode"));
        }
        if (saveTag.func_74764_b("ShotExplode")) {
            this.setExplodesWhenShot(saveTag.func_74767_n("ShotExplode"));
        } else if (tag.func_74764_b("ShotExplode")) {
            this.setExplodesWhenShot(tag.func_74767_n("ShotExplode"));
        }
        this.getSpecialData().readFromNBT(tag);
        this.getSpecialData().readFromNBT(saveTag);
        this.field_70178_ae = this.getSpecialData().isImmuneToFire;
        if (tag.func_74764_b("Fuse")) {
            this.field_82225_f = tag.func_74765_d("Fuse");
        }
        if (tag.func_74764_b("ExplosionRadius")) {
            this.field_82226_g = tag.func_74771_c("ExplosionRadius");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70831_j(float partialTick) {
        return ((float)this.field_70834_e + (float)(this.field_70833_d - this.field_70834_e) * partialTick) / (float)(this.field_82225_f - 2);
    }

    protected void func_70628_a(boolean hit, int looting) {
        super.func_70628_a(hit, looting);
    }

    public int func_70658_aO() {
        return Math.min(20, super.func_70658_aO() + this.getSpecialData().armor);
    }

    public void func_70015_d(int time) {
        if (!this.getSpecialData().isImmuneToBurning) {
            super.func_70015_d(time);
        }
    }

    public boolean func_110164_bC() {
        return !this.func_110167_bD() && this.getSpecialData().allowLeashing;
    }

    public void func_70110_aj() {
        if (!this.getSpecialData().isImmuneToWebs) {
            super.func_70110_aj();
        }
    }

    protected void func_70069_a(float distance) {
        if (!this.getSpecialData().isImmuneToFalling) {
            super.func_70069_a(distance);
        }
    }

    public boolean func_145773_az() {
        return this.getSpecialData().ignorePressurePlates;
    }

    public boolean func_70648_aU() {
        return this.getSpecialData().canBreatheInWater;
    }

    public boolean func_96092_aw() {
        return !this.getSpecialData().ignoreWaterPush;
    }

    public boolean func_70687_e(PotionEffect effect) {
        return this.getSpecialData().isPotionApplicable(effect);
    }
}

