/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.inputs;

import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import java.util.LinkedHashMap;
import java.util.Map;

public enum Role {
    INDEPENDENT(Messages.ROLE_INDEPENDENT_TEXT, "independent"),
    MASTER(Messages.ROLE_MASTER_TEXT, "master"),
    SLAVE(Messages.ROLE_SLAVE_TEXT, "slave"),
    SLAVE_CHILD(Messages.ROLE_SLAVE_CHILD_TEXT, "childSlave");

    public final String key;
    public final String name;

    private Role(String name, String key) {
        this.name = name;
        this.key = key;
    }

    public static Role toRole(String key) {
        Role[] roleArray = Role.values();
        int n = roleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Role role = roleArray[n2];
            if (role.key.equals(key)) {
                return role;
            }
            ++n2;
        }
        return INDEPENDENT;
    }

    public static Map<String, String> toMap() {
        LinkedHashMap<String, String> items = new LinkedHashMap<String, String>();
        items.put(Role.INDEPENDENT.key, Role.INDEPENDENT.name);
        items.put(Role.MASTER.key, Role.MASTER.name);
        items.put(Role.SLAVE.key, Role.SLAVE.name);
        items.put(Role.SLAVE_CHILD.key, Role.SLAVE_CHILD.name);
        return items;
    }

    public boolean listensTo(Role role) {
        return this.getCommander() == role;
    }

    public Role getCommander() {
        if (this == SLAVE) {
            return MASTER;
        }
        if (this == SLAVE_CHILD) {
            return SLAVE;
        }
        return null;
    }

    public Object getListener() {
        if (this == MASTER) {
            return SLAVE;
        }
        if (this == SLAVE) {
            return SLAVE_CHILD;
        }
        return null;
    }
}

